/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.python.pydev.builder.PyDevBuilder;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.pycremover.PycRemoverBuilderVisitor;
import org.python.pydev.core.REF;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.plugin.nature.PythonNature;

public abstract class PydevInternalResourceDeltaVisitor
extends PyDevBuilderVisitor
implements IResourceDeltaVisitor {
    public IProgressMonitor monitor;
    public int totalResources;
    public int currentResourcesVisited = 0;

    PydevInternalResourceDeltaVisitor(IProgressMonitor monitor, int totalResources) {
        this.monitor = monitor;
        this.totalResources = totalResources;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta == null) {
            return true;
        }
        IResource resource = delta.getResource();
        if (resource == null) {
            return true;
        }
        int type = resource.getType();
        if (resource.isTeamPrivateMember()) {
            return true;
        }
        if (type == 2) {
            switch (delta.getKind()) {
                case 2: {
                    this.visitRemovedResource(resource, null, this.monitor);
                }
            }
        }
        if (type == 1) {
            String ext = resource.getFileExtension();
            if (ext == null) {
                return true;
            }
            IProject project = resource.getProject();
            PythonNature nature = PythonNature.getPythonNature(project);
            if (project != null && nature != null) {
                if (PythonPathHelper.isValidSourceFile("." + ext)) {
                    boolean isAddOrChange = false;
                    if (isAddOrChange = this.chooseVisit(delta, resource, isAddOrChange)) {
                        ++this.currentResourcesVisited;
                        PyDevBuilder.communicateProgress(this.monitor, this.totalResources, this.currentResourcesVisited, resource, this);
                    }
                } else if (ext.equals("pyc")) {
                    try {
                        new PycRemoverBuilderVisitor().visitAddedResource(resource, null, this.monitor);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        }
        return true;
    }

    protected boolean chooseVisit(IResourceDelta delta, IResource resource, boolean isAddOrChange) {
        switch (delta.getKind()) {
            case 1: {
                this.visitAddedResource(resource, REF.getDocFromResource((IResource)resource), this.monitor);
                isAddOrChange = true;
                break;
            }
            case 4: {
                this.visitChangedResource(resource, REF.getDocFromResource((IResource)resource), this.monitor);
                isAddOrChange = true;
                break;
            }
            case 2: {
                this.visitRemovedResource(resource, null, this.monitor);
            }
        }
        return isAddOrChange;
    }
}

