/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core.edit;

import org.eclipse.text.edits.TextEdit;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.rewriter.RewriterVisitor;
import org.python.pydev.refactoring.ast.visitors.NodeHelper;
import org.python.pydev.refactoring.core.request.IRefactoringRequest;

public abstract class AbstractTextEdit {
    private final String WHITESPACE = " ";
    protected ModuleAdapter moduleAdapter;
    protected IASTNodeAdapter<? extends SimpleNode> offsetAdapter;
    protected NodeHelper nodeHelper;
    protected String newLineDelim;

    protected abstract SimpleNode getEditNode();

    public abstract TextEdit getEdit();

    public abstract int getOffsetStrategy();

    public AbstractTextEdit(IRefactoringRequest req) {
        String newLineDelim = req.getNewLineDelim();
        this.moduleAdapter = req.getOffsetNode().getModule();
        this.offsetAdapter = req.getOffsetNode();
        this.nodeHelper = new NodeHelper(newLineDelim);
        this.newLineDelim = newLineDelim;
    }

    protected String getFormatedNode() {
        SimpleNode node = this.getEditNode();
        String source = RewriterVisitor.createSourceFromAST(node, this.newLineDelim);
        return this.getIndentedSource(node, source, this.getIndent());
    }

    private String getIndentedSource(SimpleNode node, String source, int indent) {
        StringBuffer indented = new StringBuffer();
        String indentation = this.getIndentation(indent);
        indented.append(String.valueOf(this.newLineDelim) + indentation);
        source = source.replaceAll(this.REPLACE_PATTERN(), String.valueOf(this.newLineDelim) + indentation);
        source = source.trim();
        indented.append(source);
        indented.append(this.newLineDelim);
        if (this.nodeHelper.isFunctionDef(node)) {
            indented.append(this.newLineDelim);
        }
        return indented.toString();
    }

    private String REPLACE_PATTERN() {
        return "\\r\\n|\\n|\\r";
    }

    protected String getIndentation(int indent) {
        StringBuffer buf = new StringBuffer();
        while (indent > 1) {
            buf.append(" ");
            --indent;
        }
        return buf.toString();
    }

    protected String getCapitalString(String name) {
        StringBuffer sb = new StringBuffer(name);
        sb.replace(0, 1, name.substring(0, 1).toUpperCase());
        return sb.toString();
    }

    public int getOffset() {
        return this.moduleAdapter.getOffset(this.offsetAdapter, this.getOffsetStrategy());
    }

    public int getIndent() {
        return this.offsetAdapter.getNodeBodyIndent();
    }
}

