/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.rewriter;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.listcompType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.refactoring.ast.printer.SourcePrinter;

public abstract class AbstractRewriterVisitor
extends VisitorBase {
    protected final SourcePrinter printer;
    private SimpleNode previousNode;

    public abstract Object visitAliasType(aliasType var1) throws Exception;

    public abstract Object visitArgumentsType(argumentsType var1) throws Exception;

    public abstract Object visitDecoratorsType(decoratorsType var1) throws Exception;

    public abstract Object visitExceptHandlerType(excepthandlerType var1) throws Exception;

    public abstract Object visitKeywordType(keywordType var1) throws Exception;

    public abstract Object visitListCompType(listcompType var1) throws Exception;

    public abstract Object visitSuiteType(suiteType var1) throws Exception;

    public AbstractRewriterVisitor(OutputStream out, String newLineDelim) {
        this(new SourcePrinter(new PrintWriter(out, true), newLineDelim));
    }

    public AbstractRewriterVisitor(SourcePrinter printer) {
        this.printer = printer;
    }

    public AbstractRewriterVisitor(Writer out, String newLineDelim) {
        this(new SourcePrinter(new PrintWriter(out), newLineDelim));
    }

    protected void enterCall() {
        this.printer.enterCall();
    }

    public void flush() {
        this.printer.flushStream();
    }

    protected SimpleNode getPreviousNode() {
        return this.previousNode;
    }

    protected void handleAfterNode(SimpleNode node) {
        this.printer.prettyPrintAfter(node, this.getPreviousNode());
    }

    protected void handleBeforeNode(SimpleNode node) {
    }

    protected boolean inCall() {
        return this.printer.inCall();
    }

    protected void leaveCall() {
        this.printer.leaveCall();
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.printer.setIgnoreComments(ignoreComments);
    }

    protected void setPreviousNode(SimpleNode lastNode) {
        this.previousNode = lastNode;
    }

    public void traverse(SimpleNode node) throws Exception {
        throw new Exception("Use visit() method");
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        this.printer.print("[unhandled :" + node.toString());
        this.traverse(node);
        return null;
    }

    public SimpleNode visit(SimpleNode node) throws Exception {
        this.handleBeforeNode(node);
        node = this.visitNode(node);
        this.handleAfterNode(node);
        return node;
    }

    protected SimpleNode visitNode(SimpleNode node) throws Exception {
        if (node == null) {
            return null;
        }
        if (node instanceof suiteType) {
            node = (SimpleNode)this.visitSuiteType((suiteType)node);
        } else if (node instanceof decoratorsType) {
            this.visitDecoratorsType((decoratorsType)node);
        } else if (node instanceof keywordType) {
            node = (SimpleNode)this.visitKeywordType((keywordType)node);
        } else if (node instanceof argumentsType) {
            node = (SimpleNode)this.visitArgumentsType((argumentsType)node);
        } else if (node instanceof aliasType) {
            node = (SimpleNode)this.visitAliasType((aliasType)node);
        } else {
            node.accept((VisitorIF)this);
        }
        this.setPreviousNode(node);
        return node;
    }
}

