/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.python.pydev.debug.ui.blocks.MainModuleBlock;
import org.python.pydev.debug.ui.blocks.ProjectBlock;
import org.python.pydev.debug.ui.blocks.PythonPathBlock;
import org.python.pydev.plugin.PydevPlugin;

public class MainModuleTab
extends AbstractLaunchConfigurationTab {
    private final ProjectBlock fProjectBlock = new ProjectBlock();
    private final MainModuleBlock fMainModuleBlock = new MainModuleBlock();
    private final PythonPathBlock fPythonPathBlock = new PythonPathBlock();

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        this.fProjectBlock.createControl(composite);
        this.fMainModuleBlock.createControl(composite);
        this.fPythonPathBlock.createControl(composite);
        this.fProjectBlock.addModifyListener(this.fMainModuleBlock.getProjectModifyListener());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fProjectBlock.initializeFrom(configuration);
        this.fMainModuleBlock.initializeFrom(configuration);
        this.fPythonPathBlock.initializeFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fProjectBlock.performApply(configuration);
        this.fMainModuleBlock.performApply(configuration);
        this.fPythonPathBlock.performApply(configuration);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fProjectBlock.setLaunchConfigurationDialog(dialog);
        this.fMainModuleBlock.setLaunchConfigurationDialog(dialog);
        this.fPythonPathBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String result = super.getErrorMessage();
        if (result == null) {
            result = this.fProjectBlock.getErrorMessage();
        }
        if (result == null) {
            result = this.fMainModuleBlock.getErrorMessage();
        }
        if (result == null) {
            result = this.fPythonPathBlock.getErrorMessage();
        }
        return result;
    }

    public String getMessage() {
        String result = super.getMessage();
        if (result == null) {
            result = this.fProjectBlock.getMessage();
        }
        if (result == null) {
            result = this.fMainModuleBlock.getMessage();
        }
        if (result == null) {
            result = this.fPythonPathBlock.getMessage();
        }
        return result;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean result = super.isValid(launchConfig);
        if (result) {
            result = this.fProjectBlock.isValid(launchConfig);
        }
        if (result) {
            result = this.fMainModuleBlock.isValid(launchConfig);
        }
        if (result) {
            result = this.fPythonPathBlock.isValid(launchConfig);
        }
        return result;
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return PydevPlugin.getImageCache().get("icons/python.gif");
    }
}

