/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import com.rc.retroweaver.runtime.Autobox;
import java.util.HashMap;
import java.util.Map;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NoSelfChecker {
    private FastStack<Integer> scope = new FastStack();
    private FastStack<HashMap<String, Tuple<Expected, FunctionDef>>> maybeNoSelfDefinedItems = new FastStack();
    private FastStack<String> classBases = new FastStack();
    private String moduleName;
    private AbstractScopeAnalyzerVisitor visitor;

    public NoSelfChecker(AbstractScopeAnalyzerVisitor visitor, String moduleName) {
        this.visitor = visitor;
        this.moduleName = moduleName;
        this.scope.push((Object)Autobox.valueOf((int)1));
    }

    public void beforeClassDef(ClassDef node) {
        this.scope.push((Object)Autobox.valueOf((int)4));
        FastStringBuffer buf = new FastStringBuffer();
        exprType[] exprTypeArray = node.bases;
        int n = node.bases.length;
        int n2 = 0;
        while (n2 < n) {
            exprType base = exprTypeArray[n2];
            if (buf.length() > 0) {
                buf.append(",");
            }
            String rep = NodeUtils.getRepresentationString((SimpleNode)base);
            buf.append(FullRepIterable.getLastPart((String)rep));
            ++n2;
        }
        this.classBases.push((Object)buf.toString());
        this.maybeNoSelfDefinedItems.push(new HashMap());
    }

    public void afterClassDef(ClassDef node) {
        this.scope.pop();
        this.classBases.pop();
        this.creteMessagesForStack(this.maybeNoSelfDefinedItems);
    }

    private void creteMessagesForStack(FastStack<HashMap<String, Tuple<Expected, FunctionDef>>> stack) {
        HashMap noDefinedItems = (HashMap)stack.pop();
        for (Map.Entry entry : noDefinedItems.entrySet()) {
            Expected expected = (Expected)((Tuple)entry.getValue()).o1;
            if (expected.expected.equals(expected.received)) continue;
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)((SimpleNode)((Tuple)entry.getValue()).o2), (String)this.moduleName);
            this.visitor.onAddNoSelf(token, new Object[]{token, ((Expected)((Tuple)entry.getValue()).o1).expected});
        }
    }

    public void beforeFunctionDef(FunctionDef node) {
        if (((Integer)this.scope.peek()).equals(Autobox.valueOf((int)4))) {
            String rep;
            exprType arg;
            boolean startsWithSelf = false;
            boolean startsWithCls = false;
            String received = "";
            if (node.args != null && node.args.args.length > 0 && (arg = node.args.args[0]) instanceof Name) {
                Name n = (Name)arg;
                if (n.id.equals("self")) {
                    startsWithSelf = true;
                } else if (n.id.equals("cls")) {
                    startsWithCls = true;
                }
                received = n.id;
            }
            boolean isStaticMethod = false;
            boolean isClassMethod = false;
            if (node.decs != null) {
                decoratorsType[] decoratorsTypeArray = node.decs;
                int n = node.decs.length;
                int n2 = 0;
                while (n2 < n) {
                    String rep2;
                    decoratorsType dec = decoratorsTypeArray[n2];
                    if (dec != null && (rep2 = NodeUtils.getRepresentationString((SimpleNode)dec.func)) != null) {
                        if (rep2.equals("staticmethod")) {
                            isStaticMethod = true;
                        } else if (rep2.equals("classmethod")) {
                            isClassMethod = true;
                        }
                    }
                    ++n2;
                }
            }
            if ((rep = NodeUtils.getRepresentationString((SimpleNode)node)).equals("__new__")) {
                if (!startsWithCls && !startsWithSelf) {
                    ((HashMap)this.maybeNoSelfDefinedItems.peek()).put(rep, new Tuple((Object)new Expected("self or cls", received), (Object)node));
                }
            } else if (!(startsWithSelf || startsWithCls || isStaticMethod || isClassMethod)) {
                ((HashMap)this.maybeNoSelfDefinedItems.peek()).put(rep, new Tuple((Object)new Expected("self", received), (Object)node));
            } else if (startsWithCls && !isClassMethod && !isStaticMethod) {
                String classBase = (String)this.classBases.peek();
                if (!rep.equals("__init__") || !"type".equals(classBase)) {
                    ((HashMap)this.maybeNoSelfDefinedItems.peek()).put(rep, new Tuple((Object)new Expected("self", received), (Object)node));
                }
            }
        }
        this.scope.push((Object)Autobox.valueOf((int)2));
    }

    public void afterFunctionDef(FunctionDef node) {
        this.scope.pop();
    }

    public void visitAssign(Assign node) {
        if (node.targets.length == 1) {
            exprType t = node.targets[0];
            String rep = NodeUtils.getRepresentationString((SimpleNode)t);
            if (rep == null) {
                return;
            }
            if ((Integer)this.scope.peek() != 4) {
                return;
            }
            Tuple tup = (Tuple)((HashMap)this.maybeNoSelfDefinedItems.peek()).get(rep);
            if (tup == null) {
                return;
            }
            FunctionDef def = (FunctionDef)tup.o2;
            if (def == null) {
                return;
            }
            exprType expr = node.value;
            if (expr instanceof Call) {
                String argRep;
                Call call = (Call)expr;
                if (call.args.length == 1 && (argRep = NodeUtils.getRepresentationString((SimpleNode)call.args[0])) != null && argRep.equals(rep)) {
                    String funcCall = NodeUtils.getRepresentationString((SimpleNode)call.func);
                    if (def != null && funcCall != null && funcCall.equals("staticmethod")) {
                        ((HashMap)this.maybeNoSelfDefinedItems.peek()).remove(rep);
                    } else if (funcCall != null && funcCall.equals("classmethod")) {
                        ((Expected)tup.o1).expected = "cls";
                    }
                }
            }
        }
    }

    public static class Expected {
        public String expected;
        public String received;

        public Expected(String expected, String received) {
            this.expected = expected;
            this.received = received;
        }
    }
}

