/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.editor.codecompletion.revisited.SystemASTManager;
import org.python.pydev.plugin.nature.AbstractPythonNature;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class SystemPythonNature
extends AbstractPythonNature
implements IPythonNature {
    private final IInterpreterManager manager;
    public final IInterpreterInfo info;
    private SystemASTManager systemASTManager;
    private IToken[] builtinCompletions;
    private IModule builtinMod;

    public SystemPythonNature(IInterpreterManager manager) throws MisconfigurationException {
        this(manager, manager.getDefaultInterpreterInfo((IProgressMonitor)new NullProgressMonitor()));
    }

    public SystemPythonNature(IInterpreterManager manager, IInterpreterInfo info) {
        this.info = info;
        this.manager = manager;
    }

    public boolean isResourceInPythonpathProjectSources(IResource resource, boolean addExternal) throws MisconfigurationException {
        return super.isResourceInPythonpath(resource);
    }

    public boolean isResourceInPythonpathProjectSources(String resource, boolean addExternal) throws MisconfigurationException {
        return super.isResourceInPythonpath(resource);
    }

    public String resolveModuleOnlyInProjectSources(IResource fileAbsolutePath, boolean addExternal) throws CoreException, MisconfigurationException {
        return super.resolveModule(fileAbsolutePath);
    }

    public String resolveModuleOnlyInProjectSources(String fileAbsolutePath, boolean addExternal) throws CoreException, MisconfigurationException {
        return super.resolveModule(new File(fileAbsolutePath));
    }

    public String getVersion() throws CoreException {
        String version;
        if (this.info != null && (version = this.info.getVersion()) != null && version.startsWith("3")) {
            switch (this.manager.getInterpreterType()) {
                case 0: {
                    return "python 3.0";
                }
                case 1: {
                    return "jython 3.0";
                }
                case 2: {
                    return "python 3.0";
                }
            }
            throw new RuntimeException("Not python nor jython nor iron python?");
        }
        switch (this.manager.getInterpreterType()) {
            case 0: {
                return "python 2.7";
            }
            case 1: {
                return "jython 2.6";
            }
            case 2: {
                return "python 2.7";
            }
        }
        throw new RuntimeException("Not python nor jython nor iron python?");
    }

    public String getDefaultVersion() {
        try {
            return this.getVersion();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void setVersion(String version, String interpreter) throws CoreException {
        throw new RuntimeException("Not Implemented: the system nature is read-only.");
    }

    public int getInterpreterType() throws CoreException {
        return this.manager.getInterpreterType();
    }

    public File getCompletionsCacheDir() {
        throw new RuntimeException("Not Implemented");
    }

    public void saveAstManager() {
        throw new RuntimeException("Not Implemented: system nature is only transient.");
    }

    public IPythonPathNature getPythonPathNature() {
        throw new RuntimeException("Not Implemented");
    }

    public String resolveModule(String file) throws MisconfigurationException {
        InterpreterInfo info = (InterpreterInfo)this.manager.getDefaultInterpreterInfo((IProgressMonitor)new NullProgressMonitor());
        if (info == null) {
            return null;
        }
        return info.getModulesManager().resolveModule(file);
    }

    public ICodeCompletionASTManager getAstManager() {
        if (this.systemASTManager == null) {
            this.systemASTManager = new SystemASTManager(this.manager, this, this.info);
        }
        return this.systemASTManager;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return null;
    }

    public void setProject(IProject project) {
    }

    public void rebuildPath() {
        throw new RuntimeException("Not Implemented");
    }

    public void rebuildPath(String defaultSelectedInterpreter, IProgressMonitor monitor) {
        throw new RuntimeException("Not Implemented");
    }

    public IInterpreterManager getRelatedInterpreterManager() {
        return this.manager;
    }

    public IToken[] getBuiltinCompletions() {
        return this.builtinCompletions;
    }

    public void setBuiltinCompletions(IToken[] toks) {
        this.builtinCompletions = toks;
    }

    public IModule getBuiltinMod() {
        return this.builtinMod;
    }

    public void setBuiltinMod(IModule mod) {
        this.builtinMod = mod;
    }

    public int getGrammarVersion() throws MisconfigurationException {
        IInterpreterInfo info = this.info != null ? this.info : this.manager.getDefaultInterpreterInfo((IProgressMonitor)new NullProgressMonitor());
        if (info != null) {
            return info.getGrammarVersion();
        }
        return 13;
    }

    public IInterpreterInfo getProjectInterpreter() throws MisconfigurationException {
        return this.manager.getDefaultInterpreterInfo(null);
    }

    public boolean isOkToUse() {
        return this.manager != null && this.info != null;
    }
}

