/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.logging.ping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.logging.ping.ILogPing;
import org.python.pydev.logging.ping.ILogPingProvider;
import org.python.pydev.logging.ping.ILogPingSender;
import org.python.pydev.logging.ping.LogInfoProvider;
import org.python.pydev.logging.ping.LogPingSender;
import org.python.pydev.logging.ping.SynchedLogPing;

public class AsyncLogPing
implements ILogPing {
    public static final int SCHEDULE_TIME = 100;
    private final SynchedLogPing internal;
    private List<Object> operations = new ArrayList<Object>();
    private Object lockOperations = new Object();
    private Object lockExecuteCommands = new Object();
    private Job job;

    public AsyncLogPing(String location) {
        this(location, new LogInfoProvider(), new LogPingSender());
    }

    public AsyncLogPing(String location, ILogPingProvider provider, ILogPingSender sender) {
        this(new SynchedLogPing(location, provider, sender));
    }

    public AsyncLogPing(SynchedLogPing logPing) {
        this.internal = logPing;
        this.job = new Job("Consume commands"){

            protected IStatus run(IProgressMonitor monitor) {
                AsyncLogPing.this.consumeAllCommands(true);
                return Status.OK_STATUS;
            }
        };
        this.job.setSystem(true);
        this.job.setPriority(40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPingOpenEditor() {
        String msg = this.internal.createPingOpenEditorEncodedMessage();
        Object object = this.lockOperations;
        synchronized (object) {
            this.operations.add(new Tuple((Object)"addEncodedMessage", (Object)msg));
        }
        this.job.schedule(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPingStartPlugin() {
        String msg = this.internal.createPingStartPluginEncodedMessage();
        Object object = this.lockOperations;
        synchronized (object) {
            this.operations.add(new Tuple((Object)"addEncodedMessage", (Object)msg));
        }
        this.job.schedule(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        Object object = this.lockOperations;
        synchronized (object) {
            this.operations.add("send");
        }
        this.job.schedule(100L);
    }

    public void stop() {
        this.consumeAllCommands(false);
        this.internal.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeAllCommands(boolean send) {
        ArrayList<Object> local;
        Object object = this.lockOperations;
        synchronized (object) {
            local = new ArrayList<Object>(this.operations);
            this.operations.clear();
        }
        object = this.lockExecuteCommands;
        synchronized (object) {
            boolean containsSend = local.contains("send");
            if (containsSend) {
                Iterator<Object> it = local.iterator();
                while (it.hasNext()) {
                    if (!"send".equals(it.next())) continue;
                    it.remove();
                }
            }
            Iterator<Object> iterator = local.iterator();
            while (iterator.hasNext()) {
                Object cmd = iterator.next();
                if (cmd instanceof Tuple) {
                    Tuple tuple = (Tuple)cmd;
                    if ("addEncodedMessage".equals(tuple.o1)) {
                        this.internal.addEncodedMessage((String)tuple.o2);
                        continue;
                    }
                }
                Log.log((String)("Invalid command: " + cmd));
            }
            if (send && containsSend) {
                this.internal.send();
            }
        }
    }
}

