/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django_templates.completions;

import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.editor.common.contentassist.ICommonContentAssistProcessor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.python.pydev.django_templates.completions.templates.DjTemplateCompletionProcessor;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DjContentAssistProcessor
implements IContentAssistProcessor,
ICommonContentAssistProcessor {
    private IContentAssistProcessor htmlContentAssistProcessor;
    private DjTemplateCompletionProcessor templatesContentAssistProcessor;
    private DjTemplateCompletionProcessor templatesTagsContentAssistProcessor;
    private DjTemplateCompletionProcessor templatesFiltersContentAssistProcessor;
    private String contentType;

    public DjContentAssistProcessor(String contentType, IContentAssistProcessor htmlContentAssistProcessor) {
        this.contentType = contentType;
        this.htmlContentAssistProcessor = htmlContentAssistProcessor;
    }

    private DjTemplateCompletionProcessor getTemplatesContentAssistProcessor() {
        if (this.templatesContentAssistProcessor == null) {
            this.templatesContentAssistProcessor = new DjTemplateCompletionProcessor("org.python.pydev.django_templates.templatesContext", PydevPlugin.getImageCache().get("icons/template.gif"), false);
        }
        return this.templatesContentAssistProcessor;
    }

    private DjTemplateCompletionProcessor getTemplatesTagsContentAssistProcessor() {
        if (this.templatesTagsContentAssistProcessor == null) {
            this.templatesTagsContentAssistProcessor = new DjTemplateCompletionProcessor("org.python.pydev.django_templates.tagsTemplatesContext", null, true);
        }
        return this.templatesTagsContentAssistProcessor;
    }

    private DjTemplateCompletionProcessor getTemplatesFiltersContentAssistProcessor() {
        if (this.templatesFiltersContentAssistProcessor == null) {
            this.templatesFiltersContentAssistProcessor = new DjTemplateCompletionProcessor("org.python.pydev.django_templates.filtersTemplatesContext", null, true);
        }
        return this.templatesFiltersContentAssistProcessor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals = null;
        if (this.htmlContentAssistProcessor != null) {
            proposals = this.htmlContentAssistProcessor.computeCompletionProposals(viewer, offset);
        }
        return this.addDjProposals(viewer, offset, proposals);
    }

    public String extractPrefix(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        return this.extractPrefix(document, offset);
    }

    /*
     * Unable to fully structure code
     */
    public String extractPrefix(IDocument document, int offset) {
        i = offset;
        if (i <= document.getLength()) ** GOTO lbl7
        return "";
        {
            while (Character.isJavaIdentifierPart(ch = document.getChar(i - 1)) || ch == '|') {
                --i;
                if (ch == '|') break;
lbl7:
                // 2 sources

                if (i > 0) continue;
            }
            return document.get(i, offset - i);
        }
    }

    private ICompletionProposal[] addDjProposals(ITextViewer viewer, int offset, ICompletionProposal[] proposals) {
        ICompletionProposal p;
        DjTemplateCompletionProcessor processor;
        boolean completionsForTags = true;
        if ("__dj__dftl_partition_content_type".equals(this.contentType)) {
            completionsForTags = true;
        } else if ("__html__dftl_partition_content_type".equals(this.contentType) || "__css___dftl_partition_content_type".equals(this.contentType)) {
            completionsForTags = false;
        } else if ("__dftl_partition_content_type".equals(this.contentType)) {
            IDocument document = viewer.getDocument();
            try {
                for (int discoverOffset = offset; discoverOffset >= 0; --discoverOffset) {
                    String cont = document.getContentType(discoverOffset);
                    if (!"__dj__dftl_partition_content_type".equals(cont)) continue;
                    completionsForTags = true;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                completionsForTags = true;
            }
        }
        String str = this.extractPrefix(viewer, offset);
        if (completionsForTags) {
            if (str.startsWith("|")) {
                processor = this.getTemplatesFiltersContentAssistProcessor();
                str = str.substring(1);
            } else {
                processor = this.getTemplatesTagsContentAssistProcessor();
            }
        } else {
            processor = this.getTemplatesContentAssistProcessor();
        }
        ICompletionProposal[] djProposals = processor.computeCompletionProposals(viewer, offset);
        ArrayList<ICompletionProposal> djProposalsList = new ArrayList<ICompletionProposal>();
        int j = 0;
        while (j < djProposals.length) {
            if (djProposals[j].getDisplayString().startsWith(str)) {
                p = djProposals[j];
                djProposalsList.add(p);
            }
            ++j;
        }
        if (proposals != null && proposals.length > 0) {
            int i = 0;
            while (i < proposals.length) {
                if (proposals[i].getDisplayString().startsWith(str)) {
                    p = proposals[i];
                    djProposalsList.add(p);
                }
                ++i;
            }
        }
        this.setSelectedProposal(str, djProposalsList);
        return djProposalsList.toArray(new ICompletionProposal[djProposalsList.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        ICompletionProposal[] proposals = null;
        if (this.htmlContentAssistProcessor != null) {
            if (this.htmlContentAssistProcessor instanceof ICommonContentAssistProcessor) {
                ICommonContentAssistProcessor commonContentAssistProcessor = (ICommonContentAssistProcessor)this.htmlContentAssistProcessor;
                proposals = commonContentAssistProcessor.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
            } else {
                proposals = this.htmlContentAssistProcessor.computeCompletionProposals(viewer, offset);
            }
        }
        return this.addDjProposals(viewer, offset, proposals);
    }

    protected void setSelectedProposal(String prefix, List<ICompletionProposal> proposals) {
        ICompletionProposal proposal2;
        ICompletionProposal caseSensitiveProposal = null;
        ICompletionProposal caseInsensitiveProposal = null;
        for (ICompletionProposal proposal2 : proposals) {
            String displayString = proposal2.getDisplayString();
            int comparison = displayString.compareToIgnoreCase(prefix);
            if (comparison < 0 || !displayString.toLowerCase().startsWith(prefix.toLowerCase())) continue;
            caseInsensitiveProposal = proposal2;
            if (!displayString.startsWith(prefix)) continue;
            caseSensitiveProposal = proposal2;
            break;
        }
        if (caseSensitiveProposal instanceof ICommonCompletionProposal) {
            ((ICommonCompletionProposal)caseSensitiveProposal).setIsDefaultSelection(true);
        } else if (caseInsensitiveProposal instanceof ICommonCompletionProposal) {
            ((ICommonCompletionProposal)caseInsensitiveProposal).setIsDefaultSelection(true);
        } else if (proposals.size() > 0 && (proposal2 = proposals.get(0)) instanceof ICommonCompletionProposal) {
            ((ICommonCompletionProposal)proposal2).setIsSuggestedSelection(true);
        }
    }
}

