/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IOUtils;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.log.Log;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaSaver<X> {
    private File dirToSaveDeltas;
    private String suffix;
    private List<DeltaCommand> commands;
    private int nCommands;
    private ICallback<Object, ObjectInputStream> readFromFileMethod;

    public DeltaSaver(File dirToSaveDeltas, String extension, ICallback<Object, ObjectInputStream> readFromFileMethod) {
        this.dirToSaveDeltas = dirToSaveDeltas;
        this.suffix = new StringBuffer(".").append(extension).toString();
        this.commands = Collections.synchronizedList(new ArrayList());
        this.readFromFileMethod = readFromFileMethod;
        this.validateDir();
        this.loadDeltas();
    }

    private void validateDir() {
        if (!this.dirToSaveDeltas.exists()) {
            throw new RuntimeException(new StringBuffer("The path passed to save / restore deltas does not exist (").append(this.dirToSaveDeltas).append(")").toString());
        }
        if (!this.dirToSaveDeltas.isDirectory()) {
            throw new RuntimeException(new StringBuffer("The path passed to save / restore deltas is not actually a directory (").append(this.dirToSaveDeltas).append(")").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeltas() {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            ArrayList<File> deltasFound = this.findDeltas();
            for (File file : deltasFound) {
                try {
                    DeltaCommand cmd = (DeltaCommand)IOUtils.readFromFile(file, this.readFromFileMethod);
                    if (cmd == null || cmd.data == null) continue;
                    this.addRestoredCommand(cmd);
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
    }

    private ArrayList<File> findDeltas() {
        File[] files;
        ArrayList<File> deltasFound = new ArrayList<File>();
        File[] fileArray = files = this.dirToSaveDeltas.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists() && file.isFile() && file.getName().endsWith(this.suffix)) {
                deltasFound.add(file);
            }
            ++n2;
        }
        Collections.sort(deltasFound, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String i = FullRepIterable.headAndTail(o1.getName())[0];
                String j = FullRepIterable.headAndTail(o2.getName())[0];
                return new Integer(i).compareTo(new Integer(j));
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((File)object, (File)object2);
            }
        });
        return deltasFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRestoredCommand(DeltaCommand command) {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            this.commands.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(DeltaCommand command) {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            File file = new File(this.dirToSaveDeltas, new StringBuffer(String.valueOf(this.nCommands)).append(this.suffix).toString());
            ++this.nCommands;
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            IOUtils.writeToFile(command, command.data, file);
            this.commands.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int availableDeltas() {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            return this.commands.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            ArrayList<File> deltas = this.findDeltas();
            for (File file : deltas) {
                if (!file.exists()) continue;
                file.delete();
            }
            this.commands.clear();
            this.nCommands = 0;
        }
    }

    public void addInsertCommand(X o) {
        this.addCommand(new DeltaInsertCommand(o));
    }

    public void addDeleteCommand(X o) {
        this.addCommand(new DeltaDeleteCommand(o));
    }

    public void addUpdateCommand(X o) {
        this.addCommand(new DeltaUpdateCommand(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processDeltas(IDeltaProcessor<X> deltaProcessor) {
        List<DeltaCommand> list = this.commands;
        synchronized (list) {
            ArrayList<DeltaCommand> commandsToProcess = new ArrayList<DeltaCommand>(this.commands);
            boolean processed = false;
            for (DeltaCommand cmd : commandsToProcess) {
                try {
                    cmd.processWith(deltaProcessor);
                    processed = false;
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
            if (processed) {
                deltaProcessor.endProcessing();
            }
            this.clearAll();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DeltaCommand
    implements Serializable {
        public transient Object data;

        public abstract void processWith(IDeltaProcessor var1);

        public DeltaCommand(Object o) {
            this.data = o;
        }

        public void readData(ICallback<Object, ObjectInputStream> readFromFileMethod, ObjectInputStream in) {
            this.data = readFromFileMethod.call(in);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeltaDeleteCommand
    extends DeltaCommand {
        private static final long serialVersionUID = 1L;

        public DeltaDeleteCommand(Object o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor deltaProcessor) {
            deltaProcessor.processDelete(this.data);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeltaInsertCommand
    extends DeltaCommand {
        private static final long serialVersionUID = 1L;

        public DeltaInsertCommand(Object o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor deltaProcessor) {
            deltaProcessor.processInsert(this.data);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeltaUpdateCommand
    extends DeltaCommand {
        private static final long serialVersionUID = 1L;

        public DeltaUpdateCommand(Object o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor deltaProcessor) {
            deltaProcessor.processUpdate(this.data);
        }
    }
}

