/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.blocks;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.SimpleRunner;

public class PythonPathBlock
extends AbstractLaunchConfigurationTab {
    private org.eclipse.swt.widgets.List fPythonPathList;

    public void createControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("PYTHONPATH that will be used in the run:");
        this.fPythonPathList = new org.eclipse.swt.widgets.List(parent, 2820);
        GridData gd = new GridData(1808);
        this.fPythonPathList.setLayoutData((Object)gd);
    }

    public String getName() {
        return "Python path";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String id = configuration.getType().getIdentifier();
            IInterpreterManager manager = null;
            if ("org.python.pydev.debug.jythonLaunchConfigurationType".equals(id) || "org.python.pydev.debug.jythonUnittestLaunchConfigurationType".equals(id)) {
                manager = PydevPlugin.getJythonInterpreterManager();
            } else if ("org.python.pydev.debug.ironpythonLaunchConfigurationType".equals(id) || "org.python.pydev.debug.ironpythonUnittestLaunchConfigurationType".equals(id)) {
                manager = PydevPlugin.getIronpythonInterpreterManager();
            } else if ("org.python.pydev.debug.regularLaunchConfigurationType".equals(id) || "org.python.pydev.debug.coverageLaunchConfigurationType".equals(id) || "org.python.pydev.debug.unittestLaunchConfigurationType".equals(id)) {
                manager = PydevPlugin.getPythonInterpreterManager();
            } else {
                try {
                    IProject project = PythonRunnerConfig.getProjectFromConfiguration(configuration);
                    PythonNature nature = PythonNature.getPythonNature((IProject)project);
                    if (nature != null) {
                        manager = PydevPlugin.getInterpreterManager((IPythonNature)nature);
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                if (manager == null) {
                    Log.log((String)("Could not recognize: '" + id + "' using default python interpreter manager."));
                    manager = PydevPlugin.getPythonInterpreterManager();
                }
            }
            String pythonPath = PythonRunnerConfig.getPythonpathFromConfiguration(configuration, manager);
            this.fPythonPathList.removeAll();
            List paths = SimpleRunner.splitPythonpath((String)pythonPath);
            Iterator iterator = paths.iterator();
            while (iterator.hasNext()) {
                String p = (String)iterator.next();
                this.fPythonPathList.add(p);
            }
            this.setErrorMessage(null);
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
            String message = e.getMessage();
            if (message == null) {
                message = "null (see error log for the traceback).";
            }
            String errorMsg = StringUtils.replaceNewLines((String)message, (String)" ");
            this.fPythonPathList.removeAll();
            this.fPythonPathList.add(errorMsg);
            this.setErrorMessage(errorMsg);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.initializeFrom((ILaunchConfiguration)configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }
}

