/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.prefs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.plugin.preferences.IPydevPreferencesProvider;

public class ColorManager {
    private static ColorManager fgColorManager;
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    private ColorManager() {
    }

    public static ColorManager getDefault() {
        if (fgColorManager == null) {
            fgColorManager = new ColorManager();
        }
        return fgColorManager;
    }

    private Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    private Color getPreferenceColor(String type) {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)type));
    }

    public TextAttribute getConsoleErrorTextAttribute() {
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_preferences_provider");
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            IPydevPreferencesProvider iPydevPreferencesProvider = (IPydevPreferencesProvider)iterator.next();
            TextAttribute textAttribute = iPydevPreferencesProvider.getConsoleErrorTextAttribute();
            if (textAttribute == null) continue;
            return textAttribute;
        }
        Color color = this.getPreferenceColor("pydevconsole_syserr_color");
        return new TextAttribute(color, null, 0);
    }

    public TextAttribute getConsoleOutputTextAttribute() {
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_preferences_provider");
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            IPydevPreferencesProvider iPydevPreferencesProvider = (IPydevPreferencesProvider)iterator.next();
            TextAttribute textAttribute = iPydevPreferencesProvider.getConsoleOutputTextAttribute();
            if (textAttribute == null) continue;
            return textAttribute;
        }
        Color color = this.getPreferenceColor("pydevconsole_sysout_color");
        return new TextAttribute(color, null, 0);
    }

    public TextAttribute getConsoleInputTextAttribute() {
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_preferences_provider");
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            IPydevPreferencesProvider iPydevPreferencesProvider = (IPydevPreferencesProvider)iterator.next();
            TextAttribute textAttribute = iPydevPreferencesProvider.getConsoleInputTextAttribute();
            if (textAttribute == null) continue;
            return textAttribute;
        }
        Color color = this.getPreferenceColor("pydevconsole_sysin_color");
        return new TextAttribute(color, null, 0);
    }

    public TextAttribute getConsolePromptTextAttribute() {
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_preferences_provider");
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            IPydevPreferencesProvider iPydevPreferencesProvider = (IPydevPreferencesProvider)iterator.next();
            TextAttribute textAttribute = iPydevPreferencesProvider.getConsolePromptTextAttribute();
            if (textAttribute == null) continue;
            return textAttribute;
        }
        Color color = this.getPreferenceColor("pydevconsole_prompt_color");
        return new TextAttribute(color, null, 0);
    }

    public Color getConsoleBackgroundColor() {
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_preferences_provider");
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            IPydevPreferencesProvider iPydevPreferencesProvider = (IPydevPreferencesProvider)iterator.next();
            RGB textAttribute = iPydevPreferencesProvider.getConsoleBackgroundRGB();
            if (textAttribute == null) continue;
            return this.getColor(textAttribute);
        }
        Color color = this.getPreferenceColor("pydevconsole_background_color");
        return color;
    }

    public TextAttribute getHyperlinkTextAttribute() {
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_preferences_provider");
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            IPydevPreferencesProvider iPydevPreferencesProvider = (IPydevPreferencesProvider)iterator.next();
            TextAttribute textAttribute = iPydevPreferencesProvider.getHyperlinkTextAttribute();
            if (textAttribute == null) continue;
            return textAttribute;
        }
        return null;
    }

    public TextAttribute getForegroundTextAttribute() {
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_preferences_provider");
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            IPydevPreferencesProvider iPydevPreferencesProvider = (IPydevPreferencesProvider)iterator.next();
            TextAttribute textAttribute = iPydevPreferencesProvider.getCodeTextAttribute();
            if (textAttribute == null) continue;
            return textAttribute;
        }
        return null;
    }
}

