/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename.visitors;

import java.util.Stack;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.Visitor;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;

public class FindCallVisitor
extends Visitor {
    private Name name;
    private NameTok nameTok;
    private Call call;
    private Stack<Call> lastCall = new Stack();

    public FindCallVisitor(Name name) {
        this.name = name;
    }

    public FindCallVisitor(NameTok nameTok) {
        this.nameTok = nameTok;
    }

    public Call getCall() {
        return this.call;
    }

    public Object visitCall(Call node) throws Exception {
        if (this.call != null) {
            return null;
        }
        if (node.func == this.name) {
            this.call = node;
        } else if (this.nameTok != null) {
            this.lastCall.push(node);
            Object r = super.visitCall(node);
            this.lastCall.pop();
            if (this.call != null) {
                return null;
            }
            return r;
        }
        if (this.call != null) {
            return null;
        }
        return super.visitCall(node);
    }

    public Object visitNameTok(NameTok node) throws Exception {
        if (node == this.nameTok) {
            if (this.lastCall.size() > 0) {
                this.call = this.lastCall.peek();
            }
            return null;
        }
        return super.visitNameTok(node);
    }

    public static Call findCall(NameTok nametok, SimpleNode root) {
        FindCallVisitor visitor = new FindCallVisitor(nametok);
        try {
            visitor.traverse(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return visitor.call;
    }

    public static Call findCall(Name name, SimpleNode root) {
        FindCallVisitor visitor = new FindCallVisitor(name);
        try {
            visitor.traverse(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return visitor.call;
    }
}

