/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.wizards.rename;

import com.python.pydev.refactoring.wizards.IRefactorRenameProcess;
import com.python.pydev.refactoring.wizards.RefactorProcessFactory;
import com.python.pydev.refactoring.wizards.rename.TextEditCreation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.scope.ASTEntry;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyRenameEntryPoint
extends RenameProcessor {
    public static final Set<String> WORDS_THAT_CANNOT_BE_RENAMED;
    private RefactoringRequest request;
    private CompositeChange fChange;
    public List<IRefactorRenameProcess> process;
    public static final String IDENTIFIER = "org.python.pydev.pyRename";
    public static final boolean DEBUG = false;
    static RefactoringParticipant[] EMPTY_REFACTORING_PARTICIPANTS;

    static {
        String[] wordsThatCannotbeRenamed;
        WORDS_THAT_CANNOT_BE_RENAMED = new HashSet<String>();
        String[] stringArray = wordsThatCannotbeRenamed = new String[]{"and", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "exec", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "not", "or", "pass", "print", "raise", "return", "try", "while", "with", "yield", "as"};
        int n = wordsThatCannotbeRenamed.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            WORDS_THAT_CANNOT_BE_RENAMED.add(string);
            ++n2;
        }
        EMPTY_REFACTORING_PARTICIPANTS = new RefactoringParticipant[0];
    }

    public PyRenameEntryPoint(RefactoringRequest request) {
        this.request = request;
    }

    public Object[] getElements() {
        return new Object[]{this.request};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return "Pydev PyRenameProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.request.pushMonitor(pm);
        this.request.getMonitor().beginTask("Checking refactoring pre-conditions...", 100);
        RefactoringStatus status = new RefactoringStatus();
        try {
            if (!StringUtils.isWord((String)this.request.initialName)) {
                status.addFatalError(new StringBuffer("The initial name is not valid:").append(this.request.initialName).toString());
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (WORDS_THAT_CANNOT_BE_RENAMED.contains(this.request.initialName)) {
                status.addFatalError(new StringBuffer("The token: ").append(this.request.initialName).append(" cannot be renamed.").toString());
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.request.inputName != null && !StringUtils.isWord((String)this.request.inputName)) {
                status.addFatalError(new StringBuffer("The new name is not valid:").append(this.request.inputName).toString());
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            SimpleNode ast = this.request.getAST();
            if (ast == null) {
                status.addFatalError("AST not generated (syntax error).");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
            this.request.communicateWork("Finding definition");
            ItemPointer[] pointers = pyRefactoring.findDefinition(this.request);
            this.process = new ArrayList<IRefactorRenameProcess>();
            if (pointers.length == 0) {
                IRefactorRenameProcess p = RefactorProcessFactory.getRenameAnyProcess();
                this.process.add(p);
            } else {
                ItemPointer[] itemPointerArray = pointers;
                int n = pointers.length;
                int n2 = 0;
                while (n2 < n) {
                    IRefactorRenameProcess p;
                    ItemPointer pointer = itemPointerArray[n2];
                    if (pointer.definition == null) {
                        status.addFatalError(new StringBuffer("The definition found is not valid. ").append(pointer).toString());
                    }
                    if ((p = RefactorProcessFactory.getProcess(pointer.definition, this.request.nature)) == null) {
                        status.addFatalError(new StringBuffer("Refactoring Process not defined: the definition found is not valid:").append(pointer.definition).toString());
                        RefactoringStatus refactoringStatus = status;
                        return refactoringStatus;
                    }
                    this.process.add(p);
                    ++n2;
                }
            }
            if (this.process == null || this.process.size() == 0) {
                status.addFatalError("Refactoring Process not defined: the pre-conditions were not satisfied.");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        finally {
            this.request.popMonitor().done();
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return this.checkFinalConditions(pm, context, true);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context, boolean fillChangeObject) throws CoreException, OperationCanceledException {
        this.request.pushMonitor(pm);
        RefactoringStatus status = new RefactoringStatus();
        try {
            if (this.process == null || this.process.size() == 0) {
                status.addFatalError("Refactoring Process not defined: the refactoring cycle did not complet correctly.");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            this.fChange = new CompositeChange(new StringBuffer("RenameChange: '").append(this.request.initialName).append("' to '").append(this.request.inputName).append("'").toString());
            this.request.getMonitor().beginTask("Finding references", 200 * this.process.size());
            for (IRefactorRenameProcess p : this.process) {
                this.request.checkCancelled();
                p.findReferencesToRename(this.request, status);
                if (!status.hasFatalError() && !this.request.getMonitor().isCanceled()) continue;
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (fillChangeObject) {
                TextEditCreation textEditCreation = new TextEditCreation(this.request.initialName, this.request.inputName, this.request.getModule().getName(), this.request.getDoc(), this.process, status, this.fChange, this.request.getIFile());
                textEditCreation.fillRefactoringChangeObject(this.request, context);
                if (status.hasFatalError() || this.request.getMonitor().isCanceled()) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        finally {
            this.request.popMonitor().done();
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.fChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return EMPTY_REFACTORING_PARTICIPANTS;
    }

    public HashSet<ASTEntry> getOccurrences() {
        if (this.process == null || this.process.size() == 0) {
            return null;
        }
        HashSet<ASTEntry> occurrences = new HashSet<ASTEntry>();
        for (IRefactorRenameProcess p : this.process) {
            HashSet<ASTEntry> o = p.getOccurrences();
            if (o == null) continue;
            occurrences.addAll(o);
        }
        return occurrences;
    }

    public Map<Tuple<String, IFile>, HashSet<ASTEntry>> getOccurrencesInOtherFiles() {
        HashMap<Tuple<String, IFile>, HashSet<ASTEntry>> m = new HashMap<Tuple<String, IFile>, HashSet<ASTEntry>>();
        if (this.process == null || this.process.size() == 0) {
            return null;
        }
        for (IRefactorRenameProcess p : this.process) {
            Map<Tuple<String, IFile>, HashSet<ASTEntry>> o = p.getOccurrencesInOtherFiles();
            if (o == null) continue;
            for (Map.Entry<Tuple<String, IFile>, HashSet<ASTEntry>> entry : o.entrySet()) {
                Tuple<String, IFile> key = entry.getKey();
                HashSet<Object> existingOccurrences = m.get(key);
                if (existingOccurrences == null) {
                    existingOccurrences = new HashSet();
                    m.put(key, existingOccurrences);
                }
                existingOccurrences.addAll((Collection<ASTEntry>)entry.getValue());
            }
        }
        return m;
    }
}

