/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.ui.findreplace;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;

public class FindInOpenDocuments {
    public static void findInOpenDocuments(final String searchText, final boolean caseSensitive, boolean wholeWord, final boolean isRegEx, IStatusLineManager statusLineManager) {
        IWorkbenchWindow window = PyAction.getActiveWorkbenchWindow();
        if (window == null) {
            if (statusLineManager != null) {
                statusLineManager.setErrorMessage("Active workbench window is null.");
            }
            return;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            if (statusLineManager != null) {
                statusLineManager.setErrorMessage("Active page is null.");
            }
            return;
        }
        IEditorReference[] editorsArray = activePage.getEditorReferences();
        final ArrayList<IFile> files = new ArrayList<IFile>();
        int i = 0;
        while (i < editorsArray.length) {
            IEditorPart realEditor = editorsArray[i].getEditor(true);
            if (realEditor != null) {
                if (realEditor instanceof MultiPageEditorPart) {
                    try {
                        Method getPageCount = ClassLiteral.getClass((String)"org/eclipse/ui/part/MultiPageEditorPart").getDeclaredMethod("getPageCount", new Class[0]);
                        getPageCount.setAccessible(true);
                        Method getEditor = ClassLiteral.getClass((String)"org/eclipse/ui/part/MultiPageEditorPart").getDeclaredMethod("getEditor", Integer.TYPE);
                        getEditor.setAccessible(true);
                        Integer pageCount = (Integer)getPageCount.invoke((Object)realEditor, new Object[0]);
                        int j = 0;
                        while (j < pageCount) {
                            IFile file;
                            IEditorInput input;
                            IEditorPart part = (IEditorPart)getEditor.invoke((Object)realEditor, Autobox.valueOf((int)j));
                            if (part != null && (input = part.getEditorInput()) != null && (file = (IFile)input.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"))) != null) {
                                files.add(file);
                            }
                            ++j;
                        }
                    }
                    catch (Throwable e1) {
                        Log.log((Throwable)e1);
                    }
                } else {
                    IEditorInput input = realEditor.getEditorInput();
                    if (input != null) {
                        IFile file = (IFile)input.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
                        if (file != null) {
                            files.add(file);
                        } else if (statusLineManager != null) {
                            statusLineManager.setMessage("Warning: Editors not in the workspace cannot be searched.");
                        }
                    }
                }
            }
            ++i;
        }
        if (files.size() == 0) {
            if (statusLineManager != null) {
                statusLineManager.setMessage("No file was found to perform the search (editors not in the workspace cannot be searched).");
            }
            return;
        }
        try {
            ISearchQuery query = TextSearchQueryProvider.getPreferred().createQuery(new TextSearchQueryProvider.TextSearchInput(){

                public boolean isRegExSearch() {
                    return isRegEx;
                }

                public boolean isCaseSensitiveSearch() {
                    return caseSensitive;
                }

                public String getSearchText() {
                    return searchText;
                }

                public FileTextSearchScope getScope() {
                    return FileTextSearchScope.newSearchScope((IResource[])files.toArray(new IResource[files.size()]), (String[])new String[]{"*"}, (boolean)true);
                }
            });
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
        catch (CoreException e1) {
            PydevPlugin.log((Throwable)e1);
        }
    }
}

