/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.container;

import com.rc.retroweaver.runtime.Autobox;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.actions.container.PyContainerAction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySourceFormatAction
extends PyContainerAction {
    private IFormatter formatter;
    private Set<IFile> openFiles;

    @Override
    protected boolean needsUIThread() {
        return false;
    }

    private Set<IFile> getOpenFiles() {
        HashSet<IFile> ret = new HashSet<IFile>();
        IWorkbenchPage[] pages = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int i = 0;
        while (i < pages.length) {
            IEditorReference[] editorReferences = pages[i].getEditorReferences();
            int j = 0;
            while (j < editorReferences.length) {
                PyEdit e;
                IFile file;
                IEditorPart ed = editorReferences[j].getEditor(false);
                if (ed instanceof PyEdit && (file = (e = (PyEdit)ed).getIFile()) != null) {
                    ret.add(file);
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    @Override
    protected void beforeRun() {
        this.openFiles = this.getOpenFiles();
        PyFormatStd std = new PyFormatStd();
        this.formatter = std.getFormatter();
    }

    @Override
    protected int doActionOnContainer(IContainer container, IProgressMonitor monitor) {
        int formatted = 0;
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                IResource c = iResourceArray[n2];
                if (monitor.isCanceled()) break;
                monitor.worked(1);
                if (c instanceof IContainer) {
                    formatted += this.doActionOnContainer((IContainer)c, monitor);
                } else if (c instanceof IFile && (name = c.getName()) != null) {
                    monitor.setTaskName(new StringBuffer("Formatting: ").append(name).toString());
                    if (PythonPathHelper.isValidSourceFile(name)) {
                        IFile file = (IFile)c;
                        final IDocument doc = REF.getDocFromResource((IResource)c);
                        final boolean isOpenedFile = this.openFiles.contains(file);
                        try {
                            if (isOpenedFile) {
                                RunInUiThread.async((Runnable)new Runnable(){

                                    public void run() {
                                        try {
                                            PySourceFormatAction.this.formatter.formatAll(doc, null, isOpenedFile, true);
                                        }
                                        catch (SyntaxErrorException e) {
                                            Log.log((int)4, (String)("Could not source-format file: " + name + " (invalid syntax)."), (Throwable)e);
                                        }
                                    }
                                });
                            } else {
                                this.formatter.formatAll(doc, null, isOpenedFile, true);
                            }
                        }
                        catch (SyntaxErrorException e) {
                            Log.log((int)4, (String)new StringBuffer("Could not source-format file: ").append(name).append(" (invalid syntax).").toString(), (Throwable)e);
                        }
                        ++formatted;
                        if (!isOpenedFile) {
                            file.setContents((InputStream)new ByteArrayInputStream(doc.get().getBytes()), true, true, monitor);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
        }
        return formatted;
    }

    @Override
    protected void afterRun(int formatted) {
        this.openFiles = null;
        this.formatter = null;
        MessageDialog.openInformation(null, (String)"Files formatted", (String)StringUtils.format((String)"Formatted %s files.", (Object[])new Object[]{Autobox.valueOf((int)formatted)}));
    }

    @Override
    protected boolean confirmRun() {
        return MessageDialog.openConfirm(null, (String)"Confirm source formatting", (String)"Are you sure that you want to recursively apply the source formatting to python files from the selected folder(s)?\n\nIt'll be applied to all the file-types specified in the preferences: pydev > code style > file types.\n\nThis action cannot be undone.");
    }
}

