/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.shell;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.REF;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleIronpythonRunner;

public class IronpythonShell
extends AbstractShell {
    public IronpythonShell() throws IOException, CoreException {
        super(PydevPlugin.getScriptWithinPySrc("pycompletionserver.py"));
    }

    protected synchronized String createServerProcess(IInterpreterInfo interpreter, int pWrite, int pRead) throws IOException {
        File file = new File(interpreter.getExecutableOrJar());
        if (!file.exists()) {
            throw new RuntimeException("The interpreter location found does not exist. " + interpreter);
        }
        if (file.isDirectory()) {
            throw new RuntimeException("The interpreter location found is a directory. " + interpreter);
        }
        String execMsg = REF.isWindowsPlatform() ? interpreter + " \"" + REF.getFileAbsolutePath((File)this.serverFile) + "\" " + pWrite + " " + pRead : interpreter + " " + REF.getFileAbsolutePath((File)this.serverFile) + " " + pWrite + " " + pRead;
        String[] parameters = SimpleIronpythonRunner.preparePythonCallParameters(interpreter.getExecutableOrJar(), REF.getFileAbsolutePath((File)this.serverFile), new String[]{"" + pWrite, "" + pRead}, true);
        IInterpreterManager manager = PydevPlugin.getIronpythonInterpreterManager();
        String[] envp = null;
        try {
            envp = new SimpleIronpythonRunner().getEnvironment(null, interpreter, manager);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        this.process = SimpleIronpythonRunner.createProcess(parameters, envp, this.serverFile.getParentFile());
        return execMsg;
    }
}

