/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.debug.newconsole.IPydevXmlRpcClient;
import org.python.pydev.debug.newconsole.PydevXmlRpcClient;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.dltk.console.IScriptConsoleCommunication;
import org.python.pydev.dltk.console.InterpreterResponse;
import org.python.pydev.editor.codecompletion.AbstractPyCodeCompletion;
import org.python.pydev.editor.codecompletion.PyCalltipsContextInformation;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.PyLinkedModeCompletionProposal;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.ThreadStreamReader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevConsoleCommunication
implements IScriptConsoleCommunication,
XmlRpcHandler {
    private IPydevXmlRpcClient client;
    private final ThreadStreamReader stdOutReader;
    private final ThreadStreamReader stdErrReader;
    private WebServer webServer;
    private volatile boolean waitingForInput;
    private volatile String inputReceived;
    private volatile InterpreterResponse nextResponse;
    private volatile Object lock = new Object();
    private volatile Object lock2 = new Object();
    private volatile boolean firstCommWorked = false;

    public PydevConsoleCommunication(int port, Process process, int clientPort) throws Exception {
        this.stdOutReader = new ThreadStreamReader(process.getInputStream());
        this.stdErrReader = new ThreadStreamReader(process.getErrorStream());
        this.stdOutReader.start();
        this.stdErrReader.start();
        this.webServer = new WebServer(clientPort);
        XmlRpcStreamServer serverToHandleRawInput = this.webServer.getXmlRpcServer();
        serverToHandleRawInput.setHandlerMapping(new XmlRpcHandlerMapping(){

            public XmlRpcHandler getHandler(String handlerName) throws XmlRpcNoSuchHandlerException, XmlRpcException {
                return PydevConsoleCommunication.this;
            }
        });
        this.webServer.start();
        PydevXmlRpcClient client = new PydevXmlRpcClient(process, this.stdErrReader, this.stdOutReader);
        client.setPort(port);
        this.client = client;
    }

    public void close() throws Exception {
        if (this.client != null) {
            Job job = new Job("Close console communication"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        PydevConsoleCommunication.this.client.execute("close", new Object[0]);
                    }
                    catch (Exception exception) {}
                    PydevConsoleCommunication.this.client = null;
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        if (this.webServer != null) {
            this.webServer.shutdown();
            this.webServer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(XmlRpcRequest request) throws XmlRpcException {
        this.waitingForInput = true;
        this.inputReceived = null;
        boolean needInput = true;
        this.nextResponse = new InterpreterResponse(this.stdOutReader.getAndClearContents(), this.stdErrReader.getAndClearContents(), false, needInput);
        while (this.inputReceived == null) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException e) {
                    PydevPlugin.log((Throwable)e);
                }
            }
        }
        return this.inputReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execInterpreter(final String command, ICallback<Object, InterpreterResponse> onResponseReceived) {
        this.nextResponse = null;
        if (this.waitingForInput) {
            this.inputReceived = command;
            this.waitingForInput = false;
        } else {
            Job job = new Job("Pydev Console Communication"){

                private Tuple<String, Boolean> exec() throws XmlRpcException {
                    boolean more;
                    Object[] execute = (Object[])PydevConsoleCommunication.this.client.execute("addExec", new Object[]{command});
                    Object object = execute[0];
                    String errorContents = null;
                    if (object instanceof Boolean) {
                        more = (Boolean)object;
                    } else {
                        String str = object.toString();
                        String lower = str.toLowerCase();
                        if (lower.equals("true") || lower.equals("1")) {
                            more = true;
                        } else if (lower.equals("false") || lower.equals("0")) {
                            more = false;
                        } else {
                            more = false;
                            errorContents = str;
                        }
                    }
                    return new Tuple(errorContents, (Object)Autobox.valueOf((boolean)more));
                }

                protected IStatus run(IProgressMonitor monitor) {
                    boolean needInput = false;
                    try {
                        Tuple<String, Boolean> executed = null;
                        int commAttempts = 0;
                        int maximumAttempts = InteractiveConsolePrefs.getMaximumAttempts();
                        while (true) {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            executed = this.exec();
                            String refusedConnPattern = "Failed to read servers response";
                            if (executed.o1 == null || ((String)executed.o1).indexOf(refusedConnPattern) == -1 || PydevConsoleCommunication.this.firstCommWorked || commAttempts >= maximumAttempts) break;
                            ++commAttempts;
                            Thread.sleep(250L);
                            executed.o1 = PydevConsoleCommunication.this.stdErrReader.getAndClearContents();
                        }
                        PydevConsoleCommunication.this.firstCommWorked = true;
                        String errorContents = (String)executed.o1;
                        boolean more = (Boolean)executed.o2;
                        if (errorContents == null) {
                            errorContents = PydevConsoleCommunication.this.stdErrReader.getAndClearContents();
                        }
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(PydevConsoleCommunication.this.stdOutReader.getAndClearContents(), errorContents, more, needInput);
                    }
                    catch (Exception e) {
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse("", new StringBuffer("Exception while pushing line to console:").append(e.getMessage()).toString(), false, needInput);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        while (this.nextResponse == null) {
            Object object = this.lock2;
            synchronized (object) {
                try {
                    this.lock2.wait(20L);
                }
                catch (InterruptedException e) {
                    PydevPlugin.log((Throwable)e);
                }
            }
        }
        onResponseReceived.call((Object)this.nextResponse);
    }

    public ICompletionProposal[] getCompletions(String text, int offset) throws Exception {
        if (this.waitingForInput) {
            return new ICompletionProposal[0];
        }
        Object fromServer = this.client.execute("getCompletions", new Object[]{text});
        ArrayList<ICompletionProposal> ret = new ArrayList<ICompletionProposal>();
        PydevConsoleCommunication.convertToICompletions(text, offset, fromServer, ret);
        ICompletionProposal[] proposals = ret.toArray(new ICompletionProposal[ret.size()]);
        return proposals;
    }

    public static void convertToICompletions(String text, int offset, Object fromServer, List<ICompletionProposal> ret) {
        if (fromServer instanceof Object[]) {
            Object[] objects = (Object[])fromServer;
            fromServer = Arrays.asList(objects);
        }
        if (fromServer instanceof List) {
            int length = text.lastIndexOf(46);
            length = length == -1 ? text.length() : text.length() - length - 1;
            List<Object> comps = fromServer;
            for (Object o : comps) {
                if (!(o instanceof Object[])) continue;
                Object[] comp = (Object[])o;
                String name = (String)comp[0];
                String docStr = (String)comp[1];
                int type = PydevConsoleCommunication.extractInt(comp[3]);
                String args = AbstractPyCodeCompletion.getArgs((String)((String)comp[2]), (int)type, (int)1);
                String nameAndArgs = new StringBuffer(String.valueOf(name)).append(args).toString();
                int priority = 10;
                if (type == 5) {
                    priority = -1;
                }
                int cursorPos = name.length();
                if (args.length() > 1) {
                    ++cursorPos;
                }
                int replacementOffset = offset - length;
                PyCalltipsContextInformation pyContextInformation = null;
                if (args.length() > 2) {
                    pyContextInformation = new PyCalltipsContextInformation(args, replacementOffset + name.length() + 1);
                }
                ret.add((ICompletionProposal)new PyLinkedModeCompletionProposal(nameAndArgs, replacementOffset, length, cursorPos, PyCodeCompletionImages.getImageForType((int)type), nameAndArgs, (IContextInformation)pyContextInformation, docStr, priority, 1, args, false));
            }
        }
    }

    private static int extractInt(Object objToGetInt) {
        if (objToGetInt instanceof Integer) {
            return (Integer)objToGetInt;
        }
        return Integer.parseInt(objToGetInt.toString());
    }

    public String getDescription(String text) throws Exception {
        if (this.waitingForInput) {
            return "Unable to get description: waiting for input.";
        }
        return this.client.execute("getDescription", new Object[]{text}).toString();
    }
}

