/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.messages;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.messages.AbstractMessage;
import com.python.pydev.analysis.messages.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.core.IToken;
import org.python.pydev.core.structure.FastStringBuffer;

public class CompositeMessage
extends AbstractMessage {
    List<IMessage> msgs = new ArrayList<IMessage>();
    public static int MAXIMUM_NUMBER_OF_INTERNAL_MESSAGES = 15;
    private boolean addSupressMessage = false;
    private String shortMessage;

    public CompositeMessage(int type, IToken generator, IAnalysisPreferences prefs) {
        super(type, generator, prefs);
    }

    public void addMessage(IMessage msg) {
        if (this.shortMessage != null) {
            throw new RuntimeException("Cannot add more messages after it's own short message was requested.");
        }
        if (this.msgs.size() > MAXIMUM_NUMBER_OF_INTERNAL_MESSAGES) {
            this.addSupressMessage = true;
            return;
        }
        if (!this.msgs.contains(msg)) {
            this.msgs.add(msg);
        }
    }

    public String getShortMessage() {
        if (this.shortMessage == null) {
            FastStringBuffer buffer = new FastStringBuffer(this.msgs.size() * 40);
            ArrayList<String> messages = new ArrayList<String>();
            Iterator<IMessage> iter = this.msgs.iterator();
            while (iter.hasNext()) {
                IMessage msg = iter.next();
                messages.add(msg.getShortMessage().toString());
            }
            Collections.sort(messages);
            iter = messages.iterator();
            while (iter.hasNext()) {
                buffer.append((String)((Object)iter.next()));
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
            if (this.addSupressMessage) {
                buffer.append("... others suppressed");
            }
            this.shortMessage = buffer.toString();
        }
        return this.shortMessage;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeMessage)) {
            return false;
        }
        CompositeMessage m = (CompositeMessage)obj;
        return m.getMessage().equals(this.getMessage());
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }

    public /* synthetic */ Object getShortMessage() {
        return this.getShortMessage();
    }
}

