/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.builder.AnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.AnalysisBuilderRunnableForRemove;
import com.python.pydev.analysis.builder.IAnalysisBuilderRunnable;
import com.python.pydev.analysis.builder.KeyForAnalysisRunnable;
import com.rc.retroweaver.runtime.Autobox;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.cache.LRUCache;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.log.Log;
import org.python.pydev.logging.DebugSettings;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisBuilderRunnableFactory {
    private static volatile Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> availableThreads;
    private static volatile LRUCache<KeyForAnalysisRunnable, Tuple<Long, Long>> analysisTimeCache;
    private static final int DELTA_TO_CONSIDER_SAME = 500;

    static {
        analysisTimeCache = new LRUCache(100);
    }

    private static synchronized Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> getAvailableThreads() {
        if (availableThreads == null) {
            availableThreads = Collections.synchronizedMap(new HashMap());
        }
        return availableThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void removeFromThreads(KeyForAnalysisRunnable key, IAnalysisBuilderRunnable runnable) {
        Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> available;
        Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> map = available = AnalysisBuilderRunnableFactory.getAvailableThreads();
        synchronized (map) {
            IAnalysisBuilderRunnable analysisBuilderThread = available.get(key);
            if (analysisBuilderThread == runnable) {
                available.remove(key);
            }
        }
    }

    private static void logCreate(String moduleName, IAnalysisBuilderRunnable analysisBuilderThread, String factory) {
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            Log.toLogFile((Object)analysisBuilderThread, (String)new StringBuffer("Created new builder: ").append(analysisBuilderThread).append(" for:").append(moduleName).append(" -- ").append(analysisBuilderThread.getAnalysisCauseStr()).append(" -- ").append(factory).toString());
        }
    }

    private static void logStop(IAnalysisBuilderRunnable oldAnalysisBuilderThread, String creation) {
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            Log.toLogFile((Object)oldAnalysisBuilderThread, (String)new StringBuffer("Stopping previous builder: ").append(oldAnalysisBuilderThread).append(" (").append(oldAnalysisBuilderThread.getModuleName()).append(" -- ").append(oldAnalysisBuilderThread.getAnalysisCauseStr()).append(") to create new. ").append(creation).toString());
        }
    }

    private static synchronized KeyForAnalysisRunnable areNatureAndProjectAndTimeOK(IPythonNature nature, String moduleName, long documentTime, Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> available, long resourceModificationStamp) {
        long oldResourceTime;
        long oldDocTime;
        if (nature == null) {
            return null;
        }
        IProject project = nature.getProject();
        if (project == null || !project.isOpen()) {
            return null;
        }
        KeyForAnalysisRunnable analysisKey = new KeyForAnalysisRunnable(project.getName(), moduleName);
        IAnalysisBuilderRunnable oldAnalysisBuilderThread = available.get(analysisKey);
        if (oldAnalysisBuilderThread != null && !AnalysisBuilderRunnableFactory.checkTimesOk(oldAnalysisBuilderThread, oldAnalysisBuilderThread.getDocumentTime(), documentTime, oldAnalysisBuilderThread.getResourceModificationStamp(), resourceModificationStamp)) {
            return null;
        }
        Tuple lastTime = (Tuple)analysisTimeCache.getObj((Object)analysisKey);
        if (lastTime != null && !AnalysisBuilderRunnableFactory.checkTimesOk(oldAnalysisBuilderThread, oldDocTime = ((Long)lastTime.o1).longValue(), documentTime, oldResourceTime = ((Long)lastTime.o2).longValue(), resourceModificationStamp)) {
            return null;
        }
        analysisTimeCache.add((Object)analysisKey, (Object)new Tuple((Object)Autobox.valueOf((long)documentTime), (Object)Autobox.valueOf((long)resourceModificationStamp)));
        return analysisKey;
    }

    private static boolean checkTimesOk(IAnalysisBuilderRunnable oldAnalysisBuilderThread, long oldDocTime, long documentTime, long oldResourceStamp, long resourceStamp) {
        if (oldAnalysisBuilderThread != null && oldDocTime > documentTime - 500L) {
            if (oldResourceStamp != resourceStamp) {
                if (oldResourceStamp == -1L || resourceStamp == -1L) {
                    return true;
                }
                if (resourceStamp > oldResourceStamp) {
                    return true;
                }
            }
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                Log.toLogFile((Object)oldAnalysisBuilderThread, (String)AnalysisBuilderRunnableFactory.createExistinTimeHigherMessage(oldDocTime, documentTime, oldResourceStamp, resourceStamp));
            }
            return false;
        }
        return true;
    }

    private static String createExistinTimeHigherMessage(long oldTime, long documentTime, long oldResourceTime, long resourceTime) {
        return new StringBuffer("The document time from an existing is higher than a new one, so, leave it be... ").append(oldTime).append(" > ").append(documentTime).append(" - ").append(500).append(" (delta to consider equal) -- resource stamp (old, new): ").append(oldResourceTime).append(", ").append(resourceTime).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized IAnalysisBuilderRunnable createRunnable(IDocument document, IResource resource, ICallback<IModule, Integer> module, boolean isFullBuild, String moduleName, boolean forceAnalysis, int analysisCause, IPythonNature nature, long documentTime, long resourceModificationStamp) {
        Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> available;
        Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> map = available = AnalysisBuilderRunnableFactory.getAvailableThreads();
        synchronized (map) {
            KeyForAnalysisRunnable analysisKey;
            block7: {
                analysisKey = AnalysisBuilderRunnableFactory.areNatureAndProjectAndTimeOK(nature, moduleName, documentTime, available, resourceModificationStamp);
                if (analysisKey != null) break block7;
                return null;
            }
            IAnalysisBuilderRunnable oldAnalysisBuilderThread = available.get(analysisKey);
            if (oldAnalysisBuilderThread != null) {
                oldAnalysisBuilderThread.stopAnalysis();
                AnalysisBuilderRunnableFactory.logStop(oldAnalysisBuilderThread, "Factory: changed");
                if (!forceAnalysis && (forceAnalysis = oldAnalysisBuilderThread.getForceAnalysis()) && DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                    Log.toLogFile((Object)oldAnalysisBuilderThread, (String)"Now forcing analysis because old one, which didn't finish was forced!");
                }
                if (!forceAnalysis && PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor() && analysisCause == 1 && oldAnalysisBuilderThread.getAnalysisCause() != 1) {
                    forceAnalysis = true;
                }
            }
            AnalysisBuilderRunnable analysisBuilderThread = new AnalysisBuilderRunnable(document, resource, module, isFullBuild, moduleName, forceAnalysis, analysisCause, oldAnalysisBuilderThread, nature, documentTime, analysisKey, resourceModificationStamp);
            AnalysisBuilderRunnableFactory.logCreate(moduleName, analysisBuilderThread, "Factory: changed");
            available.put(analysisKey, analysisBuilderThread);
            return analysisBuilderThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IAnalysisBuilderRunnable createRunnable(String moduleName, IPythonNature nature, boolean fullBuild, boolean forceAnalysis, int analysisCause, long documentTime, long resourceModificationStamp) {
        Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> available;
        Map<KeyForAnalysisRunnable, IAnalysisBuilderRunnable> map = available = AnalysisBuilderRunnableFactory.getAvailableThreads();
        synchronized (map) {
            KeyForAnalysisRunnable analysisKey;
            block5: {
                analysisKey = AnalysisBuilderRunnableFactory.areNatureAndProjectAndTimeOK(nature, moduleName, documentTime, available, resourceModificationStamp);
                if (analysisKey != null) break block5;
                return null;
            }
            IAnalysisBuilderRunnable oldAnalysisBuilderThread = available.get(analysisKey);
            if (oldAnalysisBuilderThread != null) {
                oldAnalysisBuilderThread.stopAnalysis();
                AnalysisBuilderRunnableFactory.logStop(oldAnalysisBuilderThread, "Factory: remove");
            }
            AnalysisBuilderRunnableForRemove analysisBuilderThread = new AnalysisBuilderRunnableForRemove(moduleName, nature, fullBuild, oldAnalysisBuilderThread, forceAnalysis, analysisCause, documentTime, analysisKey, resourceModificationStamp);
            AnalysisBuilderRunnableFactory.logCreate(moduleName, analysisBuilderThread, "Factory: remove");
            available.put(analysisKey, analysisBuilderThread);
            return analysisBuilderThread;
        }
    }
}

