/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.additionalinfo.NameInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.cache.DiskCache;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.SequencialASTIteratorVisitor;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdditionalDependencyInfo
extends AbstractAdditionalInterpreterInfo {
    public static final int DISK_CACHE_IN_MEMORY = 300;
    public static boolean TESTING = false;
    public static final int COMPLETE_INDEX = 4;
    public DiskCache completeIndex;

    public AbstractAdditionalDependencyInfo() throws MisconfigurationException {
        this.init();
    }

    public AbstractAdditionalDependencyInfo(boolean callInit) throws MisconfigurationException {
        if (callInit) {
            this.init();
        }
    }

    protected void init() throws MisconfigurationException {
        File persistingFolder = this.getCompleteIndexPersistingFolder();
        this.completeIndex = new DiskCache(300, persistingFolder, ".indexcache");
    }

    protected File getCompleteIndexPersistingFolder() throws MisconfigurationException {
        File persistingFolder = this.getPersistingFolder();
        if ((persistingFolder = new File(persistingFolder, "indexcache")).exists() && persistingFolder.isDirectory()) {
            persistingFolder.delete();
        }
        if (!persistingFolder.exists()) {
            persistingFolder.mkdirs();
        }
        return persistingFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllInfo() {
        Object object = this.lock;
        synchronized (object) {
            super.clearAllInfo();
            try {
                this.completeIndex.clear();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<IInfo> getWithFilter(String qualifier, int getWhat, AbstractAdditionalInterpreterInfo.Filter filter, boolean useLowerCaseQual) {
        Object object = this.lock;
        synchronized (object) {
            List<IInfo> toks = super.getWithFilter(qualifier, getWhat, filter, useLowerCaseQual);
            if ((getWhat & 4) != 0) {
                String qualToCompare = qualifier;
                if (useLowerCaseQual) {
                    qualToCompare = qualifier.toLowerCase();
                }
                for (String modName : this.completeIndex.keys()) {
                    HashSet obj = (HashSet)this.completeIndex.getObj(modName);
                    if (obj == null) continue;
                    for (String infoName : obj) {
                        if (!filter.doCompare(qualToCompare, infoName)) continue;
                        toks.add(NameInfo.fromName(infoName, modName, null));
                    }
                }
            }
            return toks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IInfo> addAstInfo(SimpleNode node, String moduleName, IPythonNature nature, boolean generateDelta) {
        List<IInfo> addAstInfo = new ArrayList<IInfo>();
        if (node == null || moduleName == null) {
            return addAstInfo;
        }
        HashSet<String> nameIndexes = new HashSet<String>();
        SequencialASTIteratorVisitor visitor2 = new SequencialASTIteratorVisitor();
        try {
            node.accept((VisitorIF)visitor2);
            Iterator iterator = visitor2.getNamesIterator();
            Object object = this.lock;
            synchronized (object) {
                addAstInfo = super.addAstInfo(node, moduleName, nature, generateDelta);
                while (iterator.hasNext()) {
                    ASTEntry entry = (ASTEntry)iterator.next();
                    String id = entry.node instanceof Name ? ((Name)entry.node).id : ((NameTok)entry.node).id;
                    nameIndexes.add(id);
                }
                this.completeIndex.add(moduleName, nameIndexes);
            }
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
        }
        return addAstInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInfoFromModule(String moduleName, boolean generateDelta) {
        Object object = this.lock;
        synchronized (object) {
            if (moduleName == null) {
                throw new AssertionError((Object)"The module name may not be null.");
            }
            this.completeIndex.remove(moduleName);
            super.removeInfoFromModule(moduleName, generateDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getInfoToSave() {
        Object object = this.lock;
        synchronized (object) {
            return new Tuple(super.getInfoToSave(), (Object)this.completeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restoreSavedInfo(Object o) throws MisconfigurationException {
        Object object = this.lock;
        synchronized (object) {
            Tuple readFromFile = (Tuple)o;
            if (!(readFromFile.o1 instanceof Tuple3)) {
                throw new RuntimeException("Type Error: the info must be regenerated (changed across versions).");
            }
            this.completeIndex = (DiskCache)readFromFile.o2;
            if (this.completeIndex == null) {
                throw new RuntimeException("Type Error (index == null): the info must be regenerated (changed across versions).");
            }
            String shouldBeOn = REF.getFileAbsolutePath((File)this.getCompleteIndexPersistingFolder());
            if (!this.completeIndex.getFolderToPersist().equals(shouldBeOn)) {
                this.completeIndex.setFolderToPersist(shouldBeOn);
            }
            super.restoreSavedInfo(readFromFile.o1);
        }
    }
}

