/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.preferences;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

public class PyCodeStylePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String USE_LOCALS_AND_ATTRS_CAMELCASE = "USE_LOCALS_AND_ATTRS_CAMELCASE";
    public static final String USE_METHODS_FORMAT = "USE_METHODS_FORMAT";
    public static final boolean DEFAULT_USE_LOCALS_AND_ATTRS_CAMELCASE = false;
    public static final int METHODS_FORMAT_CAMELCASE_FIRST_LOWER = 0;
    public static final int METHODS_FORMAT_CAMELCASE_FIRST_UPPER = 1;
    public static final int METHODS_FORMAT_UNDERSCORE_SEPARATED = 2;
    public static final int DEFAULT_USE_METHODS_FORMAT = 2;
    public static final String[][] LABEL_AND_VALUE = new String[][]{{"underscore_separated", String.valueOf(2)}, {"CamelCase() with first upper", String.valueOf(1)}, {"camelCase() with first lower", String.valueOf(0)}};
    public static final String[][] LOCALS_LABEL_AND_VALUE = new String[][]{{"underscore_separated", String.valueOf(false)}, {"camelCase with first lower", String.valueOf(true)}};
    private Label labelLocalsFormat;
    private Label labelMethodsFormat;
    private RadioGroupFieldEditor useLocalsAndAttrsCamelCase;
    private RadioGroupFieldEditor useMethodsFormat;
    public static int TESTING_METHOD_FORMAT = 2;

    public PyCodeStylePreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.useLocalsAndAttrsCamelCase = new RadioGroupFieldEditor(USE_LOCALS_AND_ATTRS_CAMELCASE, "Locals and attributes format (used for assign quick-assist)?", 1, LOCALS_LABEL_AND_VALUE, p, true);
        this.addField((FieldEditor)this.useLocalsAndAttrsCamelCase);
        this.useMethodsFormat = new RadioGroupFieldEditor(USE_METHODS_FORMAT, "Methods format (used for generate properties refactoring)", 1, LABEL_AND_VALUE, p, true);
        this.addField((FieldEditor)this.useMethodsFormat);
        this.labelLocalsFormat = new Label(p, 0);
        this.labelMethodsFormat = new Label(p, 0);
        this.updateLabelLocalsAndAttrs(PyCodeStylePreferencesPage.useLocalsAndAttrsCamelCase());
        this.updateLabelMethods(PyCodeStylePreferencesPage.useMethodsCamelCase());
    }

    private void updateLabelMethods(int useMethodsFormat) {
        if (useMethodsFormat == 1) {
            this.labelMethodsFormat.setText("Refactoring property methods in the format def MyMethod()    ");
        } else if (useMethodsFormat == 2) {
            this.labelMethodsFormat.setText("Refactoring property methods in the format def my_method()   ");
        } else {
            this.labelMethodsFormat.setText("Refactoring property methods in the format def myMethod()    ");
        }
    }

    private void updateLabelLocalsAndAttrs(boolean useCamelCase) {
        if (useCamelCase) {
            this.labelLocalsFormat.setText("Ctrl+1 for assign to variable will suggest: myValue = MyValue()    ");
        } else {
            this.labelLocalsFormat.setText("Ctrl+1 for assign to variable will suggest: my_value = MyValue()   ");
        }
    }

    public void init(IWorkbench workbench) {
    }

    public static int useMethodsCamelCase() {
        try {
            if (PydevPlugin.getDefault() == null) {
                return TESTING_METHOD_FORMAT;
            }
            return Integer.parseInt(PydevPrefs.getPreferences().getString(USE_METHODS_FORMAT));
        }
        catch (NumberFormatException numberFormatException) {
            return 2;
        }
    }

    public static boolean useLocalsAndAttrsCamelCase() {
        return PydevPrefs.getPreferences().getBoolean(USE_LOCALS_AND_ATTRS_CAMELCASE);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (this.useLocalsAndAttrsCamelCase.equals(event.getSource())) {
            boolean newValue = Boolean.parseBoolean((String)event.getNewValue());
            this.updateLabelLocalsAndAttrs(newValue);
        } else if (this.useMethodsFormat.equals(event.getSource())) {
            int val;
            try {
                String newValue = (String)event.getNewValue();
                val = Integer.parseInt(newValue);
            }
            catch (NumberFormatException numberFormatException) {
                val = 2;
            }
            this.updateLabelMethods(val);
        }
    }
}

