/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.docutils.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipStructure {
    private Map<Integer, TreeSet<String>> levelToContents = new HashMap<Integer, TreeSet<String>>();
    public final ZipFile zipFile;
    public final File file;

    ZipStructure() {
        this.zipFile = null;
        this.file = null;
    }

    public ZipStructure(File file, ZipFile zipFile) {
        this.zipFile = zipFile;
        this.file = file;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            TreeSet<String> treeSet;
            ZipEntry element = entries.nextElement();
            String name = element.getName();
            int level = StringUtils.count((String)name, (char)'/');
            if (StringUtils.endsWith((String)name, (char)'/')) {
                --level;
            }
            if ((treeSet = this.levelToContents.get(Autobox.valueOf((int)level))) == null) {
                treeSet = new TreeSet();
                this.levelToContents.put(Autobox.valueOf((int)level), treeSet);
            }
            treeSet.add(name);
        }
    }

    Map<Integer, TreeSet<String>> getLevelToContents() {
        return this.levelToContents;
    }

    public List<String> contents(String name) {
        int level;
        ArrayList<String> ret = new ArrayList<String>();
        int length = name.length();
        if (length == 0) {
            level = 0;
        } else {
            Assert.isTrue((boolean)StringUtils.endsWith((String)name, (char)'/'));
            level = StringUtils.count((String)name, (char)'/');
        }
        TreeSet<String> treeSet = this.levelToContents.get(Autobox.valueOf((int)level));
        if (treeSet != null) {
            if (length == 0) {
                ret.addAll(treeSet);
            } else {
                for (String s : treeSet.tailSet(name)) {
                    if (!s.startsWith(name)) continue;
                    ret.add(s);
                }
            }
        }
        return ret;
    }
}

