/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyWordRule;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyCodeScanner
extends RuleBasedScanner {
    public static final String[] DEFAULT_KEYWORDS = new String[]{"and", "as", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "exec", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "nonlocal", "not", "or", "pass", "print", "raise", "return", "self", "try", "while", "with", "yield", "False", "None", "True"};
    private ColorAndStyleCache colorCache;
    private IToken keywordToken;
    private IToken selfToken;
    private IToken defaultToken;
    private IToken decoratorToken;
    private IToken numberToken;
    private IToken classNameToken;
    private IToken funcNameToken;
    private String[] keywords;

    public PyCodeScanner(ColorAndStyleCache colorCache) {
        this(colorCache, DEFAULT_KEYWORDS);
    }

    public PyCodeScanner(ColorAndStyleCache colorCache, String[] keywords) {
        this.keywords = keywords;
        this.colorCache = colorCache;
        this.setupRules();
    }

    public void updateColors() {
        this.setupRules();
    }

    private void setupRules() {
        this.keywordToken = new Token((Object)this.colorCache.getKeywordTextAttribute());
        this.selfToken = new Token((Object)this.colorCache.getSelfTextAttribute());
        this.defaultToken = new Token((Object)this.colorCache.getCodeTextAttribute());
        this.decoratorToken = new Token((Object)this.colorCache.getDecoratorTextAttribute());
        this.numberToken = new Token((Object)this.colorCache.getNumberTextAttribute());
        this.classNameToken = new Token((Object)this.colorCache.getClassNameTextAttribute());
        this.funcNameToken = new Token((Object)this.colorCache.getFuncNameTextAttribute());
        this.setDefaultReturnToken(this.defaultToken);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new GreatWhite()));
        HashMap<String, IToken> defaults = new HashMap<String, IToken>();
        defaults.put("self", this.selfToken);
        PyWordRule wordRule = new PyWordRule(new GreatKeywordDetector(), this.defaultToken, this.classNameToken, this.funcNameToken);
        String[] stringArray = this.keywords;
        int n = this.keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            IToken token = (IToken)defaults.get(keyword);
            if (token == null) {
                token = this.keywordToken;
            }
            wordRule.addWord(keyword, token);
            ++n2;
        }
        rules.add(wordRule);
        rules.add(new WordRule((IWordDetector)new DecoratorDetector(), this.decoratorToken));
        rules.add(new WordRule((IWordDetector)new NumberDetector(), this.numberToken));
        this.setRules(rules.toArray(new IRule[0]));
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
        this.setupRules();
    }

    private static class DecoratorDetector
    implements IWordDetector {
        private DecoratorDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return c != '\n' && c != '\r' && c != '(';
        }
    }

    private static class GreatKeywordDetector
    implements IWordDetector {
        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    private static class GreatWhite
    implements IWhitespaceDetector {
        private GreatWhite() {
        }

        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }

    public static class NumberDetector
    implements IWordDetector {
        private FastStringBuffer buffer = new FastStringBuffer();
        private boolean isInHexa;

        public boolean isWordStart(char c) {
            this.isInHexa = false;
            this.buffer.clear();
            this.buffer.append(c);
            return Character.isDigit(c);
        }

        public boolean isWordPart(char c) {
            if ((c == 'x' || c == 'X') && this.buffer.length() == 1 && this.buffer.charAt(0) == '0') {
                this.buffer.append(c);
                this.isInHexa = true;
                return true;
            }
            this.buffer.append(c);
            if (this.isInHexa) {
                return Character.isDigit(c) || c == 'a' || c == 'A' || c == 'b' || c == 'B' || c == 'c' || c == 'C' || c == 'd' || c == 'D' || c == 'e' || c == 'E' || c == 'f' || c == 'F';
            }
            return Character.isDigit(c) || c == 'e' || c == '.';
        }
    }
}

