/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.simpleassist;

import com.python.pydev.codecompletion.ui.CodeCompletionPreferencesPage;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.autoedit.DocCmd;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;
import org.python.pydev.editor.codecompletion.PyCompletionProposal;

public class SimpleAssistProposal
extends PyCompletionProposal
implements ICompletionProposalExtension2 {
    private static final Set<String> ADD_SPACE_AND_COLOR_AFTER = new HashSet<String>();
    private static final Set<String> ADD_SPACE_AFTER;
    private int changeInCursorPos = 0;

    static {
        ADD_SPACE_AND_COLOR_AFTER.add("if");
        ADD_SPACE_AND_COLOR_AFTER.add("class");
        ADD_SPACE_AND_COLOR_AFTER.add("for");
        ADD_SPACE_AND_COLOR_AFTER.add("while");
        ADD_SPACE_AND_COLOR_AFTER.add("with");
        ADD_SPACE_AFTER = new HashSet<String>();
        ADD_SPACE_AFTER.add("and");
        ADD_SPACE_AFTER.add("assert");
        ADD_SPACE_AFTER.add("del");
        ADD_SPACE_AFTER.add("def");
        ADD_SPACE_AFTER.add("from");
        ADD_SPACE_AFTER.add("global");
        ADD_SPACE_AFTER.add("import");
        ADD_SPACE_AFTER.add("lambda");
        ADD_SPACE_AFTER.add("not");
        ADD_SPACE_AFTER.add("raise");
        ADD_SPACE_AFTER.add("yield");
        ADD_SPACE_AFTER.add("print");
        ADD_SPACE_AFTER.add("or");
        ADD_SPACE_AFTER.add("as");
        ADD_SPACE_AFTER.add("in");
        ADD_SPACE_AFTER.add("is");
    }

    public SimpleAssistProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int priority) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, priority);
    }

    public SimpleAssistProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition + this.changeInCursorPos, 0);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            IDocument doc = viewer.getDocument();
            int dif = offset - this.fReplacementOffset;
            if (this.fReplacementString.equals("elif")) {
                doc.replace(offset, 0, this.fReplacementString.substring(dif));
                PyAutoIndentStrategy strategy = new PyAutoIndentStrategy();
                DocCmd cmd = new DocCmd(offset + this.fReplacementString.length() - dif, 0, " ");
                Tuple dedented = strategy.autoDedentElif(doc, (DocumentCommand)cmd);
                doc.replace(cmd.offset, 0, " :");
                if (dedented != null) {
                    this.changeInCursorPos = -((Integer)dedented.o2).intValue() + 1;
                }
                return;
            }
            if (this.fReplacementString.endsWith(":")) {
                String replacementString = this.fReplacementString.substring(0, this.fReplacementString.length() - 1);
                doc.replace(offset, 0, replacementString.substring(dif));
                PyAutoIndentStrategy strategy = new PyAutoIndentStrategy();
                DocCmd cmd = new DocCmd(offset + replacementString.length() - dif, 0, ":");
                Tuple dedented = strategy.autoDedentAfterColon(doc, (DocumentCommand)cmd);
                doc.replace(cmd.offset, 0, ":");
                if (dedented != null) {
                    this.changeInCursorPos = -((Integer)dedented.o2).intValue();
                }
                return;
            }
            if (ADD_SPACE_AFTER.contains(this.fReplacementString) && CodeCompletionPreferencesPage.addSpaceWhenNeeded()) {
                doc.replace(offset, 0, this.fReplacementString.substring(dif));
                doc.replace(offset + this.fReplacementString.length() - dif, 0, " ");
                this.changeInCursorPos = 1;
                return;
            }
            if (ADD_SPACE_AND_COLOR_AFTER.contains(this.fReplacementString) && CodeCompletionPreferencesPage.addSpaceAndColonWhenNeeded()) {
                doc.replace(offset, 0, this.fReplacementString.substring(dif));
                doc.replace(offset + this.fReplacementString.length() - dif, 0, " :");
                this.changeInCursorPos = 1;
                return;
            }
            if (this.fReplacementString.equals("print()")) {
                this.changeInCursorPos = -1;
            }
            doc.replace(offset, 0, this.fReplacementString.substring(dif));
        }
        catch (BadLocationException badLocationException) {}
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        String[] strs = PySelection.getActivationTokenAndQual((IDocument)document, (int)offset, (boolean)false);
        String activationToken = strs[0];
        String qualifier = strs[1];
        return activationToken.equals("") && !qualifier.equals("") && this.fReplacementString.startsWith(qualifier) && !this.fReplacementString.equals(qualifier);
    }
}

