/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.actions;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.actions.AdditionalInfoAndIInfo;
import com.python.pydev.analysis.actions.MatchHelper;
import com.python.pydev.analysis.actions.ModuleIInfoLabelProvider;
import com.python.pydev.analysis.actions.NameIInfoStyledLabelProvider;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.additionalinfo.InfoFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalsTwoPanelElementSelector2
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "com.python.pydev.analysis.actions.GlobalsTwoPanelElementSelector2";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private WorkingSetFilterActionGroup workingSetFilterActionGroup;
    private CustomWorkingSetFilter workingSetFilter = new CustomWorkingSetFilter();
    private String title;
    private List<AbstractAdditionalInterpreterInfo> additionalInfo;
    private String selectedText;

    public GlobalsTwoPanelElementSelector2(Shell shell, boolean multi, String selectedText) {
        super(shell, multi);
        this.selectedText = selectedText;
        this.setSelectionHistory(new InfoSelectionHistory());
        this.setTitle("Pydev: Globals Browser");
        this.setMessage("Select an item to open (? = any character, * = any string).\nDotted names may be used to filter with package (e.g.: django.utils.In)");
        NameIInfoStyledLabelProvider resourceItemLabelProvider = new NameIInfoStyledLabelProvider(true);
        ModuleIInfoLabelProvider resourceItemDetailsLabelProvider = new ModuleIInfoLabelProvider();
        this.setListLabelProvider((ILabelProvider)resourceItemLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)resourceItemDetailsLabelProvider);
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = title;
    }

    private void setSubtitle(String text) {
        if (text == null || text.length() == 0) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(new StringBuffer(String.valueOf(this.title)).append(" - ").append(text).toString());
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = AnalysisPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = AnalysisPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
        this.workingSetFilterActionGroup.saveState((IMemento)memento);
        this.workingSetFilterActionGroup.dispose();
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            settings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, AnalysisPlugin.getPluginID(), 4, "", (Throwable)e));
        }
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        String setting = settings.get(WORKINGS_SET_SETTINGS);
        if (setting != null) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                this.workingSetFilterActionGroup.restoreState((IMemento)memento);
            }
            catch (WorkbenchException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, AnalysisPlugin.getPluginID(), 4, "", (Throwable)e));
            }
        }
        this.addListFilter(this.workingSetFilter);
        this.applyFilter();
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
                    if (!(workingSet == null || workingSet.isAggregateWorkingSet() && workingSet.isEmpty())) {
                        GlobalsTwoPanelElementSelector2.this.workingSetFilter.setWorkingSet(workingSet);
                        GlobalsTwoPanelElementSelector2.this.setSubtitle(workingSet.getLabel());
                    } else {
                        IWorkbenchPage page;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (workingSet = (page = window.getActivePage()).getAggregateWorkingSet()).isAggregateWorkingSet() && workingSet.isEmpty()) {
                            workingSet = null;
                        }
                        GlobalsTwoPanelElementSelector2.this.workingSetFilter.setWorkingSet(workingSet);
                        GlobalsTwoPanelElementSelector2.this.setSubtitle(null);
                    }
                    GlobalsTwoPanelElementSelector2.this.scheduleRefresh();
                }
            }
        });
        menuManager.add((IContributionItem)new Separator());
        this.workingSetFilterActionGroup.fillContextMenu(menuManager);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null) {
            return null;
        }
        ArrayList<AdditionalInfoAndIInfo> resultToReturn = new ArrayList<AdditionalInfoAndIInfo>();
        int i = 0;
        while (i < result.length) {
            if (result[i] instanceof AdditionalInfoAndIInfo) {
                resultToReturn.add((AdditionalInfoAndIInfo)result[i]);
            }
            ++i;
        }
        return resultToReturn.toArray(new AdditionalInfoAndIInfo[resultToReturn.size()]);
    }

    public int open() {
        if (this.getInitialPattern() == null) {
            this.setInitialPattern(this.selectedText == null ? "" : this.selectedText);
        } else {
            this.setInitialPattern("");
        }
        return super.open();
    }

    public String getElementName(Object item) {
        AdditionalInfoAndIInfo info = (AdditionalInfoAndIInfo)item;
        return info.info.getName();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new InfoFilter();
    }

    public void setElements(List<AbstractAdditionalInterpreterInfo> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    protected Comparator<AdditionalInfoAndIInfo> getItemsComparator() {
        return new Comparator<AdditionalInfoAndIInfo>(){

            @Override
            public int compare(AdditionalInfoAndIInfo resource1, AdditionalInfoAndIInfo resource2) {
                String s2;
                String s1;
                Collator collator = Collator.getInstance();
                int comparability = collator.compare(s1 = resource1.info.getName(), s2 = resource2.info.getName());
                if (comparability == 0) {
                    String p1 = resource1.info.getDeclaringModuleName();
                    String p2 = resource2.info.getDeclaringModuleName();
                    if (p1 == null && p2 == null) {
                        return 0;
                    }
                    if (p1 != null && p2 == null) {
                        return -1;
                    }
                    if (p1 == null && p2 != null) {
                        return 1;
                    }
                    return p1.compareTo(p2);
                }
                return comparability;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((AdditionalInfoAndIInfo)object, (AdditionalInfoAndIInfo)object2);
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (itemsFilter instanceof InfoFilter) {
            if (progressMonitor != null) {
                progressMonitor.beginTask("Searching...", this.additionalInfo.size());
            }
            for (AbstractAdditionalInterpreterInfo additionalInfo : this.additionalInfo) {
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    progressMonitor.worked(1);
                }
                HashSet<IInfo> allTokens = new HashSet<IInfo>(additionalInfo.getAllTokens());
                for (IInfo iInfo : allTokens) {
                    contentProvider.add((Object)new AdditionalInfoAndIInfo(additionalInfo, iInfo), itemsFilter);
                }
            }
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    private class CustomWorkingSetFilter
    extends ViewerFilter {
        private ResourceWorkingSetFilter resourceWorkingSetFilter = new ResourceWorkingSetFilter();

        private CustomWorkingSetFilter() {
        }

        public void setWorkingSet(IWorkingSet workingSet) {
            this.resourceWorkingSetFilter.setWorkingSet(workingSet);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof AdditionalInfoAndIInfo) {
                AdditionalInfoAndIInfo info = (AdditionalInfoAndIInfo)element;
                if (info.additionalInfo instanceof AdditionalProjectInterpreterInfo) {
                    AdditionalProjectInterpreterInfo projectInterpreterInfo = (AdditionalProjectInterpreterInfo)info.additionalInfo;
                    return this.resourceWorkingSetFilter.select(viewer, parentElement, (Object)projectInterpreterInfo.getProject());
                }
            }
            return this.resourceWorkingSetFilter.select(viewer, parentElement, element);
        }
    }

    protected class InfoFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public InfoFilter() {
            super((FilteredItemsSelectionDialog)GlobalsTwoPanelElementSelector2.this);
        }

        public boolean isConsistentItem(Object item) {
            if (!(item instanceof AdditionalInfoAndIInfo)) {
                return false;
            }
            AdditionalInfoAndIInfo iInfo = (AdditionalInfoAndIInfo)item;
            return iInfo.info.getName() != null;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!(filter instanceof InfoFilter)) {
                return false;
            }
            return MatchHelper.isSubFilter(this.patternMatcher.getPattern(), ((InfoFilter)filter).patternMatcher.getPattern());
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!(filter instanceof InfoFilter)) {
                return false;
            }
            return MatchHelper.equalsFilter(this.patternMatcher.getPattern(), ((InfoFilter)filter).patternMatcher.getPattern());
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof AdditionalInfoAndIInfo)) {
                return false;
            }
            AdditionalInfoAndIInfo info = (AdditionalInfoAndIInfo)item;
            return MatchHelper.matchItem(this.patternMatcher, info.info);
        }
    }

    private class InfoSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private InfoSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            InfoFactory infoFactory = new InfoFactory();
            AdditionalInfoAndIInfo resource = infoFactory.createElement(element);
            return resource;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            AdditionalInfoAndIInfo resource = (AdditionalInfoAndIInfo)item;
            InfoFactory infoFactory = new InfoFactory(resource);
            infoFactory.saveState(element);
        }
    }
}

