/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.visitors.scope;

import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.parser.visitors.scope.DefinitionsASTIteratorVisitor;
import org.python.pydev.parser.visitors.scope.EasyASTIteratorWithChildrenVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineCreatorVisitor
extends EasyASTIteratorWithChildrenVisitor {
    private boolean isInAssign;

    public static OutlineCreatorVisitor create(SimpleNode ast) {
        OutlineCreatorVisitor visitor = new OutlineCreatorVisitor();
        if (ast == null) {
            return visitor;
        }
        try {
            ast.accept(visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return visitor;
    }

    @Override
    public void traverse(SimpleNode node) throws Exception {
        this.checkSpecials(node.specialsBefore);
        super.traverse(node);
        this.checkSpecials(node.specialsAfter);
    }

    @Override
    public void traverse(FunctionDef node) throws Exception {
        this.checkSpecials(node.specialsBefore);
        super.traverse(node);
        this.checkSpecials(node.specialsAfter);
    }

    @Override
    public Object visitImport(Import node) throws Exception {
        this.atomic(node);
        return super.visitImport(node);
    }

    @Override
    public Object visitImportFrom(ImportFrom node) throws Exception {
        this.atomic(node);
        return super.visitImportFrom(node);
    }

    @Override
    public Object visitAssign(Assign node) throws Exception {
        this.isInAssign = true;
        try {
            DefinitionsASTIteratorVisitor.visitAssign(this, node, false);
        }
        finally {
            this.isInAssign = false;
        }
        this.traverse(node);
        return null;
    }

    @Override
    public Object visitIf(If node) throws Exception {
        if (NodeUtils.isIfMAinNode(node)) {
            this.atomic(node);
            return null;
        }
        return super.visitIf(node);
    }

    @Override
    protected void doAddNode(ASTEntry entry) {
        SimpleNode node = entry.node;
        if (node instanceof commentType) {
            commentType type = (commentType)node;
            if (type.beginColumn == 1) {
                entry.parent = null;
            } else {
                ASTEntryWithChildren lastAdded = null;
                if (this.nodes != null && this.nodes.size() > 0) {
                    lastAdded = (ASTEntryWithChildren)((Object)this.nodes.get(this.nodes.size() - 1));
                }
                while (lastAdded != null) {
                    if (lastAdded.node == null) break;
                    if (lastAdded.node.beginColumn == node.beginColumn) {
                        entry.parent = lastAdded.parent;
                        break;
                    }
                    if (node.beginColumn <= lastAdded.node.beginColumn) break;
                    entry.parent = lastAdded;
                    List<ASTEntryWithChildren> children = lastAdded.children;
                    if (children == null || children.size() <= 0) break;
                    lastAdded = children.get(children.size() - 1);
                }
            }
        }
        super.doAddNode(entry);
    }

    private void checkSpecials(List<Object> specials) {
        if (specials == null || this.isInAssign) {
            return;
        }
        for (Object object : specials) {
            if (!(object instanceof commentType)) continue;
            commentType type = (commentType)object;
            String trimmed = type.id.trim();
            if (!trimmed.startsWith("#---") && !trimmed.endsWith("---")) continue;
            this.atomic(type);
        }
    }
}

