/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import edu.umd.cs.piccolox.swt.PSWTBoundsHandle;
import edu.umd.cs.piccolox.swt.PSWTPath;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class PSWTSelectionEventHandler
extends PSelectionEventHandler {
    PSWTPath marquee;
    PNode marqueeParent;
    Point2D pressPt;
    Point2D canvasPressPt;

    public PSWTSelectionEventHandler(PNode marqueeParent, PNode selectableParent) {
        super(new PNode(), selectableParent);
        this.marqueeParent = marqueeParent;
    }

    public PSWTSelectionEventHandler(PNode marqueeParent, List selectableParents) {
        super(new PNode(), selectableParents);
        this.marqueeParent = marqueeParent;
    }

    public void decorateSelectedNode(PNode node) {
        PSWTBoundsHandle.addBoundsHandlesTo(node);
    }

    public void undecorateSelectedNode(PNode node) {
        PSWTBoundsHandle.removeBoundsHandlesFrom(node);
    }

    protected void initializeSelection(PInputEvent pie) {
        super.initializeSelection(pie);
        this.pressPt = pie.getPosition();
        this.canvasPressPt = pie.getCanvasPosition();
    }

    protected void initializeMarquee(PInputEvent e) {
        super.initializeMarquee(e);
        this.marquee = new PSWTPath(new Rectangle2D.Float((float)this.pressPt.getX(), (float)this.pressPt.getY(), 0.0f, 0.0f)){

            protected void paint(PPaintContext paintContext) {
                SWTGraphics2D s2g = (SWTGraphics2D)paintContext.getGraphics();
                s2g.gc.setLineStyle(2);
                super.paint(paintContext);
                s2g.gc.setLineStyle(1);
            }
        };
        this.marquee.setStrokeColor(Color.black);
        this.marquee.setPaint(null);
        this.marqueeParent.addChild(this.marquee);
    }

    protected void updateMarquee(PInputEvent pie) {
        super.updateMarquee(pie);
        PBounds b = new PBounds();
        if (this.marqueeParent instanceof PCamera) {
            b.add(this.canvasPressPt);
            b.add(pie.getCanvasPosition());
        } else {
            b.add(this.pressPt);
            b.add(pie.getPosition());
        }
        this.marquee.setPathToRectangle((float)b.x, (float)b.y, (float)b.width, (float)b.height);
        b.reset();
        b.add(this.pressPt);
        b.add(pie.getPosition());
    }

    protected PBounds getMarqueeBounds() {
        if (this.marquee != null) {
            return this.marquee.getBounds();
        }
        return new PBounds();
    }

    protected void endMarqueeSelection(PInputEvent e) {
        super.endMarqueeSelection(e);
        this.marquee.removeFromParent();
        this.marquee = null;
    }

    protected void dragActivityStep(PInputEvent aEvent) {
    }
}

