/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.copiedfromeclipsesrc.PythonListEditor;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.PropertiesHelper;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.AsynchronousProgressMonitorDialog;
import org.python.pydev.jython.IPythonInterpreter;
import org.python.pydev.jython.JythonPlugin;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.ui.TabVariables;
import org.python.pydev.ui.dialogs.InterpreterInputDialog;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.ui.pythonpathconf.AbstractListWithNewRemoveControl;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;
import org.python.pydev.ui.pythonpathconf.MyEnvWorkingCopy;
import org.python.pydev.ui.pythonpathconf.ObtainInterpreterInfoOperation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterpreterEditor
extends PythonListEditor {
    private IInterpreterManager interpreterManager;
    private Tree treeWithLibs;
    Tree treeWithInterpreters;
    private Image imageSystemLibRoot;
    private Image imageSystemLib;
    private Image environmentImage;
    private boolean changed;
    private Composite boxSystem;
    private Button addBtSystemFolder;
    private Button removeBtSystemFolder;
    private Button addBtSystemJar;
    private SelectionListener selectionListenerSystem;
    private Map<String, IInterpreterInfo> nameToInfo = new HashMap<String, IInterpreterInfo>();
    private Set<String> exeOrJarOfInterpretersToRestore = new HashSet<String>();
    private Set<String> exeOrJarOfInterpretersWithBuiltinsChanged = new HashSet<String>();
    private Set<String> exeOrJarOfInterpretersWithPredefinedChanged = new HashSet<String>();
    private Set<String> exeOrJarOfInterpretersWithStringSubstitutionChanged = new HashSet<String>();
    protected TabFolder tabFolder;
    private EnvironmentTab environmentTab;
    private MyEnvWorkingCopy workingCopy = new MyEnvWorkingCopy();
    private TabVariables tabVariables;
    private AbstractListWithNewRemoveControl forcedBuiltins;
    private AbstractListWithNewRemoveControl predefinedCompletions;
    private static String lastDirectoryDialogPath = null;
    private static String lastFileDialogPath = null;

    public abstract String[] getInterpreterFilterExtensions();

    protected abstract Tuple<String, String> getAutoNewInput();

    private void clearInfos() {
        this.nameToInfo.clear();
        this.exeOrJarOfInterpretersToRestore.clear();
        this.exeOrJarOfInterpretersWithBuiltinsChanged.clear();
        this.exeOrJarOfInterpretersWithPredefinedChanged.clear();
        this.exeOrJarOfInterpretersWithStringSubstitutionChanged.clear();
    }

    public Set<String> getInterpreterExeOrJarToRestoreAndClear() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.exeOrJarOfInterpretersToRestore);
        set.addAll(this.exeOrJarOfInterpretersWithBuiltinsChanged);
        set.addAll(this.exeOrJarOfInterpretersWithPredefinedChanged);
        set.addAll(this.exeOrJarOfInterpretersWithStringSubstitutionChanged);
        this.exeOrJarOfInterpretersToRestore.clear();
        this.exeOrJarOfInterpretersWithBuiltinsChanged.clear();
        this.exeOrJarOfInterpretersWithPredefinedChanged.clear();
        this.exeOrJarOfInterpretersWithStringSubstitutionChanged.clear();
        return set;
    }

    public IInterpreterInfo[] getExesList() {
        TreeItem[] items = this.treeWithInterpreters.getItems();
        ArrayList<IInterpreterInfo> infos = new ArrayList<IInterpreterInfo>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem exe = treeItemArray[n2];
            IInterpreterInfo info = this.nameToInfo.get(this.getNameFromTreeItem(exe));
            if (info == null) {
                PydevPlugin.log(new StringBuffer("Didn't expect interpreter info to be null in the memory: ").append(exe).toString());
            } else {
                infos.add(info);
            }
            ++n2;
        }
        return infos.toArray(new IInterpreterInfo[infos.size()]);
    }

    protected String getNameFromTreeItem(TreeItem treeItem) {
        return treeItem.getText(0);
    }

    InterpreterInfo getSelectedInfo() {
        if (this.treeWithInterpreters.getSelectionCount() == 1) {
            TreeItem[] selection = this.treeWithInterpreters.getSelection();
            return (InterpreterInfo)this.nameToInfo.get(this.getNameFromTreeItem(selection[0]));
        }
        return null;
    }

    protected AbstractInterpreterEditor(String preferenceName, String labelText, Composite parent, IInterpreterManager interpreterManager) {
        this.init(preferenceName, labelText);
        this.interpreterManager = interpreterManager;
        IInterpreterInfo[] interpreters = this.interpreterManager.getInterpreterInfos();
        this.clearInfos();
        IInterpreterInfo[] iInterpreterInfoArray = interpreters;
        int n = interpreters.length;
        int n2 = 0;
        while (n2 < n) {
            IInterpreterInfo interpreterInfo = iInterpreterInfoArray[n2];
            if (interpreterInfo != null) {
                this.nameToInfo.put(interpreterInfo.getName(), interpreterInfo.makeCopy());
            }
            ++n2;
        }
        if (USE_ICONS) {
            ImageCache imageCache = PydevPlugin.getImageCache();
            this.imageSystemLibRoot = imageCache.get("icons/library_obj.gif");
            this.imageSystemLib = imageCache.get("icons/jar_l_obj.gif");
            this.environmentImage = imageCache.get("icons/environment_obj.gif");
        }
        this.createControl(parent);
        this.updateTree();
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        this.treeWithInterpreters = this.getListControl(parent);
        this.treeWithInterpreters.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractInterpreterEditor.this.updateTree();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInterpreterEditor.this.updateTree();
            }
        });
        this.treeWithInterpreters.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    AbstractInterpreterEditor.this.renameSelection();
                }
            }
        });
        this.treeWithInterpreters.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                AbstractInterpreterEditor.this.renameSelection();
            }
        });
    }

    private void renameSelection() {
        int index = this.getSelectionIndex();
        if (index >= 0) {
            String newName;
            TreeItem curr = this.treeWithInterpreters.getItem(index);
            final String initialName = this.getNameFromTreeItem(curr);
            InputDialog d = new InputDialog(this.getShell(), "New name", "Please specify the new name of the interpreter.", initialName, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.trim().equals("")) {
                        return "Please specify a non-empty name.";
                    }
                    if ((newText = newText.trim()).equals(initialName)) {
                        return null;
                    }
                    return AbstractInterpreterEditor.this.getDuplicatedMessageError(newText, null);
                }
            });
            int retCode = d.open();
            if (retCode == 0 && !(newName = d.getValue().trim()).equals(initialName)) {
                IInterpreterInfo info = this.nameToInfo.get(initialName);
                info.setName(newName);
                curr.setText(0, newName);
                this.nameToInfo.remove(initialName);
                this.nameToInfo.put(newName, info);
                this.exeOrJarOfInterpretersToRestore.add(info.getExecutableOrJar());
            }
        }
    }

    private Tree getTreeLibsControl(Composite parent) {
        if (this.treeWithLibs == null) {
            this.treeWithLibs = new Tree(parent, 2050);
            this.treeWithLibs.setFont(parent.getFont());
            this.treeWithLibs.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.treeWithLibs = null;
                }
            });
        }
        return this.treeWithLibs;
    }

    @Override
    protected void disposeOfTreeItem(TreeItem t) {
        String nameFromTreeItem = this.getNameFromTreeItem(t);
        this.nameToInfo.remove(nameFromTreeItem);
        super.disposeOfTreeItem(t);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
        ((GridData)this.tabFolder.getLayoutData()).horizontalSpan = numColumns;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        GridData gd = new GridData();
        this.tabFolder = new TabFolder(parent, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = numColumns;
        this.tabFolder.setLayoutData((Object)gd);
        this.createTreeLibsControlTab();
        this.forcedBuiltins = new AbstractListWithNewRemoveControl(this){

            @Override
            protected List<String> getStringsFromInfo(InterpreterInfo info) {
                ArrayList<String> ret = new ArrayList<String>();
                Iterator<String> iter = info.forcedLibsIterator();
                while (iter.hasNext()) {
                    ret.add(iter.next());
                }
                return ret;
            }

            @Override
            protected void removeSelectedFrominfo(InterpreterInfo info, String[] builtins) {
                String[] stringArray = builtins;
                int n = builtins.length;
                int n2 = 0;
                while (n2 < n) {
                    String builtin = stringArray[n2];
                    info.removeForcedLib(builtin);
                    ++n2;
                }
                AbstractInterpreterEditor.this.exeOrJarOfInterpretersWithBuiltinsChanged.add(info.getExecutableOrJar());
            }

            @Override
            protected String getInput() {
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        char[] cArray = newText.toCharArray();
                        int n = cArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char c = cArray[n2];
                            if (!Character.isJavaIdentifierPart(c) && c != ' ' && c != ',' && c != '.') {
                                return "Can only accept valid python module names (char: '" + c + "' not accepted)";
                            }
                            ++n2;
                        }
                        return null;
                    }
                };
                InputDialog d = new InputDialog(AbstractInterpreterEditor.this.getShell(), "Builtin to add", "Builtin to add (comma separated)", "", validator);
                int retCode = d.open();
                String builtins = null;
                if (retCode == 0) {
                    builtins = d.getValue();
                }
                return builtins;
            }

            @Override
            protected void addInputToInfo(InterpreterInfo info, String builtins) {
                List split = StringUtils.splitAndRemoveEmptyTrimmed((String)builtins, (char)',');
                for (String string : split) {
                    String trimmed = string.trim();
                    if (trimmed.length() <= 0) continue;
                    info.addForcedLib(trimmed);
                }
                AbstractInterpreterEditor.this.exeOrJarOfInterpretersWithBuiltinsChanged.add(info.getExecutableOrJar());
            }
        };
        this.forcedBuiltins.createTab("Forced Builtins", "Forced Builtins (check <a>Manual</a> for more info).");
        this.predefinedCompletions = new AbstractListWithNewRemoveControl(this){
            private Button addAPIBt;

            @Override
            protected List<String> getStringsFromInfo(InterpreterInfo info) {
                return info.getPredefinedCompletionsPath();
            }

            @Override
            protected void removeSelectedFrominfo(InterpreterInfo info, String[] items) {
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    info.removePredefinedCompletionPath(item);
                    ++n2;
                }
                AbstractInterpreterEditor.this.exeOrJarOfInterpretersWithPredefinedChanged.add(info.getExecutableOrJar());
            }

            @Override
            protected String getInput() {
                DirectoryDialog dialog = new DirectoryDialog(AbstractInterpreterEditor.this.getShell());
                dialog.setFilterPath(lastDirectoryDialogPath);
                String filePath = dialog.open();
                if (filePath != null) {
                    lastDirectoryDialogPath = filePath;
                }
                return filePath;
            }

            @Override
            protected void addInputToInfo(InterpreterInfo info, String item) {
                info.addPredefinedCompletionsPath(item);
                AbstractInterpreterEditor.this.exeOrJarOfInterpretersWithPredefinedChanged.add(info.getExecutableOrJar());
            }

            @Override
            protected void createButtons(AbstractInterpreterEditor interpreterEditor) {
                super.createButtons(interpreterEditor);
                this.addAPIBt = interpreterEditor.createBt(this.box, "Add from QScintilla api file", (SelectionListener)this);
            }

            @Override
            public void widgetDisposed(DisposeEvent event) {
                super.widgetDisposed(event);
                if (this.addAPIBt != null) {
                    this.addAPIBt.dispose();
                    this.addAPIBt = null;
                }
            }

            @Override
            public void widgetSelected(SelectionEvent event) {
                super.widgetSelected(event);
                Widget widget = event.widget;
                if (widget == this.addAPIBt) {
                    this.addAPIBt();
                }
            }

            private void addAPIBt() {
                AbstractInterpreterEditor interpreterEditor = (AbstractInterpreterEditor)((Object)this.container.get());
                Assert.isNotNull((Object)((Object)interpreterEditor));
                InterpreterInfo info = interpreterEditor.getSelectedInfo();
                if (info != null) {
                    FileDialog dialog = new FileDialog(AbstractInterpreterEditor.this.getShell(), 32770);
                    dialog.setFilterExtensions(new String[]{"*.api"});
                    dialog.setText("Select .api file to be converted to .pypredef.");
                    dialog.setFilterPath(lastFileDialogPath);
                    final String filePath = dialog.open();
                    if (filePath != null) {
                        lastFileDialogPath = filePath;
                        File filePath1 = new File(filePath);
                        String dir = filePath1.getParent();
                        IInputValidator validator = new IInputValidator(){

                            public String isValid(String newText) {
                                if (newText.length() == 0) {
                                    return "Number not provided.";
                                }
                                try {
                                    Integer.parseInt(newText);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return "The string: " + newText + " is not a valid integer.";
                                }
                                return null;
                            }
                        };
                        final InputDialog d = new InputDialog(AbstractInterpreterEditor.this.getShell(), "Number of tokens to consider module", "Please specify the number of tokens to consider a module from the .api file\n\ni.e.: if there's a PyQt4.QtCore.QObject and PyQt4.QtCore is a module and QtObject is the first class, the number of tokens to consider a module would be 2 (one for PyQt4 and another for QtCore).", "", validator);
                        int retCode = d.open();
                        final ByteArrayOutputStream output = new ByteArrayOutputStream();
                        if (retCode == 0) {
                            AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(AbstractInterpreterEditor.this.getShell());
                            monitorDialog.setBlockOnOpen(false);
                            final Exception[] exception = new Exception[1];
                            try {
                                IRunnableWithProgress operation = new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                        monitor.beginTask("Restoring PYTHONPATH", -1);
                                        IPythonInterpreter interpreter = JythonPlugin.newPythonInterpreter((boolean)false, (boolean)false);
                                        interpreter.setErr((OutputStream)output);
                                        interpreter.setOut((OutputStream)output);
                                        HashMap<String, String> locals = new HashMap<String, String>();
                                        locals.put("api_file", filePath);
                                        locals.put("parts_for_module", d.getValue());
                                        locals.put("cancel_monitor", (String)monitor);
                                        try {
                                            JythonPlugin.exec(locals, (String)"convert_api_to_pypredef.py", (IPythonInterpreter)interpreter);
                                        }
                                        catch (Exception e) {
                                            Log.log((String)(e + "\n\n" + output.toString()));
                                            exception[0] = e;
                                        }
                                        monitor.done();
                                    }
                                };
                                monitorDialog.run(true, true, operation);
                            }
                            catch (Exception e) {
                                PydevPlugin.log(e);
                            }
                            Exception e = exception[0];
                            String contents = output.toString();
                            if (e == null && contents.indexOf("SUCCESS") != -1) {
                                this.addInputToInfo(info, dir);
                                interpreterEditor.updateTree();
                            } else if (e != null) {
                                MessageDialog.openError((Shell)AbstractInterpreterEditor.this.getShell(), (String)"Error creating .pypredef files", (String)new StringBuffer(String.valueOf(e.getMessage())).append("\n\n").append(contents).toString());
                            } else {
                                MessageDialog.openError((Shell)AbstractInterpreterEditor.this.getShell(), (String)"Error creating .pypredef files", (String)contents);
                            }
                        }
                    }
                }
            }
        };
        this.predefinedCompletions.createTab("Predefined", "Predefined completions (check <a>Manual</a> for more info).");
        this.createEnvironmentVariablesTab();
        this.createStringSubstitutionTab();
    }

    private void createStringSubstitutionTab() {
        HashMap<String, String> initialVariables = new HashMap<String, String>();
        this.tabVariables = new TabVariables(this.tabFolder, initialVariables);
    }

    private void createEnvironmentVariablesTab() {
        Composite composite;
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Environment");
        tabItem.setImage(this.environmentImage);
        Composite parent = composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.environmentTab = new EnvironmentTab(){

            protected void createAppendReplace(Composite parent) {
                super.createAppendReplace(parent);
                this.appendEnvironment.setVisible(false);
                this.replaceEnvironment.setVisible(false);
            }
        };
        this.environmentTab.createControl(parent);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.environmentTab.getControl().setLayoutData((Object)gd);
        tabItem.setControl((Control)composite);
    }

    private void createTreeLibsControlTab() {
        Composite composite;
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Libraries");
        tabItem.setImage(this.imageSystemLibRoot);
        Composite parent = composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(parent, 0);
        l1.setText("System PYTHONPATH");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l1.setLayoutData((Object)gd);
        this.treeWithLibs = this.getTreeLibsControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.treeWithLibs.setLayoutData((Object)gd);
        Composite control = this.getButtonBoxControlSystem(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        control.setLayoutData((Object)gd);
        tabItem.setControl((Control)composite);
    }

    public Composite getButtonBoxControlSystem(Composite parent) {
        if (this.boxSystem == null) {
            this.boxSystem = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.boxSystem.setLayout((Layout)layout);
            this.addBtSystemFolder = this.createBt(this.boxSystem, "New Folder", this.getSelectionListenerSystem());
            switch (this.interpreterManager.getInterpreterType()) {
                case 1: {
                    this.addBtSystemJar = this.createBt(this.boxSystem, "New Jar/Zip(s)", this.getSelectionListenerSystem());
                    break;
                }
                default: {
                    this.addBtSystemJar = this.createBt(this.boxSystem, "New Egg/Zip(s)", this.getSelectionListenerSystem());
                }
            }
            this.removeBtSystemFolder = this.createBt(this.boxSystem, "ListEditor.remove", this.getSelectionListenerSystem());
            this.boxSystem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.addBtSystemJar = null;
                    AbstractInterpreterEditor.this.addBtSystemFolder = null;
                    AbstractInterpreterEditor.this.removeBtSystemFolder = null;
                    AbstractInterpreterEditor.this.boxSystem = null;
                }
            });
        } else {
            this.checkParent((Control)this.boxSystem, parent);
        }
        return this.boxSystem;
    }

    private SelectionListener getSelectionListenerSystem() {
        if (this.selectionListenerSystem == null) {
            this.selectionListenerSystem = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (AbstractInterpreterEditor.this.treeWithInterpreters.getSelectionCount() == 1) {
                        TreeItem[] selection = AbstractInterpreterEditor.this.treeWithInterpreters.getSelection();
                        String nameFromTreeItem = AbstractInterpreterEditor.this.getNameFromTreeItem(selection[0]);
                        InterpreterInfo info = (InterpreterInfo)AbstractInterpreterEditor.this.nameToInfo.get(nameFromTreeItem);
                        AbstractInterpreterEditor.this.exeOrJarOfInterpretersToRestore.add(info.getExecutableOrJar());
                        Widget widget = event.widget;
                        if (widget == AbstractInterpreterEditor.this.addBtSystemFolder) {
                            DirectoryDialog dialog = new DirectoryDialog(AbstractInterpreterEditor.this.getShell());
                            dialog.setFilterPath(lastDirectoryDialogPath);
                            String filePath = dialog.open();
                            if (filePath != null) {
                                lastDirectoryDialogPath = filePath;
                                info.libs.add(filePath);
                            }
                        } else if (widget == AbstractInterpreterEditor.this.addBtSystemJar) {
                            FileDialog dialog = new FileDialog(AbstractInterpreterEditor.this.getShell(), 32770);
                            switch (AbstractInterpreterEditor.this.interpreterManager.getInterpreterType()) {
                                case 1: {
                                    dialog.setFilterExtensions(FileTypesPreferencesPage.getWildcardJythonValidZipFiles());
                                    break;
                                }
                                default: {
                                    dialog.setFilterExtensions(FileTypesPreferencesPage.getWildcardPythonValidZipFiles());
                                }
                            }
                            dialog.setFilterPath(lastFileDialogPath);
                            String filePath = dialog.open();
                            if (filePath != null) {
                                String[] fileNames;
                                lastFileDialogPath = filePath;
                                File filePath1 = new File(filePath);
                                String dir = filePath1.getParent();
                                String[] stringArray = fileNames = dialog.getFileNames();
                                int n = fileNames.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String f = stringArray[n2];
                                    f = String.valueOf(dir) + File.separatorChar + f;
                                    if (!info.libs.contains(f)) {
                                        info.libs.add(f);
                                    }
                                    ++n2;
                                }
                            }
                        } else if (widget == AbstractInterpreterEditor.this.removeBtSystemFolder) {
                            TreeItem[] libSelection = AbstractInterpreterEditor.this.treeWithLibs.getSelection();
                            int i = 0;
                            while (i < libSelection.length) {
                                TreeItem s = libSelection[i];
                                String text = s.getText();
                                info.libs.remove(text);
                                ++i;
                            }
                        }
                        AbstractInterpreterEditor.this.updateTree();
                    }
                }
            };
        }
        return this.selectionListenerSystem;
    }

    Button createBt(Composite parent, String key, SelectionListener listenerToAdd) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(listenerToAdd);
        return button;
    }

    @Override
    public void updateTree() {
        int index = this.getSelectionIndex();
        if (index >= 0) {
            TreeItem item = this.treeWithInterpreters.getItem(index);
            this.fillPathItemsFromName(this.getNameFromTreeItem(item));
        } else {
            this.fillPathItemsFromName(null);
            if (this.treeWithInterpreters.getItemCount() > 0) {
                this.treeWithInterpreters.setSelection(this.treeWithInterpreters.getItem(0));
                this.selectionChanged();
                this.fillPathItemsFromName(this.getNameFromTreeItem(this.treeWithInterpreters.getItem(0)));
            }
        }
    }

    @Override
    public Shell getShell() {
        return super.getShell();
    }

    private void fillPathItemsFromName(String name) {
        this.treeWithLibs.removeAll();
        this.forcedBuiltins.removeAllFromList();
        this.predefinedCompletions.removeAllFromList();
        InterpreterInfo workingCopyInfo = this.workingCopy.getInfo();
        if (workingCopyInfo != null) {
            this.environmentTab.performApply((ILaunchConfigurationWorkingCopy)this.workingCopy);
            Properties propertiesFromMap = PropertiesHelper.createPropertiesFromMap(this.tabVariables.getTreeItemsAsMap());
            Properties stringSubstitutionVariables = workingCopyInfo.getStringSubstitutionVariables();
            boolean equals = false;
            if (stringSubstitutionVariables == null) {
                if (propertiesFromMap == null || propertiesFromMap.size() == 0) {
                    equals = true;
                }
            } else {
                equals = stringSubstitutionVariables.equals(propertiesFromMap);
            }
            if (!equals) {
                this.exeOrJarOfInterpretersWithStringSubstitutionChanged.add(workingCopyInfo.getExecutableOrJar());
                workingCopyInfo.setStringSubstitutionVariables(propertiesFromMap);
            }
        }
        if (name != null) {
            TreeItem item = new TreeItem(this.treeWithLibs, 0);
            item.setText("System libs");
            item.setImage(this.imageSystemLibRoot);
            InterpreterInfo info = (InterpreterInfo)this.nameToInfo.get(name);
            if (info == null) {
                PydevPlugin.log(new StringBuffer("Didn't expect interpreter info to be null in the memory: ").append(name).toString());
            } else {
                Iterator<String> iter = info.libs.iterator();
                while (iter.hasNext()) {
                    TreeItem subItem = new TreeItem(item, 0);
                    subItem.setText(iter.next());
                    subItem.setImage(this.imageSystemLib);
                }
                item.setExpanded(true);
                this.forcedBuiltins.update(info);
                this.predefinedCompletions.update(info);
            }
            this.workingCopy.setInfo(info);
            this.environmentTab.initializeFrom((ILaunchConfiguration)this.workingCopy);
            Properties stringSubstitutionVariables = info.getStringSubstitutionVariables();
            if (stringSubstitutionVariables != null) {
                this.tabVariables.setTreeItemsFromMap(PropertiesHelper.createMapFromProperties((Properties)stringSubstitutionVariables));
            } else {
                this.tabVariables.setTreeItemsFromMap(new HashMap<String, String>());
            }
        }
    }

    @Override
    protected Tuple<String, String> getNewInputObject(boolean autoConfig) {
        CharArrayWriter charWriter = new CharArrayWriter();
        PrintWriter logger = new PrintWriter(charWriter);
        logger.println("Information about process of adding new interpreter:");
        try {
            boolean foundError;
            Tuple<String, String> interpreterNameAndExecutable = null;
            if (autoConfig) {
                interpreterNameAndExecutable = this.getAutoNewInput();
                if (interpreterNameAndExecutable == null) {
                    this.reportAutoConfigProblem(null);
                    return null;
                }
            } else {
                InterpreterInputDialog dialog = new InterpreterInputDialog(this.getShell(), "Select interpreter", "Enter the name and executable of your interpreter", this);
                logger.println("- Opening dialog to request executable (or jar).");
                int result = dialog.open();
                if (result == 0) {
                    interpreterNameAndExecutable = dialog.getKeyAndValueEntered();
                } else {
                    return null;
                }
            }
            if (foundError = this.checkInterpreterNameAndExecutable(interpreterNameAndExecutable, logger, "Error getting info on interpreter")) {
                return null;
            }
            logger.println(new StringBuffer("- Chosen interpreter (name and file):'").append(interpreterNameAndExecutable).toString());
            if (interpreterNameAndExecutable != null && interpreterNameAndExecutable.o2 != null) {
                logger.println(new StringBuffer("- Ok, file is non-null. Getting info on:").append((String)interpreterNameAndExecutable.o2).toString());
                AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(this.getShell());
                monitorDialog.setBlockOnOpen(false);
                ObtainInterpreterInfoOperation operation = new ObtainInterpreterInfoOperation((String)interpreterNameAndExecutable.o2, logger, this.interpreterManager);
                monitorDialog.run(true, false, (IRunnableWithProgress)operation);
                if (operation.e != null) {
                    logger.println("- Some error happened while getting info on the interpreter:");
                    operation.e.printStackTrace(logger);
                    if (operation.e instanceof SimpleJythonRunner.JavaNotConfiguredException) {
                        SimpleJythonRunner.JavaNotConfiguredException javaNotConfiguredException = (SimpleJythonRunner.JavaNotConfiguredException)operation.e;
                        ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)javaNotConfiguredException.getMessage(), (IStatus)PydevPlugin.makeStatus(4, "Java vm not configured.\n", javaNotConfiguredException));
                    } else if (operation.e instanceof JDTNotAvailableException) {
                        JDTNotAvailableException noJdtException = (JDTNotAvailableException)operation.e;
                        ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)noJdtException.getMessage(), (IStatus)PydevPlugin.makeStatus(4, "JDT not available.\n", noJdtException));
                    } else if (autoConfig) {
                        this.reportAutoConfigProblem(operation.e);
                    } else {
                        String errorMsg = "Error getting info on interpreter.\n\nCommon reasons include:\n\n- Using an unsupported version\n  (Python and Jython require at least version 2.1 and Iron Python 2.6).\n\n- Specifying an invalid interpreter\n  (usually a link to the actual interpreter on Mac or Linux)";
                        ErrorDialog.openError((Shell)this.getShell(), (String)"Unable to get info on the interpreter.", (String)errorMsg, (IStatus)PydevPlugin.makeStatus(4, "See error log for details.", operation.e));
                    }
                    throw operation.e;
                }
                if (operation.result != null) {
                    foundError = this.checkInterpreterNameAndExecutable((Tuple<String, String>)new Tuple((Object)((String)interpreterNameAndExecutable.o1), (Object)operation.result.executableOrJar), logger, "Error adding interpreter");
                    if (foundError) {
                        return null;
                    }
                    operation.result.setName((String)interpreterNameAndExecutable.o1);
                    logger.println(new StringBuffer("- Success getting the info. Result:").append(operation.result).toString());
                    String newName = operation.result.getName();
                    this.nameToInfo.put(newName, operation.result.makeCopy());
                    this.exeOrJarOfInterpretersToRestore.add(operation.result.executableOrJar);
                    Tuple tuple = new Tuple((Object)operation.result.getName(), (Object)operation.result.executableOrJar);
                    return tuple;
                }
                return null;
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
            return null;
        }
        finally {
            PydevPlugin.logInfo(charWriter.toString());
        }
        return null;
    }

    private boolean checkInterpreterNameAndExecutable(Tuple<String, String> interpreterNameAndExecutable, PrintWriter logger, String errorMsg) {
        String error;
        boolean foundError = false;
        if (interpreterNameAndExecutable == null) {
            logger.println("- When trimmed, the chosen file was null (returning null).");
            ErrorDialog.openError((Shell)this.getShell(), (String)errorMsg, (String)"interpreterNameAndExecutable == null", (IStatus)PydevPlugin.makeStatus(4, "interpreterNameAndExecutable == null", new RuntimeException()));
            foundError = true;
        }
        if (!foundError && ((String)interpreterNameAndExecutable.o2).trim().length() == 0) {
            logger.println("- When trimmed, the chosen file was empty (returning null).");
            ErrorDialog.openError((Shell)this.getShell(), (String)errorMsg, (String)"interpreterNameAndExecutable size == empty", (IStatus)PydevPlugin.makeStatus(4, "interpreterNameAndExecutable size == empty", new RuntimeException()));
            foundError = true;
        }
        if (!foundError && (error = this.getDuplicatedMessageError((String)interpreterNameAndExecutable.o1, (String)interpreterNameAndExecutable.o2)) != null) {
            logger.println("- Duplicated interpreter found.");
            ErrorDialog.openError((Shell)this.getShell(), (String)errorMsg, (String)error, (IStatus)PydevPlugin.makeStatus(4, "Duplicated interpreter information", new RuntimeException()));
            foundError = true;
        }
        return foundError;
    }

    public String getUniqueInterpreterName(String expectedName) {
        String additional = "";
        int i = 0;
        while (this.getDuplicatedMessageError(new StringBuffer(String.valueOf(expectedName)).append(additional).toString(), null) != null) {
            additional = String.valueOf(++i);
        }
        return new StringBuffer(String.valueOf(expectedName)).append(additional).toString();
    }

    public String getDuplicatedMessageError(String interpreterName, String executableOrJar) {
        String error = null;
        if (interpreterName != null && this.nameToInfo.containsKey(interpreterName = interpreterName.trim())) {
            error = new StringBuffer("An interpreter is already configured with the name: ").append(interpreterName).toString();
        }
        if (executableOrJar != null) {
            executableOrJar = executableOrJar.trim();
            for (IInterpreterInfo info : this.nameToInfo.values()) {
                if (!info.getExecutableOrJar().trim().equals(executableOrJar)) continue;
                error = new StringBuffer("An interpreter is already configured with the path: ").append(executableOrJar).toString();
            }
        }
        return error;
    }

    private void reportAutoConfigProblem(Exception e) {
        String errorMsg = "Unable to auto-configure the interpreter.\nPlease create a new interpreter using the 'New' button.";
        ErrorDialog.openError((Shell)this.getShell(), (String)"Unable to auto-configure.", (String)errorMsg, (IStatus)PydevPlugin.makeStatus(4, "Unable to gather the needed info from the system.\n\nThis usually means that your interpreter is not in\nthe system PATH.", e));
    }

    @Override
    protected void doStore() {
        this.updateTree();
        String newStringToPersist = this.createListFromInterpreterInfo(this.getExesList());
        String oldStringToPersist = this.createListFromInterpreterInfo(this.interpreterManager.getInterpreterInfos());
        if (!newStringToPersist.equals(oldStringToPersist)) {
            this.interpreterManager.setPersistedString(newStringToPersist);
            this.changed = true;
        } else {
            this.changed = false;
        }
    }

    @Override
    protected void doLoad() {
        if (this.treeWithInterpreters != null) {
            String s = this.interpreterManager.getPersistedString();
            IInterpreterInfo[] array = this.parseStringToInfo(s);
            this.clearInfos();
            int i = 0;
            while (i < array.length) {
                IInterpreterInfo interpreterInfo = array[i];
                this.createInterpreterItem(interpreterInfo.getName(), interpreterInfo.getExecutableOrJar());
                this.nameToInfo.put(interpreterInfo.getName(), interpreterInfo.makeCopy());
                ++i;
            }
        }
        this.updateTree();
    }

    public String getPreferenceName() {
        throw new RuntimeException("The preferences should be stored/gotten from the IInterpreterManager, and not directly.");
    }

    protected String createListFromInterpreterInfo(IInterpreterInfo[] executables) {
        return this.interpreterManager.getStringToPersist(executables);
    }

    protected IInterpreterInfo[] parseStringToInfo(String stringList) {
        return this.interpreterManager.getInterpretersFromPersistedString(stringList);
    }

    @Override
    protected void doLoadDefault() {
    }

    public boolean checkChangedAndMarkUnchanged() {
        boolean ret = this.changed;
        this.changed = false;
        return ret;
    }

    public Tuple<String, String> getAutoNewInputFromPaths(List<String> pathsToSearch, String expectedFilename, String nameForUser) {
        for (String s : pathsToSearch) {
            String[] available;
            File file;
            if (s.trim().length() <= 0 || !(file = new File(s.trim())).isDirectory()) continue;
            String[] stringArray = available = file.list();
            int n = available.length;
            int n2 = 0;
            while (n2 < n) {
                String jar = stringArray[n2];
                if (jar.toLowerCase().equals(expectedFilename)) {
                    return new Tuple((Object)this.getUniqueInterpreterName(nameForUser), (Object)REF.getFileAbsolutePath((File)new File(file, jar)));
                }
                ++n2;
            }
        }
        return null;
    }
}

