/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.SelectionKeeper;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PyCodeFormatterPage;

public class PyFormatStd
extends PyAction
implements IFormatter {
    public void run(IAction action) {
        try {
            PyEdit pyEdit = this.getPyEdit();
            PySelection ps = new PySelection((ITextEditor)pyEdit);
            try {
                this.applyFormatAction(pyEdit, ps, false, true);
            }
            catch (SyntaxErrorException e) {
                pyEdit.getStatusLineManager().setErrorMessage(e.getMessage());
            }
        }
        catch (Exception e) {
            PyFormatStd.beep(e);
        }
    }

    public void applyFormatAction(PyEdit pyEdit, PySelection ps, boolean forceFormatAll, boolean throwSyntaxError) throws BadLocationException, SyntaxErrorException {
        IFormatter participant = this.getFormatter();
        IDocument doc = ps.getDoc();
        ITextSelection selection = ps.getTextSelection();
        int startLine = ps.getStartLineIndex();
        SelectionKeeper selectionKeeper = new SelectionKeeper(ps);
        if (selection.getLength() == 0 || forceFormatAll) {
            participant.formatAll(doc, (IPyEdit)pyEdit, true, throwSyntaxError);
        } else {
            participant.formatSelection(doc, startLine, ps.getEndLineIndex(), (IPyEdit)pyEdit, ps);
        }
        selectionKeeper.restoreSelection(pyEdit.getSelectionProvider(), doc);
    }

    public IFormatter getFormatter() {
        IFormatter participant = (IFormatter)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_formatter");
        if (participant == null) {
            participant = this;
        }
        return participant;
    }

    public void formatSelection(IDocument doc, int startLine, int endLineIndex, IPyEdit edit, PySelection ps) {
        try {
            IRegion start = doc.getLineInformation(startLine);
            IRegion end = doc.getLineInformation(endLineIndex);
            int iStart = start.getOffset();
            int iEnd = end.getOffset() + end.getLength();
            String d = doc.get(iStart, iEnd - iStart);
            FormatStd formatStd = PyFormatStd.getFormat();
            String formatted = this.formatStr(d, formatStd, PySelection.getDelimiter((IDocument)doc), false);
            doc.replace(iStart, iEnd - iStart, formatted);
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
        catch (SyntaxErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public void formatAll(IDocument doc, IPyEdit edit, boolean isOpenedFile, boolean throwSyntaxError) throws SyntaxErrorException {
        FormatStd formatStd = PyFormatStd.getFormat();
        this.formatAll(doc, edit, isOpenedFile, formatStd, throwSyntaxError);
    }

    public void formatAll(IDocument doc, IPyEdit edit, boolean isOpenedFile, FormatStd formatStd, boolean throwSyntaxError) throws SyntaxErrorException {
        String d = doc.get();
        String delimiter = PySelection.getDelimiter((IDocument)doc);
        String formatted = this.formatStr(d, formatStd, delimiter, throwSyntaxError);
        String contents = doc.get();
        if (contents.equals(formatted)) {
            return;
        }
        if (!isOpenedFile) {
            doc.set(formatted);
        } else {
            int contentsLen = contents.length();
            int minorLen = contentsLen > formatted.length() ? formatted.length() : contentsLen;
            int applyFrom = 0;
            while (applyFrom < minorLen) {
                if (contents.charAt(applyFrom) != formatted.charAt(applyFrom)) break;
                ++applyFrom;
            }
            try {
                doc.replace(applyFrom, contentsLen - applyFrom, formatted.substring(applyFrom));
            }
            catch (BadLocationException e) {
                PydevPlugin.log(e);
            }
        }
    }

    public static FormatStd getFormat() {
        FormatStd formatStd = new FormatStd();
        formatStd.assignWithSpaceInsideParens = PyCodeFormatterPage.useAssignWithSpacesInsideParenthesis();
        formatStd.operatorsWithSpace = PyCodeFormatterPage.useOperatorsWithSpace();
        formatStd.parametersWithSpace = PyCodeFormatterPage.useSpaceForParentesis();
        formatStd.spaceAfterComma = PyCodeFormatterPage.useSpaceAfterComma();
        formatStd.addNewLineAtEndOfFile = PyCodeFormatterPage.getAddNewLineAtEndOfFile();
        formatStd.trimLines = PyCodeFormatterPage.getTrimLines();
        return formatStd;
    }

    public String formatStr(String str, FormatStd std, String delimiter, boolean throwSyntaxError) throws SyntaxErrorException {
        return this.formatStr(str, std, 0, delimiter, throwSyntaxError);
    }

    /*
     * Unable to fully structure code
     */
    private String formatStr(String str, FormatStd std, int parensLevel, String delimiter, boolean throwSyntaxError) throws SyntaxErrorException {
        cs = str.toCharArray();
        buf = new FastStringBuffer();
        parsingUtils = ParsingUtils.create((Object)cs, (boolean)throwSyntaxError);
        lastChar = '\u0000';
        i = 0;
        while (i < cs.length) {
            c = cs[i];
            switch (c) {
                case '\"': 
                case '\'': {
                    i = parsingUtils.eatLiterals(buf, i);
                    break;
                }
                case '#': {
                    i = parsingUtils.eatComments(buf, i);
                    break;
                }
                case ',': {
                    i = this.formatForComma(std, cs, buf, i);
                    break;
                }
                case '(': {
                    i = this.formatForPar(parsingUtils, cs, i, std, buf, parensLevel + 1, delimiter, throwSyntaxError);
                    break;
                }
                case '*': {
                    isOperator = false;
                    j = buf.length() - 1;
                    while (j >= 0) {
                        localC = buf.charAt(j);
                        if (!Character.isWhitespace(localC)) {
                            if (localC == '(' || localC == ',') break;
                            if (Character.isJavaIdentifierPart(localC)) {
                                localBufToCheckWildImport = new FastStringBuffer();
                                while (Character.isJavaIdentifierPart(localC)) {
                                    localBufToCheckWildImport.append(localC);
                                    if (--j < 0) break;
                                    localC = buf.charAt(j);
                                }
                                if (localBufToCheckWildImport.reverse().toString().equals("import")) break;
                                isOperator = true;
                                break;
                            }
                        }
                        --j;
                    }
                    if (!isOperator) {
                        buf.append('*');
                        break;
                    }
                }
                case '+': 
                case '-': {
                    if (c == '-' || c == '+') {
                        localBufToCheckNumber = new FastStringBuffer();
                        started = false;
                        for (j = buf.length() - 1; j >= 0; --j) {
                            localC = buf.charAt(j);
                            if (localC == ' ' || localC == '\t') {
                                if (started) break;
                                continue;
                            }
                            started = true;
                            if (!Character.isJavaIdentifierPart(localC)) break;
                            localBufToCheckNumber.append(localC);
                        }
                        isExponential = true;
                        partialNumber = localBufToCheckNumber.reverse().toString();
                        partialLen = partialNumber.length();
                        if (partialLen < 2 || !Character.isDigit(partialNumber.charAt(0))) {
                            isExponential = false;
                        } else if (partialNumber.charAt(partialLen - 1) != 'e' && partialNumber.charAt(partialLen - 1) != 'E') {
                            isExponential = false;
                        }
                        if (isExponential) {
                            buf.rightTrim();
                            buf.append(c);
                            initial = i;
                            while (++i < cs.length && (c = cs[i]) == ' ' || c == '\t') {
                            }
                            if (i <= initial) break;
                            --i;
                            break;
                        }
                    }
                }
                case '!': 
                case '%': 
                case '&': 
                case '/': 
                case '<': 
                case '>': 
                case '^': 
                case '|': 
                case '~': {
                    i = this.handleOperator(std, cs, buf, parsingUtils, i, c);
                    c = cs[i];
                    break;
                }
                case '=': {
                    if (i >= cs.length - 1 || cs[i + 1] != '=') ** GOTO lbl87
                    i = this.handleOperator(std, cs, buf, parsingUtils, i, c);
                    c = cs[i];
                    break;
lbl-1000:
                    // 1 sources

                    {
                        buf.deleteLast();
lbl87:
                        // 2 sources

                        ** while (buf.length() > 0 && buf.lastChar() == ' ')
                    }
lbl88:
                    // 1 sources

                    surroundWithSpaces = std.operatorsWithSpace;
                    if (parensLevel > 0) {
                        surroundWithSpaces = std.assignWithSpaceInsideParens;
                    }
                    if (surroundWithSpaces) {
                        buf.append(' ');
                    }
                    buf.append('=');
                    if (surroundWithSpaces) {
                        buf.append(' ');
                    }
                    i = parsingUtils.eatWhitespaces(null, i + 1);
                    break;
                }
                default: {
                    if (c == '\r' || c == '\n') {
                        if (lastChar == ',' && std.spaceAfterComma && buf.lastChar() == ' ') {
                            buf.deleteLast();
                        }
                        this.rightTrimIfNeeded(std, buf);
                    }
                    buf.append(c);
                }
            }
            lastChar = c;
            ++i;
        }
        if (parensLevel == 0) {
            this.rightTrimIfNeeded(std, buf);
            if (std.addNewLineAtEndOfFile && (buf.length() == 0 || (tempC = buf.lastChar()) != '\r' && tempC != '\n')) {
                buf.append(delimiter);
            }
        }
        return buf.toString();
    }

    private void rightTrimIfNeeded(FormatStd std, FastStringBuffer buf) {
        if (std.trimLines) {
            char tempC;
            while (buf.length() > 0 && ((tempC = buf.lastChar()) == ' ' || tempC == '\t')) {
                buf.deleteLast();
            }
        }
    }

    private int handleOperator(FormatStd std, char[] cs, FastStringBuffer buf, ParsingUtils parsingUtils, int i, char c) {
        Iterator iterator;
        boolean isUnaryWithContents = true;
        boolean isUnary = false;
        boolean changeWhitespacesBefore = true;
        if (c == '~' || c == '+' || c == '-') {
            boolean bl = isUnary = buf.length() == 0;
            if (!isUnary) {
                iterator = buf.reverseIterator().iterator();
                while (iterator.hasNext()) {
                    char itChar = ((Character)iterator.next()).charValue();
                    if (itChar == ' ' || itChar == '\t') continue;
                    if (itChar == '=' || itChar == ',') {
                        isUnary = true;
                    }
                    switch (itChar) {
                        case '[': 
                        case '{': {
                            changeWhitespacesBefore = false;
                        }
                        case '(': 
                        case ':': {
                            isUnaryWithContents = false;
                        }
                        case '!': 
                        case '%': 
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '^': 
                        case '|': 
                        case '~': {
                            isUnary = true;
                        }
                    }
                    break;
                }
            } else {
                boolean bl2 = isUnaryWithContents = buf.length() > 0;
            }
        }
        if (!isUnary) {
            iterator = buf.reverseIterator().iterator();
            while (iterator.hasNext()) {
                char ch = ((Character)iterator.next()).charValue();
                if (!Character.isWhitespace(ch)) break;
                if (ch != '\r' && ch != '\n') continue;
                changeWhitespacesBefore = false;
                break;
            }
        }
        if (changeWhitespacesBefore) {
            while (buf.length() > 0 && (buf.lastChar() == ' ' || buf.lastChar() == ' ')) {
                buf.deleteLast();
            }
        }
        boolean surroundWithSpaces = std.operatorsWithSpace;
        if (changeWhitespacesBefore && isUnaryWithContents && surroundWithSpaces) {
            buf.append(' ');
        }
        char localC = c;
        char prev = '\u0000';
        boolean backOne = true;
        while (this.isOperatorPart(localC, prev)) {
            buf.append(localC);
            prev = localC;
            if (++i == cs.length) break;
            localC = cs[i];
            if (localC != 61) continue;
            buf.append(localC);
            backOne = false;
            break;
        }
        if (backOne) {
            --i;
        }
        if (!isUnary && surroundWithSpaces) {
            buf.append(' ');
        }
        i = parsingUtils.eatWhitespaces(null, i + 1);
        return i;
    }

    private boolean isOperatorPart(char c, char prev) {
        switch (c) {
            case '+': 
            case '-': 
            case '~': {
                return prev == '\u0000';
            }
        }
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private int formatForPar(ParsingUtils parsingUtils, char[] cs, int i, FormatStd std, FastStringBuffer buf, int parensLevel, String delimiter, boolean throwSyntaxError) throws SyntaxErrorException {
        char c = ' ';
        FastStringBuffer locBuf = new FastStringBuffer();
        int j = i + 1;
        while (j < cs.length && (c = cs[j]) != ')') {
            ++j;
            if (c == '\'' || c == '\"') {
                j = parsingUtils.eatLiterals(locBuf, j - 1) + 1;
                continue;
            }
            if (c == '#') {
                j = parsingUtils.eatComments(locBuf, j - 1) + 1;
                continue;
            }
            if (c == '(') {
                j = this.formatForPar(parsingUtils, cs, j - 1, std, locBuf, parensLevel + 1, delimiter, throwSyntaxError) + 1;
                continue;
            }
            locBuf.append(c);
        }
        if (c == ')') {
            FastStringBuffer buf1 = new FastStringBuffer();
            if (locBuf.indexOf('\n') != -1 || locBuf.indexOf('\r') != -1) {
                char c1;
                int k = locBuf.length();
                while (k > 0 && (c1 = locBuf.charAt(k - 1)) != '\n' && c1 != '\r') {
                    buf1.insert(0, c1);
                    --k;
                }
            }
            String formatStr = this.formatStr(this.trim(locBuf).toString(), std, parensLevel, delimiter, throwSyntaxError);
            FastStringBuffer formatStrBuf = this.trim(new FastStringBuffer(formatStr, 10));
            String closing = ")";
            if (buf1.length() > 0 && PySelection.containsOnlyWhitespaces((String)buf1.toString())) {
                formatStrBuf.append(buf1);
            } else if (std.parametersWithSpace) {
                closing = " )";
            }
            if (std.parametersWithSpace) {
                if (formatStrBuf.length() == 0) {
                    buf.append("()");
                } else {
                    buf.append("( ");
                    buf.append(formatStrBuf);
                    buf.append(closing);
                }
            } else {
                buf.append('(');
                buf.append(formatStrBuf);
                buf.append(closing);
            }
            return j;
        }
        buf.append('(');
        return i;
    }

    private FastStringBuffer trim(FastStringBuffer locBuf) {
        while (locBuf.length() > 0 && (locBuf.firstChar() == ' ' || locBuf.firstChar() == '\t')) {
            locBuf.deleteCharAt(0);
        }
        this.rtrim(locBuf);
        return locBuf;
    }

    private FastStringBuffer rtrim(FastStringBuffer locBuf) {
        while (locBuf.length() > 0 && (locBuf.lastChar() == ' ' || locBuf.lastChar() == '\t')) {
            locBuf.deleteLast();
        }
        return locBuf;
    }

    private int formatForComma(FormatStd std, char[] cs, FastStringBuffer buf, int i) {
        while (i < cs.length - 1 && cs[i + 1] == ' ') {
            ++i;
        }
        if (std.spaceAfterComma) {
            buf.append(", ");
        } else {
            buf.append(',');
        }
        return i;
    }

    public static class FormatStd {
        public boolean spaceAfterComma;
        public boolean parametersWithSpace;
        public boolean assignWithSpaceInsideParens;
        public boolean operatorsWithSpace;
        public boolean addNewLineAtEndOfFile;
        public boolean trimLines;
    }
}

