/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.ui;

import com.python.pydev.analysis.AnalysisPlugin;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;

public class AutoImportsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static boolean TESTS_DO_AUTO_IMPORT = true;
    public static boolean TESTS_DO_AUTO_IMPORT_ON_ORGANIZE_IMPORTS = true;
    public static boolean TESTS_DO_IGNORE_IMPORT_STARTING_WITH_UNDER = false;

    public AutoImportsPreferencesPage() {
        super(0);
        this.setDescription("Auto Imports");
        this.setPreferenceStore(null);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AutoImportsPreferencesPage.getPlugin().getPreferenceStore();
    }

    public void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor("DO_AUTO_IMPORT", "Do auto import?", 0, p));
        this.addField((FieldEditor)new BooleanFieldEditor("DO_IGNORE_FIELDS_WITH_UNDER", "Ignore last modules starting with '_' when doing auto-import/quick fix?", 0, p));
        this.addField((FieldEditor)new BooleanFieldEditor("DO_AUTO_IMPORT_ON_ORGANIZE_IMPORTS", "Do auto import on organize imports (Ctrl+Shift+O)?", 0, p));
    }

    public static String removeImportsStartingWithUnderIfNeeded(String declPackageWithoutInit, FastStringBuffer buf) {
        block5: {
            if (!AutoImportsPreferencesPage.doIgnoreImportsStartingWithUnder()) break block5;
            List splitted = StringUtils.dotSplit((String)declPackageWithoutInit);
            boolean foundStartingWithoutUnder = false;
            buf.clear();
            int i = splitted.size() - 1;
            while (i >= 0) {
                block7: {
                    String s;
                    block6: {
                        s = (String)splitted.get(i);
                        if (foundStartingWithoutUnder) break block6;
                        if (s.charAt(0) == '_') break block7;
                        foundStartingWithoutUnder = true;
                    }
                    buf.insert(0, s);
                    if (i != 0) {
                        buf.insert(0, '.');
                    }
                }
                --i;
            }
            declPackageWithoutInit = buf.toString();
        }
        return declPackageWithoutInit;
    }

    private static AnalysisPlugin getPlugin() {
        return AnalysisPlugin.getDefault();
    }

    public static boolean doAutoImport() {
        AnalysisPlugin plugin = AutoImportsPreferencesPage.getPlugin();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("DO_AUTO_IMPORT");
        }
        return TESTS_DO_AUTO_IMPORT;
    }

    public static boolean doAutoImportOnOrganizeImports() {
        AnalysisPlugin plugin = AutoImportsPreferencesPage.getPlugin();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("DO_AUTO_IMPORT_ON_ORGANIZE_IMPORTS");
        }
        return TESTS_DO_AUTO_IMPORT_ON_ORGANIZE_IMPORTS;
    }

    public static boolean doIgnoreImportsStartingWithUnder() {
        AnalysisPlugin plugin = AutoImportsPreferencesPage.getPlugin();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("DO_IGNORE_FIELDS_WITH_UNDER");
        }
        return TESTS_DO_IGNORE_IMPORT_STARTING_WITH_UNDER;
    }
}

