/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.PydevConsoleCompletionProcessor;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.PydevConsoleQuickAssistProcessor;
import org.python.pydev.debug.newconsole.PydevConsoleTextHover;
import org.python.pydev.debug.newconsole.prefs.ColorManager;
import org.python.pydev.debug.ui.PythonConsoleLineTracker;
import org.python.pydev.dltk.console.IScriptConsoleInterpreter;
import org.python.pydev.dltk.console.IScriptConsoleShell;
import org.python.pydev.dltk.console.ScriptConsolePrompt;
import org.python.pydev.dltk.console.ui.IConsoleStyleProvider;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.ScriptStyleRange;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.editor.correctionassist.PyCorrectionAssistant;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevConsole
extends ScriptConsole {
    public static final String CONSOLE_NAME = "Pydev Console";
    public static int nextId = -1;
    private String additionalInitialComands;

    private static String getNextId() {
        return String.valueOf(++nextId);
    }

    public PydevConsole(PydevConsoleInterpreter interpreter, String additionalInitialComands) {
        super(new StringBuffer("Pydev Console [").append(PydevConsole.getNextId()).append("]").toString(), "org.python.pydev.debug.newconsole.PydevConsole", (IScriptConsoleInterpreter)interpreter);
        this.additionalInitialComands = additionalInitialComands;
        this.setPydevConsoleBackground(ColorManager.getDefault().getConsoleBackgroundColor());
    }

    public IConsoleStyleProvider createStyleProvider() {
        return new IConsoleStyleProvider(){

            private ScriptStyleRange getIt(String content, int offset, TextAttribute attr, int scriptStyle) {
                return new ScriptStyleRange(offset, content.length(), attr.getForeground(), null, scriptStyle, attr.getStyle());
            }

            public ScriptStyleRange createInterpreterErrorStyle(String content, int offset) {
                TextAttribute attr = ColorManager.getDefault().getConsoleErrorTextAttribute();
                return this.getIt(content, offset, attr, 3);
            }

            public ScriptStyleRange createInterpreterOutputStyle(String content, int offset) {
                TextAttribute attr = ColorManager.getDefault().getConsoleOutputTextAttribute();
                return this.getIt(content, offset, attr, 2);
            }

            public ScriptStyleRange createPromptStyle(String content, int offset) {
                TextAttribute attr = ColorManager.getDefault().getConsolePromptTextAttribute();
                return this.getIt(content, offset, attr, 1);
            }

            public ScriptStyleRange createUserInputStyle(String content, int offset) {
                TextAttribute attr = ColorManager.getDefault().getConsoleInputTextAttribute();
                return this.getIt(content, offset, attr, 0);
            }
        };
    }

    protected PydevConsoleCompletionProcessor createConsoleCompletionProcessor(PyContentAssistant pyContentAssistant) {
        return new PydevConsoleCompletionProcessor((IScriptConsoleShell)this.interpreter, pyContentAssistant);
    }

    protected IQuickAssistProcessor createConsoleQuickAssistProcessor(PyCorrectionAssistant quickAssist) {
        return new PydevConsoleQuickAssistProcessor(quickAssist);
    }

    protected ITextHover createHover() {
        return new PydevConsoleTextHover((IScriptConsoleShell)this.interpreter);
    }

    protected ScriptConsolePrompt createConsolePrompt() {
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String newPrompt = store.getString("pydevconsole_new_invitation");
        String continuePrompt = store.getString("pydevconsole_continue_invitation");
        if (newPrompt == null || newPrompt.length() == 0) {
            newPrompt = ">>> ";
        }
        if (continuePrompt == null || continuePrompt.length() == 0) {
            continuePrompt = "... ";
        }
        return new ScriptConsolePrompt(newPrompt, continuePrompt);
    }

    public List<IConsoleLineTracker> getLineTrackers() {
        ArrayList<IConsoleLineTracker> lineTrackers = new ArrayList<IConsoleLineTracker>();
        PythonConsoleLineTracker lineTracker = new PythonConsoleLineTracker();
        lineTracker.init(new IConsole(){

            public void addLink(IConsoleHyperlink link, int offset, int length) {
                PydevConsole.this.addLink(link, offset, length);
            }

            public void addLink(IHyperlink link, int offset, int length) {
                PydevConsole.this.addLink(link, offset, length);
            }

            public void addPatternMatchListener(IPatternMatchListener matchListener) {
                PydevConsole.this.addPatternMatchListener(matchListener);
            }

            public IDocument getDocument() {
                return PydevConsole.this.getDocument();
            }

            public IRegion getRegion(IConsoleHyperlink link) {
                return PydevConsole.this.getRegion((IHyperlink)link);
            }

            public IRegion getRegion(IHyperlink link) {
                return PydevConsole.this.getRegion(link);
            }

            public void removePatternMatchListener(IPatternMatchListener matchListener) {
                PydevConsole.this.removePatternMatchListener(matchListener);
            }

            public void connect(IStreamsProxy streamsProxy) {
            }

            public void connect(IStreamMonitor streamMonitor, String streamIdentifer) {
            }

            public IProcess getProcess() {
                return null;
            }

            public IOConsoleOutputStream getStream(String streamIdentifier) {
                return null;
            }
        });
        lineTrackers.add(lineTracker);
        return lineTrackers;
    }

    public String getInitialCommands() {
        String str = PydevDebugPlugin.getDefault().getPreferenceStore().getString("INITIAL_INTERPRETER_CMDS");
        if (this.additionalInitialComands != null) {
            str = new StringBuffer(String.valueOf(str)).append(this.additionalInitialComands).toString();
        }
        return str;
    }

    public void addLink(IConsoleHyperlink link, int offset, int length) {
        this.addLink((IHyperlink)link, offset, length);
    }

    public void addLink(IHyperlink link, int offset, int length) {
        try {
            super.addHyperlink(link, offset, length);
        }
        catch (BadLocationException e) {
            PydevPlugin.log((Throwable)e);
        }
    }

    protected /* synthetic */ IContentAssistProcessor createConsoleCompletionProcessor(PyContentAssistant pyContentAssistant) {
        return this.createConsoleCompletionProcessor(pyContentAssistant);
    }
}

