/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.scopeanalysis;

import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.GenAndTok;
import com.python.pydev.analysis.visitors.Scope;
import com.python.pydev.analysis.visitors.ScopeItems;
import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.TupleN;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.LocalScope;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScopeAnalyzerVisitor
extends VisitorBase {
    protected IPythonNature nature;
    protected String moduleName;
    public Scope scope;
    protected List<Found> probablyNotDefined = new ArrayList<Found>();
    protected IModule current;
    protected volatile IProgressMonitor monitor;
    protected IDocument document;
    protected volatile ICompletionCache completionCache;
    private LocalScope currentLocalScope = new LocalScope();

    protected abstract void onAfterVisitAssign(Assign var1);

    protected abstract void onAfterStartScope(int var1, SimpleNode var2);

    protected abstract void onBeforeEndScope(SimpleNode var1);

    protected abstract void onAfterEndScope(SimpleNode var1, ScopeItems var2);

    protected abstract void onLastScope(ScopeItems var1);

    protected abstract void onAddUndefinedMessage(IToken var1, Found var2);

    protected abstract void onAddUndefinedVarInImportMessage(IToken var1, Found var2);

    public abstract void onAddUnusedMessage(SimpleNode var1, Found var2);

    public abstract void onAddReimportMessage(Found var1);

    public abstract void onAddUnresolvedImport(IToken var1);

    public abstract void onAddDuplicatedSignature(SourceToken var1, String var2);

    public abstract void onAddNoSelf(SourceToken var1, Object[] var2);

    public AbstractScopeAnalyzerVisitor(IPythonNature nature, String moduleName, IModule current, IDocument document, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.current = current;
        this.nature = nature;
        this.moduleName = moduleName;
        this.document = document;
        this.scope = new Scope(this, nature, moduleName);
        if (current instanceof SourceModule) {
            this.currentLocalScope.getScopeStack().push((Object)((SourceModule)current).getAst());
        }
        this.startScope(1, null);
        ICompletionState completionState = CompletionStateFactory.getEmptyCompletionState((IPythonNature)nature, (ICompletionCache)new CompletionCache());
        this.completionCache = completionState;
        List builtinCompletions = nature.getAstManager().getBuiltinCompletions(completionState, new ArrayList());
        if (moduleName != null && moduleName.endsWith("__init__")) {
            builtinCompletions.add(new SourceToken((SimpleNode)new Name("__path__", 1, false), "__path__", "", "", moduleName));
        }
        for (IToken t : builtinCompletions) {
            Found found = this.makeFound(t);
            org.python.pydev.core.Tuple tup = new org.python.pydev.core.Tuple((Object)t, (Object)found);
            this.addToNamesToIgnore(t, this.scope.getCurrScopeItems(), (org.python.pydev.core.Tuple<IToken, Found>)tup);
        }
    }

    protected void checkStop() {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        this.checkStop();
        return null;
    }

    public void traverse(SimpleNode node) throws Exception {
        this.checkStop();
        node.traverse((VisitorIF)this);
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        int i;
        this.unhandled_node((SimpleNode)node);
        AbstractScopeAnalyzerVisitor visitor = this;
        this.handleDecorators(node.decs);
        if (node.bases != null) {
            i = 0;
            while (i < node.bases.length) {
                if (node.bases[i] != null) {
                    node.bases[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        this.currentLocalScope.getScopeStack().push((Object)node);
        this.startScope(4, (SimpleNode)node);
        if (node.name != null) {
            node.name.accept((VisitorIF)visitor);
        }
        if (node.body != null) {
            i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        this.endScope((SimpleNode)node);
        this.currentLocalScope.getScopeStack().pop();
        this.addToNamesToIgnore((SimpleNode)node, true);
        return null;
    }

    protected void addToNamesToIgnore(SimpleNode node, boolean finishClassScope) {
        SourceToken token = AbstractVisitor.makeToken((SimpleNode)node, (String)"");
        ScopeItems currScopeItems = this.scope.getCurrScopeItems();
        Found found = new Found((IToken)token, (IToken)token, this.scope.getCurrScopeId(), this.scope.getCurrScopeItems());
        org.python.pydev.core.Tuple tup = new org.python.pydev.core.Tuple((Object)token, (Object)found);
        this.addToNamesToIgnore((IToken)token, currScopeItems, (org.python.pydev.core.Tuple<IToken, Found>)tup);
        Iterator<Found> it = this.probablyNotDefined.iterator();
        while (it.hasNext()) {
            IToken tok;
            String rep;
            Found n = it.next();
            GenAndTok single = n.getSingle();
            int foundScopeType = single.scopeFound.getScopeType();
            if ((foundScopeType & 0x12) != 0 && this.scope.getCurrScopeItems().getScopeType() == 4 || !(rep = (tok = single.tok).getRepresentation()).equals(token.getRepresentation())) continue;
            if (finishClassScope && foundScopeType == 4 && this.scope.getCurrScopeId() < single.scopeFound.getScopeId()) {
                it.remove();
                this.onAddUndefinedMessage(tok, found);
                continue;
            }
            it.remove();
            this.onNotDefinedFoundLater(n, found);
        }
    }

    protected void addToNamesToIgnore(IToken token, ScopeItems currScopeItems, org.python.pydev.core.Tuple<IToken, Found> tup) {
        currScopeItems.namesToIgnore.put(token.getRepresentation(), tup);
        this.onAfterAddToNamesToIgnore(currScopeItems, tup);
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        exprType expr;
        int n;
        int n2;
        exprType[] exprTypeArray;
        this.unhandled_node((SimpleNode)node);
        this.addToNamesToIgnore((SimpleNode)node, false);
        AbstractScopeAnalyzerVisitor visitor = this;
        argumentsType args = node.args;
        if (args.defaults != null) {
            exprTypeArray = args.defaults;
            n2 = args.defaults.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                if (expr != null) {
                    expr.accept((VisitorIF)visitor);
                }
                ++n;
            }
        }
        this.handleDecorators(node.decs);
        this.startScope(2, (SimpleNode)node);
        this.currentLocalScope.getScopeStack().push((Object)node);
        this.scope.isInMethodDefinition = true;
        if (args.args != null) {
            exprTypeArray = args.args;
            n2 = args.args.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                expr.accept((VisitorIF)visitor);
                ++n;
            }
        }
        if (args.vararg != null) {
            args.vararg.accept((VisitorIF)visitor);
        }
        if (args.kwarg != null) {
            args.kwarg.accept((VisitorIF)visitor);
        }
        if (args.kwonlyargs != null) {
            exprTypeArray = args.kwonlyargs;
            n2 = args.kwonlyargs.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                expr.accept((VisitorIF)visitor);
                ++n;
            }
        }
        this.scope.isInMethodDefinition = false;
        if (node.body != null) {
            int i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        this.endScope((SimpleNode)node);
        this.currentLocalScope.getScopeStack().pop();
        return null;
    }

    protected void handleDecorators(decoratorsType[] decs) throws Exception {
        if (decs != null) {
            decoratorsType[] decoratorsTypeArray = decs;
            int n = decs.length;
            int n2 = 0;
            while (n2 < n) {
                decoratorsType dec = decoratorsTypeArray[n2];
                if (dec != null) {
                    this.handleDecorator(dec);
                }
                ++n2;
            }
        }
    }

    protected void handleDecorator(decoratorsType dec) throws Exception {
        dec.accept((VisitorIF)this);
    }

    public Object visitLambda(Lambda node) throws Exception {
        exprType expr;
        int n;
        int n2;
        exprType[] exprTypeArray;
        this.unhandled_node((SimpleNode)node);
        AbstractScopeAnalyzerVisitor visitor = this;
        argumentsType args = node.args;
        if (args.defaults != null) {
            exprTypeArray = args.defaults;
            n2 = args.defaults.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                if (expr != null) {
                    expr.accept((VisitorIF)visitor);
                }
                ++n;
            }
        }
        this.startScope(16, (SimpleNode)node);
        this.scope.isInMethodDefinition = true;
        if (args.args != null) {
            exprTypeArray = args.args;
            n2 = args.args.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                expr.accept((VisitorIF)visitor);
                ++n;
            }
        }
        if (args.vararg != null) {
            args.vararg.accept((VisitorIF)visitor);
        }
        if (args.kwarg != null) {
            args.kwarg.accept((VisitorIF)visitor);
        }
        if (args.kwonlyargs != null) {
            exprTypeArray = args.kwonlyargs;
            n2 = args.kwonlyargs.length;
            n = 0;
            while (n < n2) {
                expr = exprTypeArray[n];
                expr.accept((VisitorIF)visitor);
                ++n;
            }
        }
        this.scope.isInMethodDefinition = false;
        if (node.body != null) {
            node.body.accept((VisitorIF)visitor);
        }
        this.endScope((SimpleNode)node);
        return null;
    }

    public Object visitNameTok(NameTok nameTok) throws Exception {
        this.unhandled_node((SimpleNode)nameTok);
        if (nameTok.ctx == 5 || nameTok.ctx == 6) {
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)nameTok, (String)this.moduleName);
            this.scope.addToken((IToken)token, (IToken)token, nameTok.id);
        }
        return null;
    }

    public Object visitAugAssign(AugAssign node) throws Exception {
        return super.visitAugAssign(node);
    }

    public Object visitImport(Import node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        List list = AbstractVisitor.makeImportToken((Import)node, null, (String)this.moduleName, (boolean)true);
        this.scope.addImportTokens(list, null, this.completionCache);
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        try {
            if (AbstractVisitor.isWildImport((ImportFrom)node)) {
                IToken wildImport = AbstractVisitor.makeWildImportToken((ImportFrom)node, null, (String)this.moduleName);
                ICompletionState state = CompletionStateFactory.getEmptyCompletionState((IPythonNature)this.nature, (ICompletionCache)this.completionCache);
                state.setBuiltinsGotten(true);
                ArrayList<IToken> completionsForWildImport = new ArrayList<IToken>();
                if (this.nature.getAstManager().getCompletionsForWildImport(state, this.current, completionsForWildImport, wildImport)) {
                    this.scope.addImportTokens(completionsForWildImport, wildImport, this.completionCache);
                }
            } else {
                List list = AbstractVisitor.makeImportToken((ImportFrom)node, null, (String)this.moduleName, (boolean)true);
                this.scope.addImportTokens(list, null, this.completionCache);
            }
        }
        catch (Exception e) {
            PydevPlugin.log((int)4, (String)new StringBuffer("Error when analyzing module ").append(this.moduleName).toString(), (Throwable)e);
        }
        return null;
    }

    public Object visitName(Name node) throws Exception {
        String rep;
        boolean inNamesToIgnore;
        this.unhandled_node((SimpleNode)node);
        SourceToken token = AbstractVisitor.makeToken((SimpleNode)node, (String)this.moduleName);
        boolean found = true;
        if (node.ctx == 1 || node.ctx == 3 || node.ctx == 5) {
            found = this.markRead((IToken)token);
        }
        if ((node.ctx == 2 || node.ctx == 6 || node.ctx == 8 || node.ctx == 5 && found) && !(inNamesToIgnore = this.doCheckIsInNamesToIgnore(rep = token.getRepresentation(), (IToken)token))) {
            if (!rep.equals("self") && !rep.equals("cls")) {
                this.scope.addToken((IToken)token, (IToken)token);
            } else {
                this.addToNamesToIgnore((SimpleNode)node, false);
            }
        }
        return null;
    }

    protected boolean doCheckIsInNamesToIgnore(String rep, IToken token) {
        org.python.pydev.core.Tuple<IToken, Found> found = this.scope.isInNamesToIgnore(rep);
        return found != null;
    }

    public Object visitGlobal(Global node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        NameTokType[] nameTokTypeArray = node.names;
        int n = node.names.length;
        int n2 = 0;
        while (n2 < n) {
            NameTokType name = nameTokTypeArray[n2];
            Name nameAst = new Name(((NameTok)name).id, 2, false);
            nameAst.beginLine = name.beginLine;
            nameAst.beginColumn = name.beginColumn;
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)nameAst, (String)this.moduleName);
            this.scope.addTokenToGlobalScope((IToken)token);
            this.addToNamesToIgnore((SimpleNode)nameAst, false);
            ++n2;
        }
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        boolean doReturn = AbstractScopeAnalyzerVisitor.visitNeededAttributeParts(node, this);
        if (doReturn) {
            return null;
        }
        SourceToken token = AbstractVisitor.makeFullNameToken((SimpleNode)node, (String)this.moduleName);
        if (token.getRepresentation().equals("")) {
            return null;
        }
        String fullRep = token.getRepresentation();
        if (node.ctx == 2 || node.ctx == 6 || node.ctx == 8 || node.ctx == 5) {
            int i = fullRep.indexOf(46, 0);
            String sub = fullRep;
            if (i > 0) {
                sub = fullRep.substring(0, i);
            }
            this.markRead((IToken)token, sub, true, false);
        } else if (node.ctx == 1) {
            Iterator it = new FullRepIterable(fullRep).iterator();
            boolean found = false;
            while (it.hasNext()) {
                String sub = (String)it.next();
                if (it.hasNext()) {
                    if (!this.markRead((IToken)token, sub, false, false)) continue;
                    found = true;
                    continue;
                }
                this.markRead((IToken)token, fullRep, !found, true);
            }
        }
        return null;
    }

    public static boolean visitNeededAttributeParts(Attribute node, VisitorBase base) throws Exception {
        exprType value = node.value;
        boolean valueVisited = false;
        boolean doReturn = false;
        if (value instanceof Subscript) {
            Subscript subs = (Subscript)value;
            base.traverse((SimpleNode)subs.slice);
            if (subs.value instanceof Name) {
                base.visitName((Name)subs.value);
            } else {
                base.traverse((SimpleNode)subs.value);
            }
            doReturn = true;
        } else if (value instanceof Call) {
            AbstractScopeAnalyzerVisitor.visitCallAttr((Call)value, base);
            valueVisited = true;
        } else if (value instanceof Tuple) {
            base.visitTuple((Tuple)value);
            valueVisited = true;
        } else if (value instanceof Dict) {
            base.visitDict((Dict)value);
            doReturn = true;
        }
        if (!doReturn && !valueVisited && AbstractScopeAnalyzerVisitor.visitNeededValues(value, base)) {
            doReturn = true;
        }
        return doReturn;
    }

    protected static boolean visitNeededValues(exprType value, VisitorBase base) throws Exception {
        if (value instanceof Name) {
            return false;
        }
        if (value instanceof Attribute) {
            return AbstractScopeAnalyzerVisitor.visitNeededValues(((Attribute)value).value, base);
        }
        value.accept((VisitorIF)base);
        return true;
    }

    protected static void visitCallAttr(Call c, VisitorBase base) throws Exception {
        int i;
        VisitorBase visitor = base;
        if (c.func instanceof Attribute) {
            base.visitAttribute((Attribute)c.func);
        }
        if (c.args != null) {
            i = 0;
            while (i < c.args.length) {
                if (c.args[i] != null) {
                    c.args[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        if (c.keywords != null) {
            i = 0;
            while (i < c.keywords.length) {
                if (c.keywords[i] != null) {
                    c.keywords[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        if (c.starargs != null) {
            c.starargs.accept((VisitorIF)visitor);
        }
        if (c.kwargs != null) {
            c.kwargs.accept((VisitorIF)visitor);
        }
    }

    public Object visitFor(For node) throws Exception {
        this.scope.addIfSubScope();
        Object ret = super.visitFor(node);
        this.scope.removeIfSubScope();
        return ret;
    }

    public Object visitAssign(Assign node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        AbstractScopeAnalyzerVisitor visitor = this;
        if (node.value != null) {
            node.value.accept((VisitorIF)visitor);
        }
        if (node.targets != null) {
            int i = 0;
            while (i < node.targets.length) {
                if (node.targets[i] != null) {
                    node.targets[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        this.onAfterVisitAssign(node);
        return null;
    }

    public Object visitIf(If node) throws Exception {
        this.scope.addIfSubScope();
        Object r = super.visitIf(node);
        this.scope.removeIfSubScope();
        return r;
    }

    public Object visitWhile(While node) throws Exception {
        this.scope.addIfSubScope();
        Object r = super.visitWhile(node);
        this.scope.removeIfSubScope();
        return r;
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        this.scope.addTryExceptSubScope(node);
        Object r = super.visitTryExcept(node);
        this.scope.removeTryExceptSubScope();
        return r;
    }

    public Object visitTryFinally(TryFinally node) throws Exception {
        this.scope.addIfSubScope();
        Object r = super.visitTryFinally(node);
        this.scope.removeIfSubScope();
        return r;
    }

    public Object visitListComp(ListComp node) throws Exception {
        this.unhandled_node((SimpleNode)node);
        if (node.ctx == 2) {
            this.startScope(8, (SimpleNode)node);
        }
        try {
            Comprehension type = null;
            if (node.generators != null && node.generators.length > 0) {
                type = (Comprehension)node.generators[0];
            }
            ArrayList<exprType> eltsToVisit = new ArrayList<exprType>();
            if (type != null && type.iter instanceof ListComp) {
                ListComp listComp = (ListComp)type.iter;
                if (listComp.ctx == 2) {
                    this.startScope(8, (SimpleNode)listComp);
                }
                try {
                    this.visitListCompGenerators(listComp, eltsToVisit);
                    for (exprType type2 : eltsToVisit) {
                        type2.accept((VisitorIF)this);
                    }
                }
                finally {
                    if (listComp.ctx == 2) {
                        this.endScope((SimpleNode)listComp);
                    }
                }
                type.target.accept((VisitorIF)this);
                if (node.elt != null) {
                    node.elt.accept((VisitorIF)this);
                }
                return null;
            }
            if (node.generators != null) {
                int i = 0;
                while (i < node.generators.length) {
                    if (node.generators[i] != null) {
                        node.generators[i].accept((VisitorIF)this);
                    }
                    ++i;
                }
            }
            if (node.elt instanceof ListComp) {
                this.visitListCompGenerators((ListComp)node.elt, eltsToVisit);
                for (exprType type2 : eltsToVisit) {
                    type2.accept((VisitorIF)this);
                }
                return null;
            }
            if (node.elt != null) {
                node.elt.accept((VisitorIF)this);
            }
            return null;
        }
        finally {
            if (node.ctx == 2) {
                this.endScope((SimpleNode)node);
            }
        }
    }

    private void visitListCompGenerators(ListComp node, List<exprType> eltsToVisit) throws Exception {
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            Comprehension comp = (Comprehension)c;
            if (node.elt instanceof ListComp) {
                this.visitListCompGenerators((ListComp)node.elt, eltsToVisit);
                comp.accept((VisitorIF)this);
            } else {
                comp.accept((VisitorIF)this);
                eltsToVisit.add(node.elt);
            }
            ++n2;
        }
    }

    protected void startScope(int newScopeType, SimpleNode node) {
        this.scope.startScope(newScopeType);
        this.onAfterStartScope(newScopeType, node);
    }

    protected void endScope(SimpleNode node) {
        this.onBeforeEndScope(node);
        ScopeItems m = this.scope.endScope();
        Iterator<Found> it = this.probablyNotDefined.iterator();
        while (it.hasNext()) {
            Found n = it.next();
            GenAndTok probablyNotDefinedFirst = n.getSingle();
            IToken tok = probablyNotDefinedFirst.tok;
            String rep = tok.getRepresentation();
            List<Found> foundItems = this.find(m, rep);
            boolean setUsed = false;
            for (Found found : foundItems) {
                GenAndTok foundItemFirst = found.getSingle();
                if ((probablyNotDefinedFirst.scopeFound.getScopeType() & 0x12) == 0 || m.getScopeType() == 4 || foundItemFirst.scopeId >= probablyNotDefinedFirst.scopeId) continue;
                found.setUsed(true);
                setUsed = true;
            }
            if (!setUsed) continue;
            it.remove();
        }
        if (this.scope.size() == 0) {
            this.onLastScope(m);
        }
        this.onAfterEndScope(node, m);
    }

    protected List<Found> find(ScopeItems m, String fullRep) {
        ArrayList<Found> foundItems = new ArrayList<Found>();
        if (m == null) {
            return foundItems;
        }
        int i = fullRep.indexOf(46, 0);
        while (i >= 0) {
            String sub = fullRep.substring(0, i);
            i = fullRep.indexOf(46, i + 1);
            foundItems.addAll(m.getAll(sub));
        }
        foundItems.addAll(m.getAll(fullRep));
        return foundItems;
    }

    protected boolean markRead(IToken token) {
        String rep = token.getRepresentation();
        return this.markRead(token, rep, true, false);
    }

    protected boolean markRead(IToken token, String rep, boolean addToNotDefined, boolean checkIfIsValidImportToken) {
        boolean found;
        block24: {
            found = false;
            Found foundAs = null;
            String foundAsStr = null;
            int acceptedScopes = 0;
            ScopeItems currScopeItems = this.scope.getCurrScopeItems();
            acceptedScopes = (currScopeItems.getScopeType() & 0x12) != 0 ? 27 : 31;
            if ("locals".equals(rep)) {
                for (Found f : currScopeItems.getAll()) {
                    f.setUsed(true);
                }
                return true;
            }
            Iterator it = new FullRepIterable(rep, true).iterator();
            while (!found && it.hasNext()) {
                String nextTokToSearch = (String)it.next();
                foundAs = this.scope.findFirst(nextTokToSearch, true, acceptedScopes);
                boolean bl = found = foundAs != null;
                if (!found) continue;
                foundAsStr = nextTokToSearch;
                foundAs.getSingle().references.add(token);
            }
            if (!found) {
                int i = rep.indexOf(46);
                if (i != -1) {
                    rep = rep.substring(0, i);
                }
                if (addToNotDefined && !this.doCheckIsInNamesToIgnore(rep, token)) {
                    if (this.scope.size() > 1) {
                        Found foundForProbablyNotDefined = this.makeFound(token);
                        this.probablyNotDefined.add(foundForProbablyNotDefined);
                        this.onAddToProbablyNotDefined(token, foundForProbablyNotDefined);
                    } else {
                        this.onAddUndefinedMessage(token, this.makeFound(token));
                    }
                }
            } else if (checkIfIsValidImportToken) {
                try {
                    if (foundAs.isImport() && !rep.equals(foundAsStr) && foundAs.importInfo.wasResolved) {
                        String tokToCheck;
                        IModule m = foundAs.importInfo.mod;
                        if (foundAs.isWildImport()) {
                            tokToCheck = foundAsStr;
                        } else {
                            String tok = foundAs.importInfo.rep;
                            tokToCheck = rep.substring(foundAsStr.length() + 1);
                            if (tok.length() > 0) {
                                tokToCheck = new StringBuffer(String.valueOf(tok)).append(".").append(tokToCheck).toString();
                            }
                        }
                        for (String repToCheck : new FullRepIterable(tokToCheck)) {
                            int inGlobalTokens = m.isInGlobalTokens(repToCheck, this.nature, true, true, this.completionCache);
                            if (inGlobalTokens == 0) {
                                if (!this.isDefinitionUnknown(m, repToCheck)) {
                                    Collection interfaceForLocal = this.currentLocalScope.getInterfaceForLocal(foundAsStr, false, true);
                                    boolean foundInHasAttr = false;
                                    for (IToken iToken : interfaceForLocal) {
                                        if (!iToken.getRepresentation().equals(repToCheck)) continue;
                                        foundInHasAttr = true;
                                        break;
                                    }
                                    if (!foundInHasAttr) {
                                        IToken foundTok = this.findNameTok(token, repToCheck);
                                        this.onAddUndefinedVarInImportMessage(foundTok, foundAs);
                                    }
                                }
                            } else if (inGlobalTokens != 2) {
                                continue;
                            }
                            break block24;
                        }
                        break block24;
                    }
                    if (foundAs.isImport() && !foundAs.importInfo.wasResolved) {
                        this.onFoundUnresolvedImportPart(token, rep, foundAs);
                    }
                }
                catch (Exception e) {
                    PydevPlugin.log((String)new StringBuffer("Error checking for valid tokens (imports) for ").append(this.moduleName).toString(), (Throwable)e);
                }
            }
        }
        return found;
    }

    private boolean isDefinitionUnknown(IModule m, String repToCheck) throws Exception {
        String name = m.getName();
        TupleN key = new TupleN(new Object[]{"isDefinitionUnknown", name != null ? name : "", repToCheck});
        Boolean isUnknown = (Boolean)this.completionCache.getObj((Object)key);
        if (isUnknown == null) {
            isUnknown = Autobox.valueOf((boolean)this.internalGenerateIsDefinitionUnknown(m, repToCheck));
            this.completionCache.add((Object)key, (Object)isUnknown);
        }
        return isUnknown;
    }

    private boolean internalGenerateIsDefinitionUnknown(IModule m, String repToCheck) throws Exception {
        if (!(m instanceof SourceModule)) {
            return false;
        }
        if ((repToCheck = FullRepIterable.headAndTail((String)repToCheck, (boolean)true)[0]).length() == 0) {
            return false;
        }
        IDefinition[] definitions = m.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)repToCheck, (IPythonNature)this.nature, (ICompletionCache)this.completionCache), -1, -1, this.nature);
        if (definitions.length == 1) {
            IDefinition foundDefinition = definitions[0];
            if (foundDefinition instanceof AssignDefinition) {
                AssignDefinition d = (AssignDefinition)definitions[0];
                if (d.value.equals("None")) {
                    return true;
                }
                IDefinition[] definitions2 = d.module.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)d.value, (IPythonNature)this.nature, (ICompletionCache)this.completionCache), d.line, d.col, this.nature);
                if (definitions2.length == 1 && definitions2[0] instanceof Definition) {
                    ClassDef def;
                    Definition definition = (Definition)definitions2[0];
                    if (definition.ast instanceof FunctionDef) {
                        return true;
                    }
                    if (definition.ast instanceof ClassDef && this.isDynamicClass(def = (ClassDef)definition.ast)) {
                        return true;
                    }
                }
            } else if (foundDefinition instanceof Definition) {
                ClassDef classDef;
                Definition definition = (Definition)foundDefinition;
                if (definition.ast instanceof ClassDef && this.isDynamicClass(classDef = (ClassDef)definition.ast)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isDynamicClass(ClassDef def) {
        String docString = NodeUtils.getNodeDocString((SimpleNode)def);
        return docString != null && docString.indexOf("@DynamicAttrs") != -1;
    }

    protected Found makeFound(IToken token) {
        return new Found(token, token, this.scope.getCurrScopeId(), this.scope.getCurrScopeItems());
    }

    protected IToken findNameTok(IToken token, String tokToCheck) {
        if (token instanceof SourceToken) {
            SourceToken s = (SourceToken)token;
            SimpleNode ast = s.getAst();
            String searchFor = FullRepIterable.getLastPart((String)tokToCheck);
            while (ast instanceof Attribute) {
                Attribute a = (Attribute)ast;
                if (((NameTok)a.attr).id.equals(searchFor)) {
                    return new SourceToken((SimpleNode)a.attr, searchFor, "", "", token.getParentPackage());
                }
                if (a.value.toString().equals(searchFor)) {
                    return new SourceToken((SimpleNode)a.value, searchFor, "", "", token.getParentPackage());
                }
                ast = a.value;
            }
        }
        return token;
    }

    protected void onAddToProbablyNotDefined(IToken token, Found foundForProbablyNotDefined) {
    }

    protected void onNotDefinedFoundLater(Found foundInProbablyNotDefined, Found laterFound) {
    }

    protected void onAfterAddToNamesToIgnore(ScopeItems currScopeItems, org.python.pydev.core.Tuple<IToken, Found> tup) {
    }

    protected void onFoundUnresolvedImportPart(IToken token, String rep, Found foundAs) {
    }

    public void onImportInfoSetOnFound(Found found) {
    }
}

