/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generateproperties;

import java.util.LinkedList;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.refactoring.codegenerator.generateproperties.edit.DeleteMethodEdit;
import org.python.pydev.refactoring.codegenerator.generateproperties.edit.GetterMethodEdit;
import org.python.pydev.refactoring.codegenerator.generateproperties.edit.PropertyEdit;
import org.python.pydev.refactoring.codegenerator.generateproperties.edit.SetterMethodEdit;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.GeneratePropertiesRequest;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.SelectionState;
import org.python.pydev.refactoring.core.base.AbstractFileChangeProcessor;
import org.python.pydev.refactoring.core.base.RefactoringInfo;
import org.python.pydev.refactoring.core.edit.AbstractTextEdit;
import org.python.pydev.refactoring.core.request.IRequestProcessor;
import org.python.pydev.refactoring.messages.Messages;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratePropertiesChangeProcessor
extends AbstractFileChangeProcessor<GeneratePropertiesRequest> {
    public GeneratePropertiesChangeProcessor(String name, RefactoringInfo info, IRequestProcessor<GeneratePropertiesRequest> requestProvider) {
        super(name, info, requestProvider);
    }

    @Override
    protected void processEdit() throws MisconfigurationException {
        LinkedList<AbstractTextEdit> getters = new LinkedList<AbstractTextEdit>();
        LinkedList<AbstractTextEdit> setters = new LinkedList<AbstractTextEdit>();
        LinkedList<AbstractTextEdit> deleters = new LinkedList<AbstractTextEdit>();
        for (GeneratePropertiesRequest req : this.requestProcessor.getRefactoringRequests()) {
            SelectionState state = req.getSelectionState();
            if (state.isGetter()) {
                getters.add(new GetterMethodEdit(req));
            }
            if (state.isSetter()) {
                setters.add(new SetterMethodEdit(req));
            }
            if (!state.isDelete()) continue;
            deleters.add(new DeleteMethodEdit(req));
        }
        LinkedList<AbstractTextEdit> propertyEdits = new LinkedList<AbstractTextEdit>();
        for (GeneratePropertiesRequest req : this.requestProcessor.getRefactoringRequests()) {
            propertyEdits.add(new PropertyEdit(req));
        }
        this.registerEdit(getters, Messages.generatePropertiesGetter);
        this.registerEdit(setters, Messages.generatePropertiesSetter);
        this.registerEdit(deleters, Messages.generatePropertiesDelete);
        this.registerEdit(propertyEdits, Messages.generatePropertiesProperty);
    }
}

