/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;

public class StringSubstitution {
    private Map<String, String> variableSubstitution = null;

    public StringSubstitution(IPythonNature nature) {
        if (nature != null) {
            try {
                IPythonPathNature pythonPathNature = nature.getPythonPathNature();
                this.variableSubstitution = pythonPathNature.getVariableSubstitution();
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    public String performStringSubstitution(String expression, boolean reportUndefinedVariables) throws CoreException {
        VariablesPlugin plugin = VariablesPlugin.getDefault();
        expression = this.performPythonpathStringSubstitution(expression);
        expression = plugin.getStringVariableManager().performStringSubstitution(expression, reportUndefinedVariables);
        return expression;
    }

    public String performPythonpathStringSubstitution(String expression) throws CoreException {
        if (this.variableSubstitution != null && this.variableSubstitution.size() > 0) {
            expression = new StringSubstitutionEngine().performStringSubstitution(expression, true, this.variableSubstitution);
        }
        return expression;
    }

    public String performStringSubstitution(String expression) throws CoreException {
        return this.performStringSubstitution(expression, true);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StringSubstitutionEngine {
        private static final String VARIABLE_START = "${";
        private static final char VARIABLE_END = '}';
        private static final char VARIABLE_ARG = ':';
        private static final int SCAN_FOR_START = 0;
        private static final int SCAN_FOR_END = 1;
        private StringBuffer fResult;
        private boolean fSubs;
        private Stack fStack;

        StringSubstitutionEngine() {
        }

        public String performStringSubstitution(String expression, boolean resolveVariables, Map<String, String> variableSubstitution) throws CoreException {
            this.substitute(expression, resolveVariables, variableSubstitution);
            ArrayList<HashSet> resolvedVariableSets = new ArrayList<HashSet>();
            while (this.fSubs) {
                HashSet resolved = this.substitute(this.fResult.toString(), true, variableSubstitution);
                int i = resolvedVariableSets.size() - 1;
                while (i >= 0) {
                    HashSet prevSet = (HashSet)resolvedVariableSets.get(i);
                    if (prevSet.equals(resolved)) {
                        HashSet conflictingSet = new HashSet();
                        while (i < resolvedVariableSets.size()) {
                            conflictingSet.addAll((HashSet)resolvedVariableSets.get(i));
                            ++i;
                        }
                        StringBuffer problemVariableList = new StringBuffer();
                        Iterator it = conflictingSet.iterator();
                        while (it.hasNext()) {
                            problemVariableList.append(it.next().toString());
                            problemVariableList.append(", ");
                        }
                        problemVariableList.setLength(problemVariableList.length() - 2);
                        throw new CoreException((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 130, StringUtils.format("Cycle error on:", problemVariableList.toString()), null));
                    }
                    --i;
                }
                resolvedVariableSets.add(resolved);
            }
            return this.fResult.toString();
        }

        private HashSet substitute(String expression, boolean resolveVariables, Map<String, String> variableSubstitution) throws CoreException {
            this.fResult = new StringBuffer(expression.length());
            this.fStack = new Stack();
            this.fSubs = false;
            HashSet<String> resolvedVariables = new HashSet<String>();
            int pos = 0;
            int state = 0;
            while (pos < expression.length()) {
                switch (state) {
                    case 0: {
                        int start = expression.indexOf(VARIABLE_START, pos);
                        if (start >= 0) {
                            int length = start - pos;
                            if (length > 0) {
                                this.fResult.append(expression.substring(pos, start));
                            }
                            pos = start + 2;
                            state = 1;
                            this.fStack.push(new VariableReference());
                            break;
                        }
                        this.fResult.append(expression.substring(pos));
                        pos = expression.length();
                        break;
                    }
                    case 1: {
                        VariableReference tos;
                        int start = expression.indexOf(VARIABLE_START, pos);
                        int end = expression.indexOf(125, pos);
                        if (end < 0) {
                            tos = (VariableReference)this.fStack.peek();
                            tos.append(expression.substring(pos));
                            pos = expression.length();
                            break;
                        }
                        if (start >= 0 && start < end) {
                            int length = start - pos;
                            if (length > 0) {
                                VariableReference tos2 = (VariableReference)this.fStack.peek();
                                tos2.append(expression.substring(pos, start));
                            }
                            pos = start + 2;
                            this.fStack.push(new VariableReference());
                            break;
                        }
                        tos = (VariableReference)this.fStack.pop();
                        String substring = expression.substring(pos, end);
                        tos.append(substring);
                        resolvedVariables.add(substring);
                        pos = end + 1;
                        String value = this.resolve(tos, resolveVariables, variableSubstitution);
                        if (value == null) {
                            value = "";
                        }
                        if (this.fStack.isEmpty()) {
                            this.fResult.append(value);
                            state = 0;
                            break;
                        }
                        tos = (VariableReference)this.fStack.peek();
                        tos.append(value);
                    }
                }
            }
            while (!this.fStack.isEmpty()) {
                VariableReference tos = (VariableReference)this.fStack.pop();
                if (this.fStack.isEmpty()) {
                    this.fResult.append(VARIABLE_START);
                    this.fResult.append(tos.getText());
                    continue;
                }
                VariableReference var = (VariableReference)this.fStack.peek();
                var.append(VARIABLE_START);
                var.append(tos.getText());
            }
            return resolvedVariables;
        }

        private String resolve(VariableReference var, boolean resolveVariables, Map<String, String> variableSubstitution) throws CoreException {
            String valueVariable;
            String text = var.getText();
            int pos = text.indexOf(58);
            String name = null;
            String arg = null;
            if (pos > 0) {
                name = text.substring(0, pos);
                if (++pos < text.length()) {
                    arg = text.substring(pos);
                }
            } else {
                name = text;
            }
            if ((valueVariable = variableSubstitution.get(name)) == null) {
                return this.getOriginalVarText(var);
            }
            if (arg == null) {
                if (resolveVariables) {
                    this.fSubs = true;
                    return valueVariable;
                }
                return this.getOriginalVarText(var);
            }
            throw new CoreException((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 120, new StringBuffer("Error substituting: ").append(name).append(" var: ").append(valueVariable).toString(), null));
        }

        private String getOriginalVarText(VariableReference var) {
            StringBuffer res = new StringBuffer(var.getText());
            res.insert(0, VARIABLE_START);
            res.append('}');
            return res.toString();
        }

        class VariableReference {
            private StringBuffer fText = new StringBuffer();

            public void append(String text) {
                this.fText.append(text);
            }

            public String getText() {
                return this.fText.toString();
            }
        }
    }
}

