/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.ui.findreplace;

import com.python.pydev.refactoring.ui.findreplace.FindInOpenDocuments;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.IOfflineActionWithParameters;
import org.python.pydev.editor.PyEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySearchInOpenDocumentsAction
extends Action
implements IOfflineActionWithParameters {
    private List<String> parameters;
    private PyEdit edit;

    public PySearchInOpenDocumentsAction(PyEdit edit) {
        this.edit = edit;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void run() {
        String searchText;
        IDialogSettings settings = TextEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings s = settings.getSection("org.eclipse.ui.texteditor.FindReplaceDialog");
        boolean caseSensitive = false;
        boolean wholeWord = false;
        boolean isRegEx = false;
        if (s != null) {
            caseSensitive = s.getBoolean("casesensitive");
            wholeWord = s.getBoolean("wholeword");
            isRegEx = s.getBoolean("isRegEx");
        }
        if ((searchText = StringUtils.join((String)" ", this.parameters)).length() == 0) {
            PySelection ps = new PySelection((ITextEditor)this.edit);
            searchText = ps.getSelectedText();
        }
        IStatusLineManager statusLineManager = this.edit.getStatusLineManager();
        if (searchText.length() == 0) {
            statusLineManager.setMessage("Unable to search in open documents (no text to search).");
            return;
        }
        if (wholeWord && !isRegEx && this.isWord(searchText)) {
            isRegEx = true;
            searchText = new StringBuffer("\\b").append(searchText).append("\\b").toString();
        }
        FindInOpenDocuments.findInOpenDocuments(searchText, caseSensitive, wholeWord, isRegEx, statusLineManager);
    }

    private boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

