/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AttrInfo;
import com.python.pydev.analysis.additionalinfo.ClassInfo;
import com.python.pydev.analysis.additionalinfo.FuncInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.additionalinfo.IOUtils;
import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.DefinitionsASTIteratorVisitor;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdditionalInterpreterInfo {
    public static final int NUMBER_OF_INITIALS_TO_INDEX = 3;
    private static final boolean DEBUG_ADDITIONAL_INFO = false;
    public static final int TOP_LEVEL = 1;
    public static final int INNER = 2;
    protected TreeMap<String, List<IInfo>> topLevelInitialsToInfo = new TreeMap();
    protected TreeMap<String, List<IInfo>> innerInitialsToInfo = new TreeMap();
    protected Object lock = new Object();
    private Filter equalsFilter = new Filter(){

        public boolean doCompare(String qualifier, IInfo info) {
            return this.doCompare(qualifier, info.getName());
        }

        public boolean doCompare(String qualifier, String infoName) {
            return infoName.equals(qualifier);
        }
    };
    private Filter startingWithFilter = new Filter(){

        public boolean doCompare(String lowerCaseQual, IInfo info) {
            return this.doCompare(lowerCaseQual, info.getName());
        }

        public boolean doCompare(String qualifier, String infoName) {
            return infoName.toLowerCase().startsWith(qualifier);
        }
    };
    private static final int version = 2;

    protected abstract File getPersistingLocation() throws MisconfigurationException;

    protected abstract File getPersistingFolder() throws MisconfigurationException;

    protected abstract void setAsDefaultInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllInfo() {
        Object object = this.lock;
        synchronized (object) {
            if (this.topLevelInitialsToInfo != null) {
                this.topLevelInitialsToInfo.clear();
            }
            if (this.innerInitialsToInfo != null) {
                this.innerInitialsToInfo.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(IInfo info, boolean generateDelta, int doOn) {
        Object object = this.lock;
        synchronized (object) {
            TreeMap<String, List<IInfo>> initialsToInfo;
            String name = info.getName();
            String initials = this.getInitials(name);
            if (doOn == 1) {
                if (info.getPath() != null && info.getPath().length() > 0) {
                    throw new RuntimeException(new StringBuffer("Error: the info being added is added as an 'top level' info, but has path. Info:").append(info).toString());
                }
                initialsToInfo = this.topLevelInitialsToInfo;
            } else if (doOn == 2) {
                if (info.getPath() == null || info.getPath().length() == 0) {
                    throw new RuntimeException(new StringBuffer("Error: the info being added is added as an 'inner' info, but does not have a path. Info: ").append(info).toString());
                }
                initialsToInfo = this.innerInitialsToInfo;
            } else {
                throw new RuntimeException(new StringBuffer("List to add is invalid: ").append(doOn).toString());
            }
            List<IInfo> listForInitials = this.getAndCreateListForInitials(initials, initialsToInfo);
            listForInitials.add(info);
        }
    }

    protected String getInitials(String name) {
        if (name.length() < 3) {
            return name;
        }
        return name.substring(0, 3).toLowerCase();
    }

    protected List<IInfo> getAndCreateListForInitials(String initials, TreeMap<String, List<IInfo>> initialsToInfo) {
        List<IInfo> lInfo = initialsToInfo.get(initials);
        if (lInfo == null) {
            lInfo = new ArrayList<IInfo>();
            initialsToInfo.put(initials, lInfo);
        }
        return lInfo;
    }

    protected void addMethod(FunctionDef def, String moduleDeclared, boolean generateDelta, int doOn, String path) {
        FuncInfo info2 = FuncInfo.fromFunctionDef(def, moduleDeclared, path);
        this.add(info2, generateDelta, doOn);
    }

    protected void addClass(ClassDef def, String moduleDeclared, boolean generateDelta, int doOn, String path) {
        ClassInfo info = ClassInfo.fromClassDef(def, moduleDeclared, path);
        this.add(info, generateDelta, doOn);
    }

    protected void addAttribute(String def, String moduleDeclared, boolean generateDelta, int doOn, String path) {
        AttrInfo info = AttrInfo.fromAssign(def, moduleDeclared, path);
        this.add(info, generateDelta, doOn);
    }

    protected void addClassOrFunc(SimpleNode classOrFunc, String moduleDeclared, boolean generateDelta, int doOn, String path) {
        if (classOrFunc instanceof ClassDef) {
            this.addClass((ClassDef)classOrFunc, moduleDeclared, generateDelta, doOn, path);
        } else {
            this.addMethod((FunctionDef)classOrFunc, moduleDeclared, generateDelta, doOn, path);
        }
    }

    private void addAssignTargets(ASTEntry entry, String moduleName, boolean generateDelta, int doOn, String path, boolean lastIsMethod) {
        String rep = NodeUtils.getFullRepresentationString((SimpleNode)entry.node);
        if (lastIsMethod) {
            List parts = StringUtils.dotSplit((String)rep);
            if (parts.size() >= 2 && ((String)parts.get(0)).equals("self")) {
                rep = (String)parts.get(1);
                this.addAttribute(rep, moduleName, generateDelta, doOn, path);
            }
        } else {
            this.addAttribute(FullRepIterable.getFirstPart((String)rep), moduleName, generateDelta, doOn, path);
        }
    }

    public void addSourceModuleInfo(SourceModule m, IPythonNature nature, boolean generateDelta) {
        this.addAstInfo(m.getAst(), m.getName(), nature, generateDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAstInfo(SimpleNode node, String moduleName, IPythonNature nature, boolean generateDelta) {
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            Log.toLogFile((Object)this, (String)new StringBuffer("Adding ast info to: ").append(moduleName).toString());
        }
        if (node == null || moduleName == null) {
            return;
        }
        try {
            Iterator<ASTEntry> entries = AbstractAdditionalInterpreterInfo.getInnerEntriesForAST(node);
            FastStack tempStack = new FastStack();
            Object object = this.lock;
            synchronized (object) {
                while (entries.hasNext()) {
                    Tuple<String, Boolean> pathToRoot;
                    ASTEntry entry = entries.next();
                    if (entry.parent == null) {
                        if (entry.node instanceof ClassDef || entry.node instanceof FunctionDef) {
                            this.addClassOrFunc(entry.node, moduleName, generateDelta, 1, null);
                            continue;
                        }
                        this.addAssignTargets(entry, moduleName, generateDelta, 1, null, false);
                        continue;
                    }
                    if (entry.node instanceof ClassDef || entry.node instanceof FunctionDef) {
                        pathToRoot = this.getPathToRoot(entry, false, false, (FastStack<SimpleNode>)tempStack);
                        if (pathToRoot == null || pathToRoot.o1 == null || ((String)pathToRoot.o1).length() <= 0) continue;
                        this.addClassOrFunc(entry.node, moduleName, generateDelta, 2, (String)pathToRoot.o1);
                        continue;
                    }
                    pathToRoot = this.getPathToRoot(entry, true, false, (FastStack<SimpleNode>)tempStack);
                    if (pathToRoot == null || pathToRoot.o1 == null || ((String)pathToRoot.o1).length() <= 0) continue;
                    this.addAssignTargets(entry, moduleName, generateDelta, 2, (String)pathToRoot.o1, (Boolean)pathToRoot.o2);
                }
            }
        }
        catch (Exception e) {
            PydevPlugin.log((Throwable)e);
        }
    }

    public static Iterator<ASTEntry> getInnerEntriesForAST(SimpleNode node) throws Exception {
        DefinitionsASTIteratorVisitor visitor = new DefinitionsASTIteratorVisitor();
        node.accept((VisitorIF)visitor);
        Iterator entries = visitor.getOutline();
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllModulesWithTokens() {
        HashSet<String> ret = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            List<IInfo> value;
            Set<Map.Entry<String, List<IInfo>>> entrySet = this.topLevelInitialsToInfo.entrySet();
            for (Map.Entry<String, List<IInfo>> entry : entrySet) {
                value = entry.getValue();
                for (IInfo info : value) {
                    ret.add(info.getDeclaringModuleName());
                }
            }
            entrySet = this.innerInitialsToInfo.entrySet();
            for (Map.Entry<String, List<IInfo>> entry : entrySet) {
                value = entry.getValue();
                for (IInfo info : value) {
                    ret.add(info.getDeclaringModuleName());
                }
            }
        }
        return ret;
    }

    private Tuple<String, Boolean> getPathToRoot(ASTEntry entry, boolean lastMayBeMethod, boolean acceptAny, FastStack<SimpleNode> tempStack) {
        if (entry.parent == null) {
            return null;
        }
        tempStack.clear();
        boolean lastIsMethod = false;
        while (entry.parent != null) {
            if (entry.parent.node instanceof ClassDef) {
                tempStack.push((Object)entry.parent.node);
            } else if (entry.parent.node instanceof FunctionDef) {
                if (!acceptAny) {
                    if (lastIsMethod) {
                        return null;
                    }
                    if (!lastMayBeMethod) {
                        return null;
                    }
                    if (tempStack.size() != 0) {
                        return null;
                    }
                }
                tempStack.push((Object)entry.parent.node);
                lastIsMethod = true;
            } else {
                return null;
            }
            entry = entry.parent;
        }
        FastStringBuffer buf = new FastStringBuffer();
        while (tempStack.size() > 0) {
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(NodeUtils.getRepresentationString((SimpleNode)((SimpleNode)tempStack.pop())));
        }
        return new Tuple((Object)buf.toString(), (Object)Autobox.valueOf((boolean)lastIsMethod));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInfoFromModule(String moduleName, boolean generateDelta) {
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            Log.toLogFile((Object)this, (String)new StringBuffer("Removing ast info from: ").append(moduleName).toString());
        }
        Object object = this.lock;
        synchronized (object) {
            this.removeInfoFromMap(moduleName, this.topLevelInitialsToInfo);
            this.removeInfoFromMap(moduleName, this.innerInitialsToInfo);
        }
    }

    private void removeInfoFromMap(String moduleName, TreeMap<String, List<IInfo>> initialsToInfo) {
        Iterator<List<IInfo>> itListOfInfo = initialsToInfo.values().iterator();
        while (itListOfInfo.hasNext()) {
            Iterator<IInfo> it = itListOfInfo.next().iterator();
            while (it.hasNext()) {
                IInfo info = it.next();
                if (info == null || info.getDeclaringModuleName() == null || !info.getDeclaringModuleName().equals(moduleName)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IInfo> getTokensStartingWith(String qualifier, int getWhat) {
        Object object = this.lock;
        synchronized (object) {
            return this.getWithFilter(qualifier, getWhat, this.startingWithFilter, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IInfo> getTokensEqualTo(String qualifier, int getWhat) {
        Object object = this.lock;
        synchronized (object) {
            return this.getWithFilter(qualifier, getWhat, this.equalsFilter, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IInfo> getWithFilter(String qualifier, int getWhat, Filter filter, boolean useLowerCaseQual) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<IInfo> toks = new ArrayList<IInfo>();
            if ((getWhat & 1) != 0) {
                this.getWithFilter(qualifier, this.topLevelInitialsToInfo, toks, filter, useLowerCaseQual);
            }
            if ((getWhat & 2) != 0) {
                this.getWithFilter(qualifier, this.innerInitialsToInfo, toks, filter, useLowerCaseQual);
            }
            return toks;
        }
    }

    protected void getWithFilter(String qualifier, TreeMap<String, List<IInfo>> initialsToInfo, List<IInfo> toks, Filter filter, boolean useLowerCaseQual) {
        String initials = this.getInitials(qualifier);
        String qualToCompare = qualifier;
        if (useLowerCaseQual) {
            qualToCompare = qualifier.toLowerCase();
        }
        SortedMap<String, List<IInfo>> subMap = initialsToInfo.subMap(initials, new StringBuffer(String.valueOf(initials)).append("z").toString());
        for (List<IInfo> listForInitials : subMap.values()) {
            for (IInfo info : listForInitials) {
                if (!filter.doCompare(qualToCompare, info)) continue;
                toks.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IInfo> getAllTokens() {
        Object object = this.lock;
        synchronized (object) {
            Collection<List<IInfo>> lInfo = this.topLevelInitialsToInfo.values();
            ArrayList<IInfo> toks = new ArrayList<IInfo>();
            for (List<IInfo> list : lInfo) {
                for (IInfo info : list) {
                    toks.add(info);
                }
            }
            lInfo = this.innerInitialsToInfo.values();
            for (List<IInfo> list : lInfo) {
                for (IInfo info : list) {
                    toks.add(info);
                }
            }
            return toks;
        }
    }

    public void save() {
        File persistingLocation;
        try {
            persistingLocation = this.getPersistingLocation();
        }
        catch (MisconfigurationException e) {
            PydevPlugin.log((String)"Error. Unable to get persisting location for additional interprer info. Configuration may be corrupted.", (Throwable)e);
            return;
        }
        this.saveTo(persistingLocation);
    }

    public static void saveAdditionalSystemInfo(IInterpreterManager manager, String interpreter) {
        try {
            AbstractAdditionalInterpreterInfo info = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, interpreter);
            info.save();
        }
        catch (MisconfigurationException e) {
            PydevPlugin.log((Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTo(File pathToSave) {
        Object object = this.lock;
        synchronized (object) {
            REF.writeToFile((Object)this.getInfoToSave(), (File)pathToSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getInfoToSave() {
        Object object = this.lock;
        synchronized (object) {
            return new Tuple3(this.topLevelInitialsToInfo, this.innerInitialsToInfo, (Object)Autobox.valueOf((int)2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean load() {
        Object object = this.lock;
        synchronized (object) {
            File file;
            try {
                file = this.getPersistingLocation();
            }
            catch (MisconfigurationException e) {
                PydevPlugin.log((String)"Unable to restore previous info... (persisting location not available).", (Throwable)e);
                return false;
            }
            if (!file.exists()) return false;
            if (!file.isFile()) return false;
            try {
                this.restoreSavedInfo(IOUtils.readFromFile(file));
                this.setAsDefaultInfo();
                return true;
            }
            catch (Throwable e) {
                PydevPlugin.log((String)"Unable to restore previous info... new info should be restored in a thread.", (Throwable)e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreSavedInfo(Object o) throws MisconfigurationException {
        Object object = this.lock;
        synchronized (object) {
            Tuple3 readFromFile = (Tuple3)o;
            this.topLevelInitialsToInfo = (TreeMap)readFromFile.o1;
            this.innerInitialsToInfo = (TreeMap)readFromFile.o2;
            if (2 != (Integer)readFromFile.o3) {
                throw new RuntimeException("I/O version doesn't match. Rebuilding internal info.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            FastStringBuffer buffer = new FastStringBuffer();
            buffer.append("AdditionalInfo{");
            buffer.append("topLevel=[");
            this.entrySetToString(buffer, this.topLevelInitialsToInfo.entrySet());
            buffer.append("]\n");
            buffer.append("inner=[");
            this.entrySetToString(buffer, this.innerInitialsToInfo.entrySet());
            buffer.append("]");
            buffer.append("}");
            return buffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entrySetToString(FastStringBuffer buffer, Set<Map.Entry<String, List<IInfo>>> name) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, List<IInfo>> entry : name) {
                List<IInfo> value = entry.getValue();
                for (IInfo info : value) {
                    buffer.append(info.toString());
                    buffer.append("\n");
                }
            }
        }
    }

    public static interface Filter {
        public boolean doCompare(String var1, IInfo var2);

        public boolean doCompare(String var1, String var2);
    }
}

