/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.python.pydev.core.log.Log;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.editorinput.PydevZipFileEditorInput;
import org.python.pydev.editorinput.PydevZipFileStorage;
import org.python.pydev.navigator.PythonpathTreeNode;
import org.python.pydev.navigator.PythonpathZipChildTreeNode;
import org.python.pydev.navigator.actions.PyOpenPythonFileAction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyOpenExternalAction
extends PyOpenPythonFileAction {
    private IWorkbenchPage page;

    public PyOpenExternalAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
        super(page, selectionProvider);
        this.page = page;
        this.setText("Open with System Editor");
    }

    @Override
    protected void openFiles(PythonpathTreeNode[] pythonPathFilesSelected) {
        PythonpathTreeNode[] pythonpathTreeNodeArray = pythonPathFilesSelected;
        int n = pythonPathFilesSelected.length;
        int n2 = 0;
        while (n2 < n) {
            PythonpathTreeNode n3 = pythonpathTreeNodeArray[n2];
            try {
                IDE.openEditor((IWorkbenchPage)this.page, (IEditorInput)new PydevFileEditorInput(n3.file), (String)"org.eclipse.ui.systemExternalEditor");
            }
            catch (PartInitException e) {
                Log.log((Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    protected void openFiles(PythonpathZipChildTreeNode[] pythonPathFilesSelected) {
        PythonpathZipChildTreeNode[] pythonpathZipChildTreeNodeArray = pythonPathFilesSelected;
        int n = pythonPathFilesSelected.length;
        int n2 = 0;
        while (n2 < n) {
            PythonpathZipChildTreeNode n3 = pythonpathZipChildTreeNodeArray[n2];
            try {
                PydevZipFileStorage storage = new PydevZipFileStorage(n3.zipStructure.file, n3.zipPath);
                PydevZipFileEditorInput input = new PydevZipFileEditorInput(storage);
                IDE.openEditor((IWorkbenchPage)this.page, (IEditorInput)input, (String)"org.eclipse.ui.systemExternalEditor");
            }
            catch (PartInitException e) {
                Log.log((Throwable)e);
            }
            ++n2;
        }
    }

    @Override
    protected void openFiles(List<IFile> filesSelected) {
        for (IFile f : filesSelected) {
            try {
                IDE.openEditor((IWorkbenchPage)this.page, (IFile)f, (String)"org.eclipse.ui.systemExternalEditor");
            }
            catch (PartInitException e) {
                Log.log((Throwable)e);
            }
        }
    }

    @Override
    public boolean isEnabledForSelectionWithoutContainers() {
        this.fillSelections();
        return this.pythonPathFilesSelected.size() > 0;
    }
}

