/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.docutils.WrapAndCaseUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.utils.LabelFieldEditor;

public class PyCodeCompletionPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String USE_CODECOMPLETION = "USE_CODECOMPLETION";
    public static final boolean DEFAULT_USE_CODECOMPLETION = true;
    public static final String ATTEMPTS_CODECOMPLETION = "ATTEMPTS_CODECOMPLETION";
    public static final int DEFAULT_ATTEMPTS_CODECOMPLETION = 20;
    public static final String AUTOCOMPLETE_ON_DOT = "AUTOCOMPLETE_ON_DOT";
    public static final boolean DEFAULT_AUTOCOMPLETE_ON_DOT = true;
    public static final String AUTOCOMPLETE_ON_ALL_ASCII_CHARS = "AUTOCOMPLETE_ON_ALL_ASCII_CHARS";
    public static final boolean DEFAULT_AUTOCOMPLETE_ON_ALL_ASCII_CHARS = false;
    public static final String USE_AUTOCOMPLETE = "USE_AUTOCOMPLETE";
    public static final boolean DEFAULT_USE_AUTOCOMPLETE = true;
    public static final String AUTOCOMPLETE_DELAY = "AUTOCOMPLETE_DELAY";
    public static final int DEFAULT_AUTOCOMPLETE_DELAY = 0;
    public static final String AUTOCOMPLETE_ON_PAR = "AUTOCOMPLETE_ON_PAR";
    public static final boolean DEFAULT_AUTOCOMPLETE_ON_PAR = false;
    public static final String APPLY_COMPLETION_ON_DOT = "APPLY_COMPLETION_ON_DOT";
    public static final boolean DEFAULT_APPLY_COMPLETION_ON_DOT = false;
    public static final String APPLY_COMPLETION_ON_LPAREN = "APPLY_COMPLETION_ON_LPAREN";
    public static final boolean DEFAULT_APPLY_COMPLETION_ON_LPAREN = false;
    public static final String APPLY_COMPLETION_ON_RPAREN = "APPLY_COMPLETION_ON_RPAREN";
    public static final boolean DEFAULT_APPLY_COMPLETION_ON_RPAREN = false;
    public static final String ARGUMENTS_DEEP_ANALYSIS_N_CHARS = "DEEP_ANALYSIS_N_CHARS";
    public static final int DEFAULT_ARGUMENTS_DEEP_ANALYSIS_N_CHARS = 1;
    public static ICallback<Preferences, Object> getPreferencesForTests;

    public PyCodeCompletionPreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new IntegerFieldEditor(ATTEMPTS_CODECOMPLETION, "Timeout to connect to shell (secs).", p));
        this.addField((FieldEditor)new IntegerFieldEditor(AUTOCOMPLETE_DELAY, "Autocompletion delay: ", p));
        String tooltip = WrapAndCaseUtils.wrap((String)"Determines the number of chars in the qualifier request for which constructs such as 'from xxx import yyy' should be analyzed to get its actual token and if it maps to a method, its paramaters will be added in the completion.", (int)80);
        IntegerFieldEditor deepAnalysisFieldEditor = new IntegerFieldEditor(ARGUMENTS_DEEP_ANALYSIS_N_CHARS, "Minimum number of chars in qualifier for\ndeep analysis for parameters in 'from' imports:", p);
        this.addField((FieldEditor)deepAnalysisFieldEditor);
        deepAnalysisFieldEditor.getLabelControl(p).setToolTipText(tooltip);
        deepAnalysisFieldEditor.getTextControl(p).setToolTipText(tooltip);
        this.addField((FieldEditor)new BooleanFieldEditor(USE_CODECOMPLETION, "Use code completion?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTOCOMPLETE_ON_DOT, "Request completion on '.'?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTOCOMPLETE_ON_PAR, "Request completion on '('?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(AUTOCOMPLETE_ON_ALL_ASCII_CHARS, "Request completion on all letter chars and '_'?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(APPLY_COMPLETION_ON_DOT, "Apply completion on '.'?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(APPLY_COMPLETION_ON_LPAREN, "Apply completion on '('?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(APPLY_COMPLETION_ON_RPAREN, "Apply completion on ')'?", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_a", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_b", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_0", "Note: ENTER will always apply the completion.", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_0a", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_0b", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_0c", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_1", "Note 2: Shift + ENTER can be used if you want a new line\nwithout applying a completion.", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_1a", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_1b", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_1c", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_2", "Note 3: Ctrl + ENTER can be used as a way to apply the completion\nerasing the next chars from the current token.", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_2a", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_2b", "", p));
        this.addField(new LabelFieldEditor("LABEL_FIELD_EDITOR_NEW_LINE_ALWAYS_THERE_2c", "", p));
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean useCodeCompletion() {
        return PyCodeCompletionPreferencesPage.getPreferences().getBoolean(USE_CODECOMPLETION);
    }

    public static int getNumberOfConnectionAttempts() {
        try {
            Preferences preferences = PyCodeCompletionPreferencesPage.getPreferences();
            int ret = preferences.getInt(ATTEMPTS_CODECOMPLETION);
            if (ret < 5) {
                ret = 5;
            }
            return ret;
        }
        catch (NullPointerException nullPointerException) {
            return 20;
        }
    }

    public static boolean isToAutocompleteOnDot() {
        return PyCodeCompletionPreferencesPage.getPreferences().getBoolean(AUTOCOMPLETE_ON_DOT);
    }

    public static boolean isToAutocompleteOnPar() {
        return PyCodeCompletionPreferencesPage.getPreferences().getBoolean(AUTOCOMPLETE_ON_PAR);
    }

    public static boolean useAutocomplete() {
        return PyCodeCompletionPreferencesPage.getPreferences().getBoolean(USE_AUTOCOMPLETE);
    }

    public static boolean useAutocompleteOnAllAsciiChars() {
        return PyCodeCompletionPreferencesPage.getPreferences().getBoolean(AUTOCOMPLETE_ON_ALL_ASCII_CHARS);
    }

    public static int getAutocompleteDelay() {
        return PyCodeCompletionPreferencesPage.getPreferences().getInt(AUTOCOMPLETE_DELAY);
    }

    public static int getArgumentsDeepAnalysisNChars() {
        if (PydevPlugin.getDefault() == null) {
            return 0;
        }
        return PyCodeCompletionPreferencesPage.getPreferences().getInt(ARGUMENTS_DEEP_ANALYSIS_N_CHARS);
    }

    public static boolean applyCompletionOnDot() {
        return PyCodeCompletionPreferencesPage.getPreferences().getBoolean(APPLY_COMPLETION_ON_DOT);
    }

    public static boolean applyCompletionOnLParen() {
        return PyCodeCompletionPreferencesPage.getPreferences().getBoolean(APPLY_COMPLETION_ON_LPAREN);
    }

    public static boolean applyCompletionOnRParen() {
        return PyCodeCompletionPreferencesPage.getPreferences().getBoolean(APPLY_COMPLETION_ON_RPAREN);
    }

    private static Preferences getPreferences() {
        PydevPlugin plugin = PydevPlugin.getDefault();
        if (plugin == null) {
            return (Preferences)getPreferencesForTests.call(null);
        }
        return plugin.getPluginPreferences();
    }
}

