/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyWordRule;
import org.python.pydev.ui.ColorCache;

public class PyCodeScanner
extends RuleBasedScanner {
    public static final String[] KEYWORDS = new String[]{"and", "as", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "exec", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "nonlocal", "not", "or", "pass", "print", "raise", "return", "self", "try", "while", "with", "yield", "False", "None", "True"};
    private ColorCache colorCache;
    private IToken keywordToken;
    private IToken selfToken;
    private IToken defaultToken;
    private IToken decoratorToken;
    private IToken numberToken;
    private IToken classNameToken;
    private IToken funcNameToken;

    public PyCodeScanner(ColorCache colorCache) {
        this.colorCache = colorCache;
        this.setupRules();
    }

    public void updateColors() {
        this.setupRules();
    }

    private void setupRules() {
        IPreferenceStore preferences = this.colorCache.getPreferences();
        this.keywordToken = new Token((Object)new TextAttribute(this.colorCache.getNamedColor("KEYWORD_COLOR"), null, preferences.getInt("KEYWORD_STYLE")));
        this.selfToken = new Token((Object)new TextAttribute(this.colorCache.getNamedColor("SELF_COLOR"), null, preferences.getInt("SELF_STYLE")));
        this.defaultToken = new Token((Object)new TextAttribute(this.colorCache.getNamedColor("CODE_COLOR"), null, preferences.getInt("CODE_STYLE")));
        this.decoratorToken = new Token((Object)new TextAttribute(this.colorCache.getNamedColor("DECORATOR_COLOR"), null, preferences.getInt("DECORATOR_STYLE")));
        this.numberToken = new Token((Object)new TextAttribute(this.colorCache.getNamedColor("NUMBER_COLOR"), null, preferences.getInt("NUMBER_STYLE")));
        this.classNameToken = new Token((Object)new TextAttribute(this.colorCache.getNamedColor("CLASS_NAME_COLOR"), null, preferences.getInt("CLASS_NAME_STYLE")));
        this.funcNameToken = new Token((Object)new TextAttribute(this.colorCache.getNamedColor("FUNC_NAME_COLOR"), null, preferences.getInt("FUNC_NAME_STYLE")));
        this.setDefaultReturnToken(this.defaultToken);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new GreatWhite()));
        HashMap<String, IToken> defaults = new HashMap<String, IToken>();
        defaults.put("self", this.selfToken);
        PyWordRule wordRule = new PyWordRule(new GreatKeywordDetector(), this.defaultToken, this.classNameToken, this.funcNameToken);
        String[] stringArray = KEYWORDS;
        int n = KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            IToken token = (IToken)defaults.get(keyword);
            if (token == null) {
                token = this.keywordToken;
            }
            wordRule.addWord(keyword, token);
            ++n2;
        }
        rules.add(wordRule);
        rules.add(new WordRule((IWordDetector)new DecoratorDetector(), this.decoratorToken));
        rules.add(new WordRule((IWordDetector)new NumberDetector(), this.numberToken));
        this.setRules(rules.toArray(new IRule[0]));
    }

    private static class DecoratorDetector
    implements IWordDetector {
        private DecoratorDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@';
        }

        public boolean isWordPart(char c) {
            return c != '\n' && c != '\r' && c != '(';
        }
    }

    private static class GreatKeywordDetector
    implements IWordDetector {
        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    private static class GreatWhite
    implements IWhitespaceDetector {
        private GreatWhite() {
        }

        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }

    public static class NumberDetector
    implements IWordDetector {
        private FastStringBuffer buffer = new FastStringBuffer();
        private boolean isInHexa;

        public boolean isWordStart(char c) {
            this.isInHexa = false;
            this.buffer.clear();
            this.buffer.append(c);
            return Character.isDigit(c);
        }

        public boolean isWordPart(char c) {
            if ((c == 'x' || c == 'X') && this.buffer.length() == 1 && this.buffer.charAt(0) == '0') {
                this.buffer.append(c);
                this.isInHexa = true;
                return true;
            }
            this.buffer.append(c);
            if (this.isInHexa) {
                return Character.isDigit(c) || c == 'a' || c == 'A' || c == 'b' || c == 'B' || c == 'c' || c == 'C' || c == 'd' || c == 'D' || c == 'e' || c == 'E' || c == 'f' || c == 'F';
            }
            return Character.isDigit(c) || c == 'e' || c == '.';
        }
    }
}

