/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class PSWTText
extends PNode {
    protected static final double DEFAULT_GREEK_THRESHOLD = 5.5;
    protected static final Color DEFAULT_GREEK_COLOR = Color.gray;
    protected static final String DEFAULT_FONT_NAME = "Helvetica";
    protected static final int DEFAULT_FONT_STYLE = 0;
    protected static final int DEFAULT_FONT_SIZE = 12;
    protected static final Font DEFAULT_FONT = new Font("Helvetica", 0, 12);
    protected static final Color DEFAULT_PEN_COLOR = Color.black;
    protected static final String DEFAULT_TEXT = "";
    protected static final int DEFAULT_PADDING = 2;
    protected double greekThreshold = 5.5;
    protected Color greekColor = DEFAULT_GREEK_COLOR;
    protected Color penColor = DEFAULT_PEN_COLOR;
    protected Font font = DEFAULT_FONT;
    protected int padding = 2;
    protected ArrayList lines = new ArrayList();
    protected double translateX = 0.0;
    protected double translateY = 0.0;

    public PSWTText() {
        this(DEFAULT_TEXT, DEFAULT_FONT);
    }

    public PSWTText(String str) {
        this(str, DEFAULT_FONT);
    }

    public PSWTText(String str, Font font) {
        this.setText(str);
        this.font = font;
        this.recomputeBounds();
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.repaint();
    }

    public Paint getPenPaint() {
        return this.penColor;
    }

    public void setPenPaint(Paint aPaint) {
        this.penColor = (Color)aPaint;
    }

    public Color getBackgroundColor() {
        return (Color)this.getPaint();
    }

    public void setBackgroundColor(Color color) {
        super.setPaint(color);
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double threshold) {
        this.greekThreshold = threshold;
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        String result = new String();
        int lineNum = 0;
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            if (lineNum > 0) {
                result = String.valueOf(result) + '\n';
            }
            String line = (String)i.next();
            result = String.valueOf(result) + line;
            ++lineNum;
        }
        return result;
    }

    public void setFont(Font aFont) {
        this.font = aFont;
        this.recomputeBounds();
    }

    public void setText(String str) {
        int pos = 0;
        boolean done = false;
        this.lines = new ArrayList();
        do {
            int index;
            if ((index = str.indexOf(10, pos)) == -1) {
                this.lines.add(str);
                done = true;
                continue;
            }
            this.lines.add(str.substring(0, index));
            str = str.substring(index + 1);
        } while (!done);
        this.recomputeBounds();
    }

    public void setTranslateX(double x) {
        this.setTranslation(x, this.translateY);
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public void setTranslateY(double y) {
        this.setTranslation(this.translateX, y);
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setTranslation(double x, double y) {
        this.translateX = x;
        this.translateY = y;
        this.recomputeBounds();
    }

    public void setTranslation(Point2D p) {
        this.setTranslation(p.getX(), p.getY());
    }

    public Point2D getTranslation() {
        Point2D.Double p = new Point2D.Double(this.translateX, this.translateY);
        return p;
    }

    public void paint(PPaintContext ppc) {
        Graphics2D g2 = ppc.getGraphics();
        AffineTransform at = null;
        boolean translated = false;
        if (!this.lines.isEmpty()) {
            double renderedFontSize;
            if (this.translateX != 0.0 || this.translateY != 0.0) {
                at = g2.getTransform();
                g2.translate(this.translateX, this.translateY);
                translated = true;
            }
            if ((renderedFontSize = (double)this.font.getSize() * ppc.getScale()) < 0.5 || renderedFontSize < this.greekThreshold) {
                this.paintAsGreek(ppc);
            } else {
                this.paintAsText(ppc);
            }
            if (translated) {
                g2.setTransform(at);
            }
        }
    }

    public void paintAsGreek(PPaintContext ppc) {
        Graphics2D g2 = ppc.getGraphics();
        if (this.greekColor != null) {
            g2.setBackground(this.greekColor);
            ((SWTGraphics2D)g2).fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public void paintAsText(PPaintContext ppc) {
        SWTGraphics2D sg2 = (SWTGraphics2D)ppc.getGraphics();
        if (this.getPaint() != null) {
            sg2.setBackground((Color)this.getPaint());
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
            sg2.fillRect(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY(), ((RectangularShape)rect).getWidth(), ((RectangularShape)rect).getHeight());
        }
        sg2.translate(this.padding, this.padding);
        double scale = Math.min(sg2.getTransform().getScaleX(), sg2.getTransform().getScaleY());
        double dSize = scale * (double)this.font.getSize();
        double fixupScale = Math.floor(dSize) / dSize;
        sg2.scale(fixupScale, fixupScale);
        sg2.setColor(this.penColor);
        sg2.setFont(this.font);
        int lineNum = 0;
        FontMetrics metrics = sg2.getSWTFontMetrics();
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            line = line.equals(DEFAULT_TEXT) ? " " : line;
            double y = lineNum * metrics.getHeight();
            sg2.drawString(line, 0.0, y);
            ++lineNum;
        }
        sg2.scale(1.0 / fixupScale, 1.0 / fixupScale);
        sg2.translate(-this.padding, -this.padding);
    }

    protected void recomputeBounds() {
        double maxWidth = 0.0;
        double height = 0.0;
        boolean hasText = true;
        if (this.lines.size() == 1 && ((String)this.lines.get(0)).equals(DEFAULT_TEXT)) {
            hasText = false;
        }
        GC gc = new GC((Drawable)Display.getDefault());
        SWTGraphics2D g2 = new SWTGraphics2D(gc, (Device)Display.getDefault());
        g2.setFont(this.font);
        FontMetrics fm = g2.getSWTFontMetrics();
        if (!this.lines.isEmpty() && hasText) {
            int lineNum = 0;
            Iterator i = this.lines.iterator();
            while (i.hasNext()) {
                String line = (String)i.next();
                Point bds = gc.stringExtent(line);
                double lineWidth = bds.x;
                if (lineWidth > maxWidth) {
                    maxWidth = lineWidth;
                }
                height = lineNum == 0 ? (height += (double)(fm.getAscent() + fm.getDescent() + fm.getLeading())) : (height += (double)fm.getHeight());
                ++lineNum;
            }
        } else {
            Point bds = gc.stringExtent(" ");
            maxWidth = bds.x;
            height = bds.y;
        }
        gc.dispose();
        this.setBounds(this.translateX, this.translateY, maxWidth + 4.0, height + 4.0);
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
        this.recomputeBounds();
    }
}

