/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;

public class PText
extends PNode {
    public static final String PROPERTY_TEXT = "text";
    public static final int PROPERTY_CODE_TEXT = 524288;
    public static final String PROPERTY_FONT = "font";
    public static final int PROPERTY_CODE_FONT = 0x100000;
    public static Font DEFAULT_FONT = new Font("Helvetica", 0, 12);
    public static double DEFAULT_GREEK_THRESHOLD = 5.5;
    private String text;
    private Paint textPaint;
    private Font font;
    protected double greekThreshold = DEFAULT_GREEK_THRESHOLD;
    private float justification = 0.0f;
    private boolean constrainHeightToTextHeight = true;
    private boolean constrainWidthToTextWidth = true;
    private transient TextLayout[] lines;
    private static final TextLayout[] EMPTY_TEXT_LAYOUT_ARRAY = new TextLayout[0];

    public PText() {
        this.setTextPaint(Color.BLACK);
    }

    public PText(String aText) {
        this();
        this.setText(aText);
    }

    public float getJustification() {
        return this.justification;
    }

    public void setJustification(float just) {
        this.justification = just;
        this.recomputeLayout();
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint textPaint) {
        this.textPaint = textPaint;
        this.invalidatePaint();
    }

    public boolean isConstrainWidthToTextWidth() {
        return this.constrainWidthToTextWidth;
    }

    public void setConstrainWidthToTextWidth(boolean constrainWidthToTextWidth) {
        this.constrainWidthToTextWidth = constrainWidthToTextWidth;
        this.recomputeLayout();
    }

    public boolean isConstrainHeightToTextHeight() {
        return this.constrainHeightToTextHeight;
    }

    public void setConstrainHeightToTextHeight(boolean constrainHeightToTextHeight) {
        this.constrainHeightToTextHeight = constrainHeightToTextHeight;
        this.recomputeLayout();
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double threshold) {
        this.greekThreshold = threshold;
        this.invalidatePaint();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String aText) {
        String old = this.text;
        this.text = aText;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(524288, PROPERTY_TEXT, old, this.text);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public void setFont(Font aFont) {
        Font old = this.font;
        this.font = aFont;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(0x100000, PROPERTY_FONT, old, this.font);
    }

    public void recomputeLayout() {
        ArrayList<TextLayout> linesList = new ArrayList<TextLayout>();
        double textWidth = 0.0;
        double textHeight = 0.0;
        if (this.text != null && this.text.length() > 0) {
            AttributedString atString = new AttributedString(this.text);
            atString.addAttribute(TextAttribute.FONT, this.getFont());
            AttributedCharacterIterator itr = atString.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(itr, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            float availableWidth = this.constrainWidthToTextWidth ? Float.MAX_VALUE : (float)this.getWidth();
            int nextLineBreakOffset = this.text.indexOf(10);
            nextLineBreakOffset = nextLineBreakOffset == -1 ? Integer.MAX_VALUE : ++nextLineBreakOffset;
            while (measurer.getPosition() < itr.getEndIndex()) {
                TextLayout aTextLayout = this.computeNextLayout(measurer, availableWidth, nextLineBreakOffset);
                if (nextLineBreakOffset == measurer.getPosition()) {
                    nextLineBreakOffset = this.text.indexOf(10, measurer.getPosition());
                    nextLineBreakOffset = nextLineBreakOffset == -1 ? Integer.MAX_VALUE : ++nextLineBreakOffset;
                }
                linesList.add(aTextLayout);
                textHeight += (double)aTextLayout.getAscent();
                textHeight += (double)(aTextLayout.getDescent() + aTextLayout.getLeading());
                textWidth = Math.max(textWidth, (double)aTextLayout.getAdvance());
            }
        }
        this.lines = linesList.toArray(EMPTY_TEXT_LAYOUT_ARRAY);
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double newWidth = this.getWidth();
            double newHeight = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                newWidth = textWidth;
            }
            if (this.constrainHeightToTextHeight) {
                newHeight = textHeight;
            }
            super.setBounds(this.getX(), this.getY(), newWidth, newHeight);
        }
    }

    protected TextLayout computeNextLayout(LineBreakMeasurer measurer, float availibleWidth, int nextLineBreakOffset) {
        return measurer.nextLayout(availibleWidth, nextLineBreakOffset, false);
    }

    protected void paint(PPaintContext paintContext) {
        super.paint(paintContext);
        float screenFontSize = (float)this.getFont().getSize() * (float)paintContext.getScale();
        if (this.textPaint != null && (double)screenFontSize > this.greekThreshold) {
            float x = (float)this.getX();
            float y = (float)this.getY();
            float bottomY = (float)this.getHeight() + y;
            Graphics2D g2 = paintContext.getGraphics();
            if (this.lines == null) {
                this.recomputeLayout();
                this.repaint();
                return;
            }
            g2.setPaint(this.textPaint);
            int i = 0;
            while (i < this.lines.length) {
                TextLayout tl = this.lines[i];
                if (bottomY < (y += tl.getAscent())) {
                    return;
                }
                float offset = (float)(this.getWidth() - (double)tl.getAdvance()) * this.justification;
                tl.draw(g2, x + offset, y);
                y += tl.getDescent() + tl.getLeading();
                ++i;
            }
        }
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
        this.recomputeLayout();
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("text=" + (this.text == null ? "null" : this.text));
        result.append(",font=" + (this.font == null ? "null" : this.font.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

