/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.epic.debug.PerlBreakpoint;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlLineBreakpoint;
import org.epic.debug.db.BreakpointMap;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.HelperScript;
import org.epic.debug.db.IPPosition;
import org.epic.debug.db.PerlDebugThread;

class PerlThreadBreakpoints {
    private final IBreakpointListener listener = new IBreakpointListener(){

        public void breakpointAdded(IBreakpoint breakpoint) {
            if (!(breakpoint instanceof PerlLineBreakpoint)) {
                return;
            }
            PerlLineBreakpoint bp = (PerlLineBreakpoint)breakpoint;
            try {
                if (!bp.isEnabled()) {
                    return;
                }
            }
            catch (CoreException e) {
                PerlDebugPlugin.log(e);
                return;
            }
            if (PerlThreadBreakpoints.this.thread.isSuspended()) {
                PerlThreadBreakpoints.this.addBreakpoint(bp);
            } else {
                try {
                    if (PerlThreadBreakpoints.this.pendingBreakpoints.remove(bp, false)) {
                        PerlThreadBreakpoints.this.activeBreakpoints.add(bp);
                    } else {
                        PerlThreadBreakpoints.this.pendingBreakpoints.add(bp);
                    }
                }
                catch (CoreException e) {
                    PerlDebugPlugin.log(e);
                }
            }
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
            if (!(breakpoint instanceof PerlLineBreakpoint)) {
                return;
            }
            boolean enabledOld = (Boolean)delta.getAttribute("org.eclipse.debug.core.enabled");
            boolean enabledNew = false;
            try {
                enabledNew = (Boolean)breakpoint.getMarker().getAttribute("org.eclipse.debug.core.enabled");
            }
            catch (CoreException e) {
                PerlDebugPlugin.log(e);
                return;
            }
            if (enabledOld != enabledNew) {
                if (enabledNew) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, delta);
                }
            }
        }

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
            if (!(breakpoint instanceof PerlLineBreakpoint)) {
                return;
            }
            PerlLineBreakpoint bp = (PerlLineBreakpoint)breakpoint;
            if (PerlThreadBreakpoints.this.thread.isSuspended()) {
                PerlThreadBreakpoints.this.removeBreakpoint(bp);
            } else {
                try {
                    if (!PerlThreadBreakpoints.this.pendingBreakpoints.remove(bp, true)) {
                        PerlThreadBreakpoints.this.activeBreakpoints.remove(bp);
                        PerlThreadBreakpoints.this.pendingBreakpoints.add(bp);
                        bp.pendingRemove();
                    }
                }
                catch (CoreException e) {
                    PerlDebugPlugin.log(e);
                }
            }
        }
    };
    private static final String DB_ADD_BREAK = ";{\n#PARAMS#\nepic_breakpoints::add_breakpoint($file, $line, $cond);\n};";
    private static final String DB_GET_ABS_PATH = ";{\n#PARAMS#\nepic_breakpoints::get_abs_path($file);\n};";
    private static final String DB_REMOVE_BREAK = ";{\n#PARAMS#\nepic_breakpoints::remove_breakpoint($file, $line);\n};";
    private final PerlDebugThread thread;
    private final DebuggerInterface db;
    private final BreakpointMap activeBreakpoints;
    private final BreakpointMap pendingBreakpoints;

    public PerlThreadBreakpoints(PerlDebugThread thread, DebuggerInterface db) throws DebugException {
        this.thread = thread;
        this.db = db;
        this.pendingBreakpoints = new BreakpointMap();
        this.activeBreakpoints = new BreakpointMap();
        this.installInitialBreakpoints();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener(this.listener);
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener(this.listener);
    }

    public IPath getAbsDBPath(IPath relativeDBPath) throws CoreException {
        try {
            String code = HelperScript.replace(DB_GET_ABS_PATH, "#PARAMS#", "my $file = <<'EOT';\n" + relativeDBPath + "\nEOT\n");
            return new Path(this.db.eval(code).trim());
        }
        catch (IOException e) {
            this.thread.throwDebugException(e);
            return null;
        }
    }

    public IBreakpoint getCurrentBreakpoint() throws CoreException {
        IPath epicPath;
        IPPosition pos;
        block6: {
            block5: {
                this.installPendingBreakpoints();
                pos = this.db.getCurrentIP();
                if (pos != null) break block5;
                return null;
            }
            epicPath = this.thread.getEpicPath(pos.getPath());
            if (epicPath != null) break block6;
            this.thread.unresolvedDebuggerPath(pos.getPath());
            return null;
        }
        try {
            return (PerlLineBreakpoint)this.activeBreakpoints.getBreakpoint(epicPath, pos.getLine());
        }
        catch (DebuggerInterface.SessionTerminatedException sessionTerminatedException) {
            return null;
        }
        catch (IOException e) {
            this.thread.throwDebugException(e);
            return null;
        }
    }

    public boolean installPendingBreakpoints() throws CoreException {
        Set bps;
        block7: {
            IPath epicPath;
            block6: {
                IPPosition pos = this.db.getCurrentIP();
                epicPath = this.thread.getEpicPath(pos.getPath());
                if (epicPath != null) break block6;
                this.thread.unresolvedDebuggerPath(pos.getPath());
                return false;
            }
            bps = this.pendingBreakpoints.getBreakpoints(epicPath);
            if (!bps.isEmpty()) break block7;
            return false;
        }
        try {
            Iterator i = bps.iterator();
            while (i.hasNext()) {
                PerlBreakpoint bp = (PerlBreakpoint)((Object)i.next());
                if (bp.isEnabled()) {
                    this.addBreakpoint(bp);
                    continue;
                }
                this.removeBreakpoint(bp);
            }
            return true;
        }
        catch (IOException e) {
            this.thread.throwDebugException(e);
            return false;
        }
    }

    private boolean addBreakpoint(PerlBreakpoint bp) {
        if (!(bp instanceof PerlLineBreakpoint)) {
            return false;
        }
        IPath dbPath = this.thread.getDebuggerPath(bp.getResourcePath());
        if (dbPath == null) {
            this.thread.unresolvedEpicPath(bp.getResourcePath());
            return false;
        }
        try {
            PerlLineBreakpoint lbp = (PerlLineBreakpoint)bp;
            String code = HelperScript.replace(DB_ADD_BREAK, "#PARAMS#", "my $file = <<'EOT';\n" + dbPath + "\nEOT\n" + "my $line = <<'EOT';\n" + lbp.getLineNumber() + "\nEOT\n" + this.getConditionParam(lbp));
            this.db.eval(code);
            this.pendingBreakpoints.remove(lbp);
            this.activeBreakpoints.add(lbp);
            return true;
        }
        catch (Exception e) {
            PerlDebugPlugin.log(e);
            return false;
        }
    }

    private String getConditionParam(PerlLineBreakpoint bp) throws CoreException {
        if (!bp.isConditionEnabled()) {
            return "my $cond = '';\n";
        }
        String condition = bp.getCondition();
        condition = condition.replaceAll("\\n\\r", " ");
        condition = condition.replaceAll("\\r", " ");
        condition = condition.replaceAll("\\n", " ");
        return "my $cond = <<'EOT';\n" + condition + "\nEOT\n";
    }

    private void installInitialBreakpoints() {
        IBreakpoint[] bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(PerlDebugPlugin.getUniqueIdentifier());
        int i = 0;
        while (i < bps.length) {
            PerlBreakpoint bp = (PerlBreakpoint)bps[i];
            try {
                if (bp.isEnabled()) {
                    this.addBreakpoint(bp);
                }
            }
            catch (Exception e) {
                PerlDebugPlugin.log(e);
            }
            ++i;
        }
    }

    private boolean removeBreakpoint(PerlBreakpoint bp) {
        if (!(bp instanceof PerlLineBreakpoint)) {
            return false;
        }
        IPath dbPath = this.thread.getDebuggerPath(bp.getResourcePath());
        if (dbPath == null) {
            this.thread.unresolvedEpicPath(bp.getResourcePath());
            return false;
        }
        try {
            PerlLineBreakpoint lbp = (PerlLineBreakpoint)bp;
            String code = HelperScript.replace(DB_REMOVE_BREAK, "#PARAMS#", "my $file = <<'EOT';\n" + dbPath + "\nEOT\n" + "my $line = <<'EOT';\n" + lbp.getLineNumber() + "\nEOT\n");
            this.db.eval(code);
            this.pendingBreakpoints.remove(lbp);
            this.activeBreakpoints.remove(lbp);
            return true;
        }
        catch (Exception e) {
            PerlDebugPlugin.log(e);
            return false;
        }
    }
}

