/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.epic.perleditor.PerlPluginImages;
import org.epic.perleditor.templates.ContextType;
import org.epic.perleditor.templates.DocumentTemplateContext;
import org.epic.perleditor.templates.Template;
import org.epic.perleditor.templates.TemplateProposal;
import org.epic.perleditor.templates.Templates;
import org.epic.perleditor.templates.perl.CompilationUnitContextType;
import org.epic.perleditor.templates.perl.IPerlCompletionProposal;

public class TemplateEngine {
    private final ContextType contextType;
    private final List proposals;

    public TemplateEngine(ContextType contextType) {
        this.contextType = contextType;
        this.proposals = new ArrayList();
    }

    public void reset() {
        this.proposals.clear();
    }

    public IPerlCompletionProposal[] getResults() {
        return this.proposals.toArray(new IPerlCompletionProposal[this.proposals.size()]);
    }

    public void complete(ITextViewer viewer, int completionPosition) {
        IDocument document = viewer.getDocument();
        if (!(this.contextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        ((CompilationUnitContextType)this.contextType).setContextParameters(document, completionPosition, selection.y);
        DocumentTemplateContext context = (DocumentTemplateContext)this.contextType.createContext();
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = Templates.getInstance().getTemplates();
        int i = 0;
        while (i != templates.length) {
            if (context.canEvaluate(templates[i])) {
                this.proposals.add(new TemplateProposal(templates[i], context, (IRegion)region, viewer, PerlPluginImages.get("org.epic.perleditor.template_obj.gif")));
            }
            ++i;
        }
    }
}

