/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.util.PreferenceUtil;
import org.epic.perleditor.preferences.PreferenceConstants;

public class PerlSourceViewer
extends ProjectionViewer {
    private IVerticalRulerColumn foldColumn;

    public PerlSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, ruler, overviewRuler, showAnnotationsOverview, styles);
    }

    public void addVerticalRulerColumn(IVerticalRulerColumn column) {
        super.addVerticalRulerColumn(column);
        if (this.foldColumn == null) {
            this.foldColumn = column;
            this.updateFoldColumnBackgroundColor(false);
        }
    }

    IVerticalRuler _getVerticalRuler() {
        return super.getVerticalRuler();
    }

    protected void customizeDocumentCommand(DocumentCommand command) {
        try {
            if (command.text.equals("\t")) {
                int line = this.getDocument().getLineOfOffset(command.offset);
                int lineStartOffset = this.getDocument().getLineOffset(line);
                int column = command.offset - lineStartOffset;
                command.text = PreferenceUtil.getTab(column);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        super.customizeDocumentCommand(command);
    }

    public void updateFoldColumnBackgroundColor(boolean force) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)PerlEditorPlugin.getDefault().getPreferenceStore(), (String)"foldColumnBackground");
        if (force || !rgb.equals((Object)PreferenceConstants.EDITOR_FOLD_COLUMN_BG_COLOR_DEFAULT)) {
            this.foldColumn.getControl().setBackground(PerlEditorPlugin.getDefault().getColor("foldColumnBackground"));
        }
    }
}

