/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.epic.core.model.ISourceElement;
import org.epic.core.model.SourceFile;
import org.epic.core.util.FileUtilities;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.actions.ClearMarkerAction;
import org.epic.perleditor.actions.ExportHtmlSourceAction;
import org.epic.perleditor.actions.ExtractSubroutineAction;
import org.epic.perleditor.actions.FormatSourceAction;
import org.epic.perleditor.actions.Jump2BracketAction;
import org.epic.perleditor.actions.OpenDeclarationAction;
import org.epic.perleditor.actions.PerlCriticAction;
import org.epic.perleditor.actions.PerlDocAction;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.actions.PodCheckerAction;
import org.epic.perleditor.actions.ToggleCommentAction;
import org.epic.perleditor.actions.ValidateSourceAction;
import org.epic.perleditor.editors.FoldReconciler;
import org.epic.perleditor.editors.IdleTimer;
import org.epic.perleditor.editors.IdleTimerListener;
import org.epic.perleditor.editors.OccurrencesUpdater;
import org.epic.perleditor.editors.PartitionTypes;
import org.epic.perleditor.editors.PerlBracketInserter;
import org.epic.perleditor.editors.PerlEditorActionIds;
import org.epic.perleditor.editors.PerlEditorMessages;
import org.epic.perleditor.editors.PerlPairMatcher;
import org.epic.perleditor.editors.PerlPartitioner;
import org.epic.perleditor.editors.PerlSourceViewer;
import org.epic.perleditor.editors.PerlSourceViewerConfiguration;
import org.epic.perleditor.editors.PerlSyntaxValidationThread;
import org.epic.perleditor.editors.TasksReconciler;
import org.epic.perleditor.templates.perl.ModuleCompletionHelper;
import org.epic.perleditor.views.PerlOutlinePage;

public class PerlEditor
extends TextEditor
implements IPropertyChangeListener {
    public static final String PERL_EDITOR_ID = "org.epic.perleditor.editors.PerlEditor";
    private PerlPairMatcher bracketMatcher;
    private PerlBracketInserter bracketInserter;
    private FoldReconciler foldReconciler;
    private TasksReconciler tasksReconciler;
    private PerlOutlinePage outlinePage;
    private PerlSyntaxValidationThread validationThread;
    private PerlSourceViewer sourceViewer;
    private IdleTimer idleTimer;
    private ProjectionSupport projectionSupport;
    private SourceFile source;
    private OccurrencesUpdater occurrencesUpdater;
    private boolean syncToOutline;
    private boolean syncFromOutline;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public PerlEditor() {
        this.setDocumentProvider(PerlEditorPlugin.getDefault().getDocumentProvider());
        PerlEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.setKeyBindingScopes(new String[]{"org.epic.perleditor.perlEditorScope"});
        this.setEditorContextMenuId("#PerlEditorContext");
        this.setRulerContextMenuId("#PerlRulerContext");
    }

    public void createPartControl(Composite parent) {
        if (Workbench.getInstance().isClosing()) {
            return;
        }
        super.createPartControl(parent);
        this.installProjectionSupport();
        this.installBracketInserter();
        this.installCaretMoveListener();
        this.installModuleCompletionHelper();
        this.installIdleTimer();
        this.installSyntaxValidationThread();
        this.installFoldReconciler();
        this.installTasksReconciler();
        this.installAnnotationListener();
        this.source = new SourceFile(PerlEditorPlugin.getDefault().getLog(), this.getViewer().getDocument());
        this.reconcile();
    }

    public void dispose() {
        PerlEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.uninstallAnnotationListener();
        try {
            if (this.sourceViewer instanceof ITextViewerExtension && this.bracketInserter != null) {
                this.sourceViewer.removeVerifyKeyListener(this.bracketInserter);
            }
            if (this.validationThread != null) {
                this.validationThread.dispose();
            }
            if (this.idleTimer != null) {
                this.idleTimer.dispose();
            }
            String[] actionIds = PerlEditorActionIds.getEditorActions();
            int i = 0;
            while (i < actionIds.length) {
                IAction action = this.getAction(actionIds[i]);
                if (action instanceof PerlEditorAction) {
                    ((PerlEditorAction)action).dispose();
                }
                ++i;
            }
            super.dispose();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.revalidateSyntax();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.revalidateSyntax();
    }

    public void doSaveAs() {
        super.doSaveAs();
        this.revalidateSyntax();
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        if (input instanceof ILocationProvider) {
            ILocationProvider l;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((input = FileUtilities.getFileEditorInput((l = (ILocationProvider)input.getAdapter((Class)clazz)).getPath((Object)l).makeAbsolute())) == null) {
                throw new CoreException((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Could not open requested file " + l.getPath((Object)l).makeAbsolute() + ". Inspect the Error Log for additional information.", null));
            }
        }
        super.doSetInput(input);
        if (this.getViewer() != null) {
            this.source = new SourceFile(PerlEditorPlugin.getDefault().getLog(), this.getViewer().getDocument());
            this.reconcile();
        }
    }

    public int findMatchingBracket(IDocument document, int offset, boolean exact) {
        if (exact) {
            this.bracketMatcher.setViewer(null);
        }
        try {
            int[] ret = new int[1];
            IRegion matchRegion = this.bracketMatcher.match(document, offset);
            ret[0] = matchRegion == null ? -1 : (matchRegion.getOffset() == offset - 1 ? matchRegion.getOffset() + matchRegion.getLength() - 1 : matchRegion.getOffset());
            int n = ret[0];
            Object var6_7 = null;
            if (exact) {
                this.bracketMatcher.setViewer((ISourceViewer)this.sourceViewer);
            }
            return n;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_8 = null;
                if (!exact) break block4;
                this.bracketMatcher.setViewer((ISourceViewer)this.sourceViewer);
            }
            throw throwable;
        }
    }

    public Object getAdapter(Class adapter) {
        IEditorInput input;
        Object result;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter) && this.projectionSupport != null && (result = this.projectionSupport.getAdapter((ISourceViewer)this.sourceViewer, adapter)) != null) {
            return result;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2) && (input = this.getEditorInput()) instanceof IFileEditorInput) {
            if (this.outlinePage == null) {
                this.outlinePage = new PerlOutlinePage(this.source);
                this.outlinePage.addSelectionChangedListener(new OutlineSelectionListener());
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public IdleTimer getIdleTimer() {
        return this.idleTimer;
    }

    public SourceFile getSourceFile() {
        return this.source;
    }

    public TestInterface getTestInterface() {
        return new TestInterface();
    }

    public ISourceViewer getViewer() {
        return super.getSourceViewer();
    }

    public void jumpToMatchingBracket() {
        int caretOffset = this.sourceViewer.getSelectedRange().x;
        int matchOffset = this.findMatchingBracket(this.sourceViewer.getDocument(), caretOffset, true);
        if (matchOffset == -1) {
            return;
        }
        this.sourceViewer.revealRange(matchOffset + 1, 1);
        this.sourceViewer.setSelectedRange(matchOffset + 1, 0);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("PERL_EXECUTABLE")) {
            return;
        }
        if (event.getProperty().equals("SYNTAX_VALIDATION_PREFERENCE")) {
            if (PerlEditorPlugin.getDefault().getBooleanPreference("SYNTAX_VALIDATION_PREFERENCE")) {
                if (!this.idleTimer.isRegistered(this.validationThread)) {
                    this.registerIdleListener(this.validationThread);
                }
            } else if (this.idleTimer.isRegistered(this.validationThread)) {
                this.idleTimer.removeListener(this.validationThread);
            }
        }
    }

    public void reconcile() {
        if (this.sourceViewer == null) {
            return;
        }
        StyledText widget = this.sourceViewer.getTextWidget();
        if (widget == null || widget.isDisposed()) {
            return;
        }
        Display display = widget.getDisplay();
        if (display == null) {
            return;
        }
        IDocument doc = this.sourceViewer.getDocument();
        if (doc == null) {
            return;
        }
        display.syncExec(new Runnable(){

            public void run() {
                PerlEditor.this.source.parse();
                if (PerlEditor.this.outlinePage != null) {
                    PerlEditor.this.outlinePage.updateContent(PerlEditor.this.source);
                }
                if (PerlEditor.this.foldReconciler != null) {
                    PerlEditor.this.foldReconciler.reconcile();
                }
                if (PerlEditor.this.tasksReconciler != null) {
                    PerlEditor.this.tasksReconciler.reconcile();
                }
            }
        });
    }

    public void refreshTaskView() {
        this.tasksReconciler.reconcile();
    }

    public void registerIdleListener(IdleTimerListener obj) {
        this.idleTimer.addListener(obj);
    }

    public void revalidateSyntax() {
        if (this.validationThread != null) {
            this.validationThread.revalidate();
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return true;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("matchingBrackets", "matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        this.wireAction((IAction)new ContentAssistAction(PerlEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this), "org.eclipse.ui.edit.text.contentAssist.proposals", "org.epic.perleditor.actions.ContentAssistAction");
        this.wireAction((IAction)new ClearMarkerAction.Critic(this), "org.epic.perleditor.commands.clearMarker", "org.epic.perleditor.actions.ClearMarkerAction#Critic");
        this.wireAction((IAction)new ClearMarkerAction.PodChecker(this), "org.epic.perleditor.commands.clearMarker", "org.epic.perleditor.actions.ClearMarkerAction#PodChecker");
        this.wireAction((IAction)new ClearMarkerAction.AllMarkers(this), "org.epic.perleditor.commands.clearMarker", "org.epic.perleditor.actions.ClearMarkerAction#AllMarkers");
        this.wireAction((IAction)new PodCheckerAction(this), "org.epic.perleditor.commands.podChecker", "org.epic.perleditor.actions.PodCheckerAction");
        this.wireAction((IAction)new ToggleCommentAction(this), "org.epic.perleditor.commands.toggleComment", "org.epic.perleditor.actions.ToggleCommentAction");
        this.wireAction((IAction)new PerlCriticAction(this), "org.epic.perleditor.commands.perlCritic", "org.epic.perleditor.actions.PerlCriticAction");
        this.wireAction((IAction)new FormatSourceAction(this), "org.epic.perleditor.commands.formatSource", "org.epic.perleditor.actions.FormatSourceAction");
        this.wireAction((IAction)new Jump2BracketAction(this), "org.epic.perleditor.commands.jump2Bracket", "org.epic.perleditor.actions.Jump2BracketAction");
        this.wireAction((IAction)new ExportHtmlSourceAction(this), "org.epic.perleditor.commands.htmlExport", "org.epic.perleditor.actions.ExportHtmlAction");
        this.wireAction((IAction)new ValidateSourceAction(this), "org.epic.perleditor.commands.validateSyntax", "org.epic.perleditor.actions.ValidateSyntaxAction");
        this.wireAction((IAction)new OpenDeclarationAction(this), "org.epic.perleditor.commands.openDeclaration", "org.epic.perleditor.actions.OpenDeclarationAction");
        this.wireAction((IAction)new PerlDocAction(this), "org.epic.perleditor.commands.searchPerlDoc", "org.epic.perleditor.actions.PerlDocAction");
        this.wireAction((IAction)new ExtractSubroutineAction(this), "org.epic.perleditor.commands.extractSubroutine", "org.epic.perleditor.actions.ExtractSubroutineAction");
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        Object action = new SmartLineStartAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)action);
        action = new SmartLineStartAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)action);
        action = new NextWordAction(0x1040004, false, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(SWT.MOD1 | 0x1000004, 0);
        action = new NextWordAction(17170436, true, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(SWT.MOD1 | SWT.MOD2 | 0x1000004, 0);
        action = new NextWordAction(262271, false, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deleteNextWord");
        this.setAction("org.eclipse.ui.edit.text.deleteNextWord", (IAction)action);
        textWidget.setKeyBinding(SWT.MOD1 | 0x7F, 0);
        action = new PreviousWordAction(17039363, false, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(SWT.MOD1 | 0x1000003, 0);
        action = new PreviousWordAction(17170435, true, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(SWT.MOD1 | SWT.MOD2 | 0x1000003, 0);
        action = new PreviousWordAction(262152, false, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deletePreviousWord");
        this.setAction("org.eclipse.ui.edit.text.deletePreviousWord", (IAction)action);
        textWidget.setKeyBinding(SWT.MOD1 | 8, 0);
    }

    protected final ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.sourceViewer = new PerlSourceViewer(parent, ruler, this.fOverviewRuler, this.isOverviewRulerVisible(), styles);
        this.installBracketMatcher();
        this.getSourceViewerDecorationSupport((ISourceViewer)this.sourceViewer);
        this.sourceViewer.getTextWidget().setWordWrap(this.getPreferenceStore().getBoolean("lineWrap"));
        return this.sourceViewer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (this.sourceViewer == null) return;
        if (this.sourceViewer.getTextWidget() == null) return;
        if (this.bracketInserter == null) {
            return;
        }
        try {
            if (event.getProperty().equals("Occurrences.markOccurrences")) {
                boolean newValue;
                boolean oldValue = event.getOldValue() != null ? Boolean.valueOf(event.getOldValue().toString()) : false;
                boolean bl = newValue = event.getOldValue() != null ? Boolean.valueOf(event.getNewValue().toString()) : false;
                if (newValue != oldValue) {
                    if (newValue) {
                        this.installAnnotationListener();
                    } else {
                        this.uninstallAnnotationListener();
                    }
                }
            } else if (event.getProperty().equals("lineWrap")) {
                boolean newValue;
                boolean oldValue = event.getOldValue() != null ? Boolean.valueOf(event.getOldValue().toString()) : false;
                boolean bl = newValue = event.getOldValue() != null ? Boolean.valueOf(event.getNewValue().toString()) : false;
                if (newValue != oldValue) {
                    this.sourceViewer.getTextWidget().setWordWrap(newValue);
                }
            } else if (event.getProperty().equals("foldColumnBackground")) {
                this.sourceViewer.updateFoldColumnBackgroundColor(true);
            } else {
                this.reconfigureBracketInserter();
            }
            Object var4_8 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            super.handlePreferenceStoreChanged(event);
            throw throwable;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{EditorsUI.getPreferenceStore(), PerlEditorPlugin.getDefault().getPreferenceStore(), this.getPreferenceStore()}));
        this.setSourceViewerConfiguration(new PerlSourceViewerConfiguration(PerlEditorPlugin.getDefault().getPreferenceStore(), this));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void caretMoved() {
        if (!this.getPreferenceStore().getBoolean("syncOutlineOnCursorMove")) {
            return;
        }
        if (this.syncFromOutline) {
            this.syncFromOutline = false;
            return;
        }
        if (this.outlinePage == null) return;
        if (this.source == null) return;
        if (this.source.getDocument() == null) {
            return;
        }
        try {
            try {
                this.syncToOutline = true;
                int caretOffset = this.sourceViewer.getSelectedRange().x;
                int caretLine = this.source.getDocument().getLineOfOffset(caretOffset);
                this.outlinePage.updateSelection(caretLine);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.syncToOutline = false;
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.syncToOutline = false;
            return;
        }
    }

    private IResource getResource() {
        IEditorInput iEditorInput = this.getEditorInput();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IResource)iEditorInput.getAdapter((Class)clazz);
    }

    private void installBracketInserter() {
        this.bracketInserter = new PerlBracketInserter(PerlEditorPlugin.getDefault().getLog());
        this.reconfigureBracketInserter();
        if (this.sourceViewer instanceof ITextViewerExtension) {
            this.sourceViewer.prependVerifyKeyListener(this.bracketInserter);
        }
        this.bracketInserter.setViewer((ISourceViewer)this.sourceViewer);
    }

    private void installBracketMatcher() {
        this.bracketMatcher = new PerlPairMatcher(PerlEditorPlugin.getDefault().getLog());
        this.bracketMatcher.setViewer((ISourceViewer)this.sourceViewer);
    }

    private void installCaretMoveListener() {
        new CaretMoveListener().install(this.getSelectionProvider());
    }

    private void installAnnotationListener() {
        if (this.occurrencesUpdater == null) {
            this.occurrencesUpdater = new OccurrencesUpdater();
        }
        this.occurrencesUpdater.install(this.getSourceViewer());
    }

    private void uninstallAnnotationListener() {
        if (this.occurrencesUpdater == null) {
            return;
        }
        this.occurrencesUpdater.uninstall();
    }

    private void installFoldReconciler() {
        this.foldReconciler = new FoldReconciler(this);
    }

    private void installIdleTimer() {
        this.idleTimer = new IdleTimer((ISourceViewer)this.sourceViewer, Display.getCurrent());
        this.idleTimer.start();
    }

    private void installModuleCompletionHelper() {
        IResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        Thread backgroundLoader = new Thread(new Runnable(){

            public void run() {
                try {
                    ModuleCompletionHelper completionHelper = ModuleCompletionHelper.getInstance();
                    completionHelper.scanForModules(PerlEditor.this);
                }
                catch (CoreException e) {
                    PerlEditorPlugin.getDefault().getLog().log(e.getStatus());
                }
            }
        }, "EPIC:ModuleCompletionHelper");
        backgroundLoader.setPriority(1);
        backgroundLoader.start();
    }

    private void installProjectionSupport() {
        PerlSourceViewer viewer = this.sourceViewer;
        this.projectionSupport = new ProjectionSupport((ProjectionViewer)viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        viewer.doOperation(19);
    }

    private void installSyntaxValidationThread() {
        IResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        this.validationThread = new PerlSyntaxValidationThread();
        this.validationThread.setPriority(1);
        this.validationThread.start();
        this.validationThread.setDocument(resource, this.sourceViewer.getDocument());
        if (PerlEditorPlugin.getDefault().getBooleanPreference("SYNTAX_VALIDATION_PREFERENCE") && this.idleTimer != null) {
            this.registerIdleListener(this.validationThread);
        }
    }

    private void installTasksReconciler() {
        IResource resource = this.getResource();
        if (resource == null) {
            return;
        }
        this.tasksReconciler = new TasksReconciler(this);
    }

    private void reconfigureBracketInserter() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.bracketInserter.setCloseBracketsEnabled(preferenceStore.getBoolean("autoCompletionBracket1"));
        this.bracketInserter.setCloseBracesEnabled(preferenceStore.getBoolean("autoCompletionBracket2"));
        this.bracketInserter.setCloseParensEnabled(preferenceStore.getBoolean("autoCompletionBracket3"));
        this.bracketInserter.setCloseAngularBracketsEnabled(preferenceStore.getBoolean("autoCompletionBracket4"));
        this.bracketInserter.setCloseDoubleQuotesEnabled(preferenceStore.getBoolean("autoCompletionQuote1"));
        this.bracketInserter.setCloseSingleQuotesEnabled(preferenceStore.getBoolean("autoCompletionQuote2"));
    }

    private void wireAction(IAction action, String commandId, String perlActionId) {
        action.setActionDefinitionId(commandId);
        this.setAction(perlActionId, action);
    }

    static /* synthetic */ int access$7(ISourceViewer iSourceViewer, int n) {
        return AbstractTextEditor.widgetOffset2ModelOffset((ISourceViewer)iSourceViewer, (int)n);
    }

    static /* synthetic */ int access$8(ISourceViewer iSourceViewer, int n) {
        return AbstractTextEditor.modelOffset2WidgetOffset((ISourceViewer)iSourceViewer, (int)n);
    }

    public class TestInterface {
        public void clear() {
            PerlEditor.this.sourceViewer.getTextWidget().setText("");
        }

        public int getHighlightedBracketOffset() {
            int offset = PerlEditor.this.sourceViewer.getTextWidget().getCaretOffset();
            PerlPairMatcher matcher = new PerlPairMatcher(PerlEditorPlugin.getDefault().getLog());
            matcher.setViewer(null);
            matcher.match(PerlEditor.this.sourceViewer.getDocument(), offset);
            return offset - 1 == matcher.getStartPos() ? matcher.getEndPos() : matcher.getStartPos();
        }

        public String getText() {
            return PerlEditor.this.sourceViewer.getTextWidget().getText();
        }

        public IVerticalRuler getVerticalRuler() {
            return PerlEditor.this.sourceViewer._getVerticalRuler();
        }

        public void setCaretOffset(int offset) {
            Display display = PerlEditor.this.sourceViewer.getTextWidget().getDisplay();
            PerlEditor.this.sourceViewer.setSelectedRange(offset, 0);
            while (display.readAndDispatch()) {
            }
        }

        public void setExactBracketMatching() {
            PerlEditor.this.bracketMatcher.setViewer(null);
        }

        public void setTopIndex(int topIndex) {
            PerlEditor.this.sourceViewer.setTopIndex(topIndex);
        }

        public void selectText(String text) {
            if (text.length() == 0) {
                PerlEditor.this.getSelectionProvider().setSelection((ISelection)TextSelection.emptySelection());
            } else {
                int i = PerlEditor.this.sourceViewer.getDocument().get().indexOf(text);
                if (i == -1) {
                    throw new RuntimeException("text \"" + text + "\" not found in editor");
                }
                PerlEditor.this.getSelectionProvider().setSelection((ISelection)new TextSelection(i, text.length()));
            }
        }
    }

    private class CaretMoveListener
    implements ISelectionChangedListener {
        private CaretMoveListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            PerlEditor.this.caretMoved();
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private class OutlineSelectionListener
    implements ISelectionChangedListener {
        private OutlineSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (PerlEditor.this.syncToOutline) {
                return;
            }
            if (event == null) {
                return;
            }
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            if (!(sel.getFirstElement() instanceof ISourceElement)) {
                return;
            }
            ISourceElement elem = (ISourceElement)sel.getFirstElement();
            PerlEditor.this.syncFromOutline = true;
            PerlEditor.this.selectAndReveal(elem.getOffset(), elem.getName().length());
        }
    }

    private class SmartLineStartAction
    extends AbstractTextEditor.LineStartAction {
        public SmartLineStartAction(StyledText textWidget, boolean doSelect) {
            super((AbstractTextEditor)PerlEditor.this, textWidget, doSelect);
        }

        protected int getLineStartPosition(IDocument document, String line, int length, int offset) {
            int index = super.getLineStartPosition(document, line, length, offset);
            if (index < length - 1 && line.charAt(index) == '#') {
                ++index;
                while (index < length && Character.isWhitespace(line.charAt(index))) {
                    ++index;
                }
            }
            return index;
        }
    }

    protected abstract class WordNavigationAction
    extends TextNavigationAction {
        private boolean select;
        private boolean delete;

        protected WordNavigationAction(int code, boolean select, boolean delete) {
            super(PerlEditor.this.getSourceViewer().getTextWidget(), code);
            this.select = select;
            this.delete = delete;
        }

        public final void run() {
            IPreferenceStore store = PerlEditor.this.getPreferenceStore();
            if (!store.getBoolean("subWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = PerlEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            int position = PerlEditor.access$7(viewer, viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            PerlPartitioner partitioner = (PerlPartitioner)PartitionTypes.getPerlPartitioner(document);
            int docLength = document.getLength();
            this.run(viewer, document, position, partitioner, docLength);
        }

        protected abstract void run(ISourceViewer var1, IDocument var2, int var3, PerlPartitioner var4, int var5);

        protected final boolean isWordSeparator(char c) {
            return !Character.isLetterOrDigit(c) && !Character.isWhitespace(c) && c != '_' && c != '&' && c != '$' && c != '@' && c != '%';
        }

        protected final void setCaretPosition(int modelOffset) {
            ISourceViewer viewer = PerlEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            if (this.select) {
                int mod;
                int anchor;
                Point selection = text.getSelection();
                int oldCaret = text.getCaretOffset();
                int newCaret = PerlEditor.access$8(viewer, modelOffset);
                if (oldCaret == selection.x) {
                    anchor = selection.y;
                    mod = selection.x;
                } else {
                    anchor = selection.x;
                    mod = selection.y;
                }
                mod = newCaret < oldCaret ? (mod -= oldCaret - newCaret) : (mod += newCaret - oldCaret);
                text.setSelection(anchor, mod);
            } else if (this.delete) {
                int oldOffset = PerlEditor.access$7(viewer, text.getCaretOffset());
                int start = oldOffset > modelOffset ? modelOffset : oldOffset;
                int length = Math.abs(modelOffset - oldOffset);
                try {
                    viewer.getDocument().replace(start, length, "");
                }
                catch (BadLocationException badLocationException) {}
            } else {
                text.setCaretOffset(PerlEditor.access$8(viewer, modelOffset));
            }
        }
    }

    private final class NextWordAction
    extends WordNavigationAction {
        protected NextWordAction(int code, boolean select, boolean delete) {
            super(code, select, delete);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void run(ISourceViewer viewer, IDocument document, int position, PerlPartitioner partitioner, int length) {
            try {
                int line = document.getLineOfOffset(position);
                if (position < length && (document.getChar(position) == '\n' || document.getChar(position) == '\r')) {
                    if (line >= document.getNumberOfLines()) return;
                    position = document.getLineOffset(line + 1);
                } else {
                    ITypedRegion partition = partitioner.getPartition(position, true);
                    int partitionEnd = partition.getOffset() + partition.getLength();
                    if (position == partitionEnd && position < length) {
                        partition = partitioner.getPartition(position + 1, true);
                        partitionEnd = partition.getOffset() + partition.getLength();
                    }
                    int tmp = position;
                    while (position < partitionEnd && this.isWordSeparator(document.getChar(position))) {
                        ++position;
                    }
                    if (position == tmp) {
                        while (position < partitionEnd && !Character.isWhitespace(document.getChar(position)) && !this.isWordSeparator(document.getChar(position))) {
                            ++position;
                        }
                        while (position < length && Character.isWhitespace(document.getChar(position)) && document.getChar(position) != '\n' && document.getChar(position) != '\r') {
                            ++position;
                        }
                    }
                }
                this.setCaretPosition(position);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
                return;
            }
            catch (BadLocationException e) {
                PerlEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "An unexpected exception occurred in NextWordAction", (Throwable)e));
                super.run();
            }
        }
    }

    private final class PreviousWordAction
    extends WordNavigationAction {
        protected PreviousWordAction(int code, boolean select, boolean delete) {
            super(code, select, delete);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void run(ISourceViewer viewer, IDocument document, int position, PerlPartitioner partitioner, int length) {
            try {
                int line = document.getLineOfOffset(position);
                if (document.getLineOffset(line) == position) {
                    if (line <= 0) return;
                    int prevLineOffset = document.getLineOffset(line - 1);
                    position = prevLineOffset + document.getLineLength(line - 1);
                    while (position > prevLineOffset && (document.getChar(position - 1) == '\n' || document.getChar(position - 1) == '\r')) {
                        --position;
                    }
                } else {
                    ITypedRegion partition = partitioner.getPartition(position, false);
                    int partitionStart = partition.getOffset();
                    if (position == partitionStart && position > 0) {
                        partition = partitioner.getPartition(position - 1, false);
                        partitionStart = partition.getOffset();
                    }
                    int tmp = position;
                    while (position > partitionStart && this.isWordSeparator(document.getChar(position - 1))) {
                        --position;
                    }
                    if (position == tmp) {
                        while (position > partitionStart && Character.isWhitespace(document.getChar(position - 1)) && document.getChar(position - 1) != '\n' && document.getChar(position - 1) != '\r') {
                            --position;
                        }
                        while (position > partitionStart && !Character.isWhitespace(document.getChar(position - 1)) && !this.isWordSeparator(document.getChar(position - 1))) {
                            --position;
                        }
                    }
                }
                this.setCaretPosition(position);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
                return;
            }
            catch (BadLocationException e) {
                PerlEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "An unexpected exception occurred in PreviousWordAction", (Throwable)e));
                super.run();
            }
        }
    }
}

