/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.util.SourceFormatter;
import org.epic.perleditor.editors.util.SourceFormatterException;

public class FormatSourceAction
extends PerlEditorAction {
    public FormatSourceAction(PerlEditor editor) {
        super(editor);
    }

    protected void doRun() {
        IDocument doc = this.getEditor().getDocumentProvider().getDocument((Object)this.getEditor().getEditorInput());
        if (doc.getLength() == 0) {
            return;
        }
        StringBuffer text = new StringBuffer(doc.get());
        String anchor = this.getAnchorString(text);
        ISourceViewer viewer = this.getEditor().getViewer();
        int anchorOffset = this.getAnchorOffset(viewer, doc);
        text.insert(anchorOffset, anchor);
        String formattedText = this.runFormatter(text);
        if (formattedText == null || formattedText.equals(text.toString()) || formattedText.equals(anchor)) {
            return;
        }
        StringBuffer newText = new StringBuffer(formattedText);
        anchorOffset = newText.indexOf(anchor);
        if (anchorOffset > 0) {
            int len = anchor.length() + 1;
            --anchorOffset;
            while (anchorOffset >= 0 && Character.isWhitespace(newText.charAt(anchorOffset))) {
                --anchorOffset;
                ++len;
            }
            newText.delete(anchorOffset + 1, anchorOffset + len);
        } else {
            anchorOffset = 0;
        }
        doc.set(newText.toString());
        viewer.setSelectedRange(anchorOffset, 0);
        viewer.revealRange(anchorOffset, 0);
    }

    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.FormatSourceAction";
    }

    private int getAnchorOffset(ISourceViewer viewer, IDocument doc) {
        try {
            Point sel = viewer.getSelectedRange();
            int docOffset = sel != null ? sel.x : 0;
            int line = doc.getLineOfOffset(docOffset);
            int i = doc.getLineOffset(line) + doc.getLineLength(line);
            --i;
            while ((doc.getChar(i) == '\n' || doc.getChar(i) == '\r') && doc.getLineOfOffset(i) == line) {
                --i;
            }
            return i + 1;
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private String getAnchorString(StringBuffer docText) {
        String posAnchor = "\ufffd\ufffd\ufffd\ufffd";
        StringBuffer buf = new StringBuffer();
        buf.append('#');
        buf.append(posAnchor);
        while (docText.indexOf(buf.toString()) >= 0) {
            buf.append(posAnchor);
        }
        return buf.toString();
    }

    private void handleCoreException(CoreException e) {
        this.log(e.getStatus());
        MessageDialog.openError((Shell)this.getEditor().getSite().getShell(), (String)"Source formatter failed", (String)e.getMessage());
    }

    private String runFormatter(StringBuffer text) {
        try {
            return SourceFormatter.format(text.toString(), this.getLog());
        }
        catch (SourceFormatterException e) {
            if (e.output == null) {
                this.handleCoreException(e);
                return null;
            }
            if (MessageDialog.openQuestion((Shell)this.getEditor().getSite().getShell(), (String)"Source formatter failed", (String)(String.valueOf(e.getMessage()) + "\nUse formatter's output anyway?"))) {
                return e.output;
            }
            return null;
        }
        catch (CoreException e) {
            this.handleCoreException(e);
            return null;
        }
    }
}

