/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor;

import java.io.File;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.IFileTypeInfo;
import org.eclipse.team.core.Team;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.epic.core.util.PerlExecutor;
import org.epic.perleditor.PerlPluginImages;
import org.epic.perleditor.editors.PerlDocumentProvider;
import org.epic.perleditor.editors.util.PerlColorProvider;
import org.epic.perleditor.preferences.CodeAssistPreferences;
import org.epic.perleditor.preferences.MarkOccurrencesPreferences;
import org.epic.perleditor.preferences.PreferenceConstants;
import org.epic.perleditor.preferences.SourceFormatterPreferences;
import org.epic.perleditor.preferences.TaskTagPreferences;
import org.osgi.framework.BundleContext;

public class PerlEditorPlugin
extends AbstractUIPlugin {
    private static PerlEditorPlugin plugin;
    private ResourceBundle resourceBundle;
    private PerlColorProvider colorProvider = new PerlColorProvider();
    private IDocumentProvider fDocumentProvider;
    private boolean requirePerlCheckPassed;
    private boolean requirePerlErrorDisplayed;

    public PerlEditorPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.epic.perleditor.PerlEditorPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        String[] perlTypes = new String[]{"pl", "pm"};
        IFileTypeInfo[] fileTypes = Team.getAllTypes();
        int newTypesLength = fileTypes.length + perlTypes.length;
        String[] extensions = new String[newTypesLength];
        int[] types = new int[newTypesLength];
        int i = 0;
        while (i < fileTypes.length) {
            extensions[i] = fileTypes[i].getExtension();
            types[i] = fileTypes[i].getType();
            ++i;
        }
        while (i < newTypesLength) {
            extensions[i] = perlTypes[i - fileTypes.length];
            types[i] = 1;
            ++i;
        }
        Team.setAllTypes((String[])extensions, (int[])types);
    }

    public Color getColor(RGB rgb) {
        return this.colorProvider.getColor(rgb);
    }

    public Color getColor(String preferenceKey) {
        return this.getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)preferenceKey));
    }

    public static PerlEditorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PerlEditorPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbenchWindow window = PerlEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            window = PerlEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0];
        }
        return window;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        PreferenceConstants.initializeDefaultValues(store);
        SourceFormatterPreferences.initializeDefaultValues(store);
        CodeAssistPreferences.initializeDefaultValues(store);
        TaskTagPreferences.initializeDefaults(store);
        MarkOccurrencesPreferences.initializeDefaultValues(store);
        System.setProperty("sourceCriticEnabled", store.getString("sourceCriticEnabled"));
    }

    public String getPerlExecutable() {
        return this.getPreferenceStore().getString("PERL_EXECUTABLE");
    }

    public void setPerlExecutable(String value) {
        this.getPreferenceStore().setValue("PERL_EXECUTABLE", value);
        this.requirePerlErrorDisplayed = false;
        this.checkForPerlInterpreter(true);
    }

    public boolean getBooleanPreference(String name) {
        boolean ret = this.getPreferenceStore().getBoolean(name);
        if (ret) {
            return true;
        }
        String value = this.getPreferenceStore().getString(name);
        return value.equals("1");
    }

    public static String getPluginId() {
        PerlEditorPlugin plugin = PerlEditorPlugin.getDefault();
        return plugin != null ? plugin.getBundle().getSymbolicName() : "org.epic.perleditor";
    }

    public synchronized IDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new PerlDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public static String getUniqueIdentifier() {
        PerlEditorPlugin plugin = PerlEditorPlugin.getDefault();
        return plugin != null ? plugin.getBundle().getSymbolicName() : "org.epic.perleditor";
    }

    public boolean hasPerlInterpreter() {
        return this.requirePerlCheckPassed;
    }

    public boolean requirePerlInterpreter(boolean interactive) {
        if (!this.requirePerlCheckPassed) {
            this.checkForPerlInterpreter(interactive);
        }
        return this.requirePerlCheckPassed;
    }

    protected ImageRegistry createImageRegistry() {
        return PerlPluginImages.getImageRegistry();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForPerlInterpreter(boolean interactive) {
        PerlExecutor executor = new PerlExecutor();
        try {
            block8: {
                try {
                    ArrayList<String> args = new ArrayList<String>(1);
                    args.add("-v");
                    if (executor.execute((File)new File((String)"."), args, (String)"").stdout.indexOf("This is perl") != -1) {
                        this.requirePerlCheckPassed = true;
                        break block8;
                    }
                    Status status = new Status(4, PerlEditorPlugin.getPluginId(), 0, "The executable specified in EPIC Preferences does not appear to be a valid Perl interpreter.", null);
                    this.getLog().log((IStatus)status);
                    if (!this.requirePerlErrorDisplayed || interactive) {
                        this.requirePerlErrorDisplayed = true;
                        this.showErrorDialog("Missing Perl interpreter", "To operate correctly, EPIC requires a Perl interpreter. Check your configuration settings (\"Window/Preferences/Perl EPIC\").", (IStatus)status);
                    }
                    this.requirePerlCheckPassed = false;
                }
                catch (CoreException e) {
                    this.getLog().log(e.getStatus());
                    if (!this.requirePerlErrorDisplayed || interactive) {
                        this.requirePerlErrorDisplayed = true;
                        this.showErrorDialog("Missing Perl interpreter", "To operate correctly, EPIC requires a Perl interpreter. Check your configuration settings (\"Window/Preferences/Perl EPIC\").", e.getStatus());
                    }
                    this.requirePerlCheckPassed = false;
                }
            }
            Object var5_8 = null;
            executor.dispose();
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            executor.dispose();
            throw throwable;
        }
    }

    private void showErrorDialog(final String title, final String msg, final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)title, (String)msg, (IStatus)status);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        this.colorProvider.dispose();
        super.stop(context);
    }
}

