/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.epic.core.util.SafeClose;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtilities {
    private static final String INCLUDE_FILE_NAME = ".includepath";
    private static final String CHARSET = "UTF-8";

    public String[] getIncludeEntries(IProject project) {
        return this.getIncludeEntries(project, false);
    }

    public String[] getIncludeEntries(IProject project, boolean replaceVariables) {
        ArrayList<String> includes;
        block6: {
            includes = new ArrayList<String>();
            try {
                String fileName = String.valueOf(project.getLocation().toString()) + File.separator + INCLUDE_FILE_NAME;
                File file = new File(fileName);
                if (!file.exists()) break block6;
                SAXBuilder builder = new SAXBuilder(false);
                Document doc = builder.build(file);
                IStringVariableManager varMgr = VariablesPlugin.getDefault().getStringVariableManager();
                Element root = doc.getRootElement();
                List entries = root.getChildren("includepathentry");
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    Element element = (Element)iter.next();
                    String path = element.getAttributeValue("path");
                    if (replaceVariables) {
                        try {
                            String expandedPath;
                            path = expandedPath = varMgr.performStringSubstitution(path);
                        }
                        catch (CoreException e) {
                            path = null;
                            e.printStackTrace();
                        }
                    }
                    if (path == null) continue;
                    includes.add(path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return includes.toArray(new String[includes.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeIncludeEntries(IProject project, String[] items) throws IOException {
        Element root = new Element("includepath");
        int i = 0;
        while (i < items.length) {
            Element entry = new Element("includepathentry");
            entry.setAttribute(new Attribute("path", items[i]));
            root.addContent((Content)entry);
            ++i;
        }
        Document doc = new Document(root);
        String file = String.valueOf(project.getLocation().toString()) + File.separator + INCLUDE_FILE_NAME;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.writeOutput(doc, out);
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            SafeClose.close(out);
            throw throwable;
        }
        SafeClose.close(out);
    }

    private void writeOutput(Document doc, OutputStream out) throws IOException {
        Format xmlFormat = Format.getPrettyFormat();
        xmlFormat.setLineSeparator(System.getProperty("line.separator"));
        xmlFormat.setEncoding(CHARSET);
        XMLOutputter xmlout = new XMLOutputter(xmlFormat);
        xmlout.output(doc, out);
    }
}

