/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.parser;

import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import java.util.HashSet;
import java.util.Set;
import org.epic.core.parser.CurlyToken;
import org.epic.core.parser.LexerBase;
import org.epic.core.parser.OperatorToken;

public abstract class PerlLexerBase
extends LexerBase {
    protected static Set KEYWORDS1 = new HashSet();
    protected static Set KEYWORDS2 = new HashSet();
    protected static Set OPERATORS = new HashSet();
    protected int pc;
    protected boolean qmarkRegexp;
    protected boolean slashRegexp;
    protected boolean glob;
    protected boolean afterColon;
    protected boolean afterArrow;
    protected boolean afterDArrow;
    protected boolean afterSub;
    protected boolean notOper;
    protected boolean format;
    protected boolean proto;

    static {
        PerlLexerBase.initKeywords(KEYWORDS1, new String[]{"BEGIN", "CHECK", "INIT", "END", "UNITCHECK", "bless", "caller", "continue", "dbmclose", "dbmopen", "default", "die", "do", "dump", "else", "elsif", "eval", "exit", "for", "foreach", "given", "goto", "if", "import", "last", "local", "my", "new", "next", "no", "our", "package", "redo", "ref", "require", "return", "state", "sub", "tie", "tied", "unless", "untie", "until", "use", "wantarray", "when", "while"});
        PerlLexerBase.initKeywords(KEYWORDS2, new String[]{"__FILE__", "__LINE__", "__PACKAGE__", "abs", "accept", "alarm", "atan2", "bind", "binmode", "closedir", "for", "lcfirst", "opendir", "printf", "readdir", "readlink", "seekdir", "socketpair", "substr", "telldir", "tied", "times", "ucfirst", "waitpid", "chdir", "chmod", "chomp", "chop", "chown", "chr", "chroot", "close", "connect", "cos", "crypt", "defined", "delete", "each", "endgrent", "endhostent", "endnetent", "endprotoent", "endpwent", "endservent", "eof", "exec", "exists", "exp", "fcntl", "fileno", "flock", "fork", "formline", "getc", "getgrent", "getgrgid", "getgrnam", "gethostbyaddr", "gethostbyname", "gethostent", "getlogin", "getnetbyaddr", "getnetbyname", "getnetent", "getpeername", "getpgrp", "getppid", "getpriority", "getprotobyname", "getprotobynumber", "getprotoent", "getpwent", "getpwnam", "getpwuid", "getservbyname", "getservbyport", "getservent", "getsockname", "getsockopt", "glob", "gmtime", "grep", "hex", "index", "int", "ioctl", "join", "keys", "kill", "lc", "length", "link", "listen", "localtime", "log", "lstat", "map", "mkdir", "msgctl", "msgget", "msgrcv", "msgsnd", "oct", "open", "ord", "pack", "pipe", "pop", "pos", "print", "push", "quotemeta", "rand", "read", "recv", "rename", "reset", "reverse", "rewinddir", "rindex", "rmdir", "say", "scalar", "seek", "select", "semctl", "semget", "semop", "send", "setgrent", "sethostent", "setnetent", "setpgrp", "setpriority", "setprotoent", "setpwent", "setservent", "setsockopt", "shift", "shmctl", "shmget", "shmread", "shmwrite", "shutdown", "sin", "sleep", "socket", "sort", "splice", "split", "sprintf", "sqrt", "srand", "stat", "study", "sub", "symlink", "syscall", "sysread", "sysseek", "system", "syswrite", "tell", "time", "truncate", "uc", "umask", "undef", "unlink", "unpack", "unshift", "utime", "values", "vec", "wait", "warn", "write"});
        PerlLexerBase.initKeywords(OPERATORS, new String[]{"lt", "gt", "le", "ge", "eq", "ne", "cmp", "not", "and", "or", "xor", "x"});
    }

    protected PerlLexerBase() {
    }

    protected PerlLexerBase(InputBuffer cb) {
        super(cb);
    }

    protected PerlLexerBase(LexerSharedInputState sharedState) {
        super(sharedState);
    }

    public int getCurlyLevel() {
        return this.pc;
    }

    public void setInputState(LexerSharedInputState state) {
        super.setInputState(state);
        this.pc = 0;
        this.afterColon = false;
        this.format = false;
        this.afterSub = false;
        this.afterArrow = false;
        this.glob = false;
        this.slashRegexp = false;
        this.qmarkRegexp = false;
    }

    protected CurlyToken createCurlyToken(int type, String text) {
        CurlyToken t = new CurlyToken(type, text, this.pc);
        t.setColumn(this.getColumn() - 1);
        t.setLine(this.getLine());
        t.setOffset(this.getParent().computeTokenOffset(t));
        return t;
    }

    protected OperatorToken createOperatorToken(int type, String text) {
        OperatorToken t = new OperatorToken(type, text);
        t.setColumn(this.getColumn() - text.length());
        t.setLine(this.getLine());
        t.setOffset(this.getParent().computeTokenOffset(t));
        this.slashRegexp = true;
        this.qmarkRegexp = true;
        return t;
    }

    protected boolean isNumber(String word) {
        int len = word.length();
        int i = 0;
        while (i < len) {
            char c = word.charAt(i);
            if ((c < '0' || c > '9') && c != 'x' && c != 'X') {
                return false;
            }
            ++i;
        }
        return true;
    }

    void setCurlyLevel(int level) {
        this.pc = level;
    }

    private static void initKeywords(Set dest, String[] src) {
        int i = 0;
        while (i < src.length) {
            dest.add(src[i]);
            ++i;
        }
    }
}

