/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.decorators;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorDescriptor;
import org.epic.core.Constants;
import org.epic.core.decorators.PerlProjectVisitor;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final String PERL_EDITOR_ID = "org.epic.perleditor.editors.PerlEditor";
    private static final String EMB_PERL_FILE_EXTENSION = "epl";
    private static final String PERL_NATURE_ID = "org.epic.perleditor.perlnature";
    public static int NO_ERROR = -1;
    static final URL BASE_URL = PerlEditorPlugin.getDefault().getBundle().getEntry("/");
    public static final ImageDescriptor ICON_ERROR;
    public static final ImageDescriptor ICON_WARNING;
    static /* synthetic */ Class class$0;

    static {
        String iconPath = "icons/";
        ICON_ERROR = PerlDecorator.createImageDescriptor(String.valueOf(iconPath) + "error_co.gif");
        ICON_WARNING = PerlDecorator.createImageDescriptor(String.valueOf(iconPath) + "warning_co.gif");
    }

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = this.getResource(element);
        boolean isPerlProject = false;
        boolean isPerlFolder = false;
        boolean isPerlFile = false;
        if (!resource.exists()) {
            return;
        }
        IEditorDescriptor defaultEditorDescriptor = PerlEditorPlugin.getDefault().getWorkbench().getEditorRegistry().getDefaultEditor(resource.getFullPath().toString());
        try {
            if (resource.getType() == 4 && resource.getProject().isAccessible() && resource.getProject().hasNature(PERL_NATURE_ID)) {
                isPerlProject = true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            if (resource.getType() == 2 && resource.getProject().isAccessible() && resource.getProject().hasNature(PERL_NATURE_ID)) {
                isPerlFolder = true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!isPerlProject && defaultEditorDescriptor != null) {
            if (!defaultEditorDescriptor.getId().equals(PERL_EDITOR_ID) || EMB_PERL_FILE_EXTENSION.equals(resource.getFileExtension())) {
                return;
            }
            isPerlFile = true;
        }
        if (isPerlProject || isPerlFolder) {
            PerlProjectVisitor projectVisitor = new PerlProjectVisitor();
            try {
                resource.accept((IResourceVisitor)projectVisitor);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            int state = projectVisitor.getState();
            if (state == 2) {
                decoration.addOverlay(ICON_ERROR);
            } else if (state == 1) {
                decoration.addOverlay(ICON_WARNING);
            }
        } else if (isPerlFile) {
            try {
                if (resource.findMarkers(Constants.PROBLEM_MARKER, true, 1).length > 0) {
                    int state = PerlDecorator.getDecoratorMarker(resource);
                    if (state == 2) {
                        decoration.addOverlay(ICON_ERROR);
                    } else if (state == 1) {
                        decoration.addOverlay(ICON_WARNING);
                    }
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static PerlDecorator getPerlDecorator() {
        IDecoratorManager decoratorManager = PerlEditorPlugin.getDefault().getWorkbench().getDecoratorManager();
        if (decoratorManager.getEnabled("org.epic.core.decorators.PerlDecorator")) {
            return (PerlDecorator)decoratorManager.getBaseLabelProvider("org.epic.core.decorators.PerlDecorator");
        }
        return null;
    }

    public void fireLabelEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PerlDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    private IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    private static ImageDescriptor createImageDescriptor(String path) {
        try {
            URL url = new URL(BASE_URL, path);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static int getDecoratorMarker(IResource resource) {
        int state = NO_ERROR;
        try {
            IMarker[] markers = resource.findMarkers(Constants.PROBLEM_MARKER, true, 1);
            int i = 0;
            while (i < markers.length) {
                int severity = (Integer)markers[i].getAttribute("severity");
                if (severity == 2) {
                    state = 2;
                    break;
                }
                if (severity == 1) {
                    state = 1;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return state;
    }
}

